/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.snapshot;

import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IgniteSnapshotManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotOperationRequest;
import org.apache.ignite.internal.processors.metric.GridMetricManager;
import org.apache.ignite.internal.processors.metric.MetricRegistryImpl;
import org.apache.ignite.internal.util.future.IgniteFutureImpl;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.mxbean.SnapshotMXBean;
import org.apache.ignite.spi.metric.IntMetric;

public class SnapshotMXBeanImpl
implements SnapshotMXBean {
    private final IgniteSnapshotManager mgr;
    private final GridMetricManager metricMgr;

    public SnapshotMXBeanImpl(GridKernalContext ctx) {
        this.mgr = ctx.cache().context().snapshotMgr();
        this.metricMgr = ctx.metric();
    }

    @Override
    public void createSnapshot(String snpName, String snpPath) {
        IgniteFutureImpl<Void> fut = this.mgr.createSnapshot(snpName, F.isEmpty(snpPath) ? null : snpPath, false, false);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public void createIncrementalSnapshot(String fullSnapshot, String fullSnapshotPath) {
        IgniteFutureImpl<Void> fut = this.mgr.createSnapshot(fullSnapshot, F.isEmpty(fullSnapshotPath) ? null : fullSnapshotPath, true, false);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public void cancelSnapshot(String snpName) {
        this.mgr.cancelSnapshot(snpName).get();
    }

    @Override
    public void cancelSnapshotOperation(String reqId) {
        this.mgr.cancelSnapshotOperation(UUID.fromString(reqId)).get();
    }

    @Override
    public void restoreSnapshot(String name, String path, String grpNames) {
        Set<String> grpNamesSet = F.isEmpty(grpNames) ? null : Arrays.stream(grpNames.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        IgniteFutureImpl<Void> fut = this.mgr.restoreSnapshot(name, F.isEmpty(path) ? null : path, grpNamesSet);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public void restoreSnapshot(String name, String path, String grpNames, int incIdx) {
        Set<String> grpNamesSet = F.isEmpty(grpNames) ? null : Arrays.stream(grpNames.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toSet());
        IgniteFutureImpl<Void> fut = this.mgr.restoreSnapshot(name, F.isEmpty(path) ? null : path, grpNamesSet, incIdx, false);
        if (fut.isDone()) {
            fut.get();
        }
    }

    @Override
    public void cancelSnapshotRestore(String name) {
        this.mgr.cancelSnapshotRestore(name).get();
    }

    @Override
    public String status() {
        SnapshotOperationRequest req = this.mgr.currentCreateRequest();
        if (req != null) {
            return "Create snapshot operation is in progress [name=" + req.snapshotName() + ", incremental=" + req.incremental() + (String)(req.incremental() ? ", incrementIndex=" + req.incrementIndex() : "") + ", id=" + req.requestId() + "]";
        }
        if (this.mgr.isRestoring()) {
            MetricRegistryImpl mreg = this.metricMgr.registry("snapshot-restore");
            String name = mreg.findMetric("snapshotName").getAsString();
            int incIdx = ((IntMetric)mreg.findMetric("incrementIndex")).value();
            String id = mreg.findMetric("requestId").getAsString();
            boolean incremental = incIdx > 0;
            return "Restore snapshot operation is in progress [name=" + name + ", incremental=" + incremental + (String)(incremental ? ", incrementIndex=" + incIdx : "") + ", id=" + id + "]";
        }
        return "There is no create or restore snapshot operation in progress.";
    }
}

