/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.client;

import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.odbc.ClientListenerResponse;
import org.apache.ignite.internal.processors.platform.client.ClientConnectionContext;
import org.apache.ignite.internal.processors.platform.client.ClientOutgoingMessage;

public class ClientNotification
extends ClientListenerResponse
implements ClientOutgoingMessage {
    private final long rsrcId;
    private final short opCode;

    public ClientNotification(short opCode, long rsrcId) {
        super(0, null);
        this.rsrcId = rsrcId;
        this.opCode = opCode;
    }

    public ClientNotification(short opCode, long rsrcId, String err) {
        super(1, err);
        this.rsrcId = rsrcId;
        this.opCode = opCode;
    }

    public ClientNotification(short opCode, long rsrcId, int status, String err) {
        super(status, err);
        this.rsrcId = rsrcId;
        this.opCode = opCode;
    }

    @Override
    public void encode(ClientConnectionContext ctx, BinaryRawWriterEx writer) {
        writer.writeLong(this.rsrcId);
        short flags = (short)(4 | (this.status() == 0 ? 0 : 1));
        writer.writeShort(flags);
        writer.writeShort(this.opCode);
        if (this.status() != 0) {
            writer.writeInt(this.status());
            writer.writeString(this.error());
        }
    }

    public long resourceId() {
        return this.rsrcId;
    }
}

