package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.ExtentSpatialGridInnerCoordinatesInner;
import org.apache.baremaps.ogcapi.model.ExtentSpatialGridInnerResolution;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("extent_spatial_grid_inner")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class ExtentSpatialGridInner   {
  private @Valid List<ExtentSpatialGridInnerCoordinatesInner> coordinates = null;
  private @Valid Integer cellsCount;
  private @Valid ExtentSpatialGridInnerResolution resolution;

  /**
   * List of coordinates along the dimension for which data organized as an irregular grid in the collection is available (e.g., 2, 10, 80, 100).
   **/
  public ExtentSpatialGridInner coordinates(List<ExtentSpatialGridInnerCoordinatesInner> coordinates) {
    this.coordinates = coordinates;
    return this;
  }

  
  @ApiModelProperty(value = "List of coordinates along the dimension for which data organized as an irregular grid in the collection is available (e.g., 2, 10, 80, 100).")
  @JsonProperty("coordinates")
 @Size(min=1)  public List<ExtentSpatialGridInnerCoordinatesInner> getCoordinates() {
    return coordinates;
  }

  @JsonProperty("coordinates")
  public void setCoordinates(List<ExtentSpatialGridInnerCoordinatesInner> coordinates) {
    this.coordinates = coordinates;
  }

  public ExtentSpatialGridInner addCoordinatesItem(ExtentSpatialGridInnerCoordinatesInner coordinatesItem) {
    if (this.coordinates == null) {
      this.coordinates = new ArrayList<>();
    }

    this.coordinates.add(coordinatesItem);
    return this;
  }

  public ExtentSpatialGridInner removeCoordinatesItem(ExtentSpatialGridInnerCoordinatesInner coordinatesItem) {
    if (coordinatesItem != null && this.coordinates != null) {
      this.coordinates.remove(coordinatesItem);
    }

    return this;
  }
  /**
   * Number of samples available along the dimension for data organized as a regular grid. For values representing the whole area of contiguous cells spanning _resolution_ units along the dimension, this will be (_upperBound_ - _lowerBound_) / _resolution_. For values representing infinitely small point cells spaced by _resolution_ units along the dimension, this will be (_upperBound_ - _lowerBound_) / _resolution_ + 1.
   **/
  public ExtentSpatialGridInner cellsCount(Integer cellsCount) {
    this.cellsCount = cellsCount;
    return this;
  }

  
  @ApiModelProperty(value = "Number of samples available along the dimension for data organized as a regular grid. For values representing the whole area of contiguous cells spanning _resolution_ units along the dimension, this will be (_upperBound_ - _lowerBound_) / _resolution_. For values representing infinitely small point cells spaced by _resolution_ units along the dimension, this will be (_upperBound_ - _lowerBound_) / _resolution_ + 1.")
  @JsonProperty("cellsCount")
  public Integer getCellsCount() {
    return cellsCount;
  }

  @JsonProperty("cellsCount")
  public void setCellsCount(Integer cellsCount) {
    this.cellsCount = cellsCount;
  }

  /**
   **/
  public ExtentSpatialGridInner resolution(ExtentSpatialGridInnerResolution resolution) {
    this.resolution = resolution;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("resolution")
  public ExtentSpatialGridInnerResolution getResolution() {
    return resolution;
  }

  @JsonProperty("resolution")
  public void setResolution(ExtentSpatialGridInnerResolution resolution) {
    this.resolution = resolution;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExtentSpatialGridInner extentSpatialGridInner = (ExtentSpatialGridInner) o;
    return Objects.equals(this.coordinates, extentSpatialGridInner.coordinates) &&
        Objects.equals(this.cellsCount, extentSpatialGridInner.cellsCount) &&
        Objects.equals(this.resolution, extentSpatialGridInner.resolution);
  }

  @Override
  public int hashCode() {
    return Objects.hash(coordinates, cellsCount, resolution);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExtentSpatialGridInner {\n");
    
    sb.append("    coordinates: ").append(toIndentedString(coordinates)).append("\n");
    sb.append("    cellsCount: ").append(toIndentedString(cellsCount)).append("\n");
    sb.append("    resolution: ").append(toIndentedString(resolution)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

