/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.iotdb.db.protocol.influxdb.input.InfluxLineProtocolLexer;
import org.apache.iotdb.db.protocol.influxdb.input.InfluxLineProtocolParser;
import org.apache.iotdb.db.qp.utils.DateTimeUtils;
import org.influxdb.InfluxDBException;
import org.influxdb.dto.Point;

public class InfluxLineParser {
    private static final Pattern BACKSLASH_PATTERN = Pattern.compile("\\\\\"");
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("\\\\([,= ])");

    public static List<Point> parserRecordsToPoints(String records) {
        return InfluxLineParser.parserRecordsToPoints(records, null);
    }

    public static List<Point> parserRecordsToPointsWithPrecision(String records, String precision) {
        return InfluxLineParser.parserRecordsToPoints(records, DateTimeUtils.toTimeUnit(precision));
    }

    public static List<Point> parserRecordsToPoints(String records, TimeUnit precision) {
        String[] recordsSplit;
        if (precision == null) {
            precision = TimeUnit.NANOSECONDS;
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (String record : recordsSplit = records.split("\n")) {
            points.add(InfluxLineParser.parseToPoint(record, precision));
        }
        return points;
    }

    public static Point parseToPoint(String input) {
        return InfluxLineParser.parseToPoint(input, null);
    }

    public static Point parseToPoint(String input, TimeUnit precision) {
        if (precision == null) {
            precision = TimeUnit.NANOSECONDS;
        }
        ANTLRInputStream charStream = new ANTLRInputStream(input);
        InfluxLineProtocolLexer lexer = new InfluxLineProtocolLexer((CharStream)charStream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        InfluxLineProtocolParser parser = new InfluxLineProtocolParser((TokenStream)tokenStream);
        List lines = parser.lines().line();
        if (parser.getNumberOfSyntaxErrors() != 0) {
            throw new InfluxDBException("Unable to parse line.");
        }
        if (lines.size() != 1) {
            throw new InfluxDBException("Multiple lines present; unable to parse more than one per record.");
        }
        HashMap tags = new HashMap();
        HashMap fields = new HashMap();
        Long timestamp = null;
        InfluxLineProtocolParser.LineContext line = (InfluxLineProtocolParser.LineContext)lines.get(0);
        String measurement = InfluxLineParser.parseIdentifier(line.identifier());
        Point.Builder builder = Point.measurement((String)measurement);
        if (line.tag_set() != null) {
            line.tag_set().tag_pair().forEach(t -> InfluxLineParser.parseTag(t, tags));
        }
        line.field_set().field_pair().forEach(t -> InfluxLineParser.parseField(t, fields));
        if (line.timestamp() != null) {
            String timestampString = line.timestamp().getText();
            timestamp = InfluxLineParser.parseTimestamp(timestampString);
        }
        if (timestamp == null) {
            timestamp = System.currentTimeMillis();
        }
        return builder.tag(tags).fields(fields).time(timestamp, precision).build();
    }

    private static void parseTag(InfluxLineProtocolParser.Tag_pairContext tag, Map<String, String> out) {
        String key = InfluxLineParser.parseIdentifier(tag.identifier(0));
        String value = InfluxLineParser.parseIdentifier(tag.identifier(1));
        out.put(key, value);
    }

    private static void parseField(InfluxLineProtocolParser.Field_pairContext field, Map<String, Object> out) {
        String key = InfluxLineParser.parseIdentifier(field.identifier());
        InfluxLineProtocolParser.Field_valueContext valueContext = field.field_value();
        Object value = valueContext.NUMBER() != null ? InfluxLineParser.parseNumber(valueContext.NUMBER().getText()) : (valueContext.BOOLEAN() != null ? InfluxLineParser.parseBool(valueContext.BOOLEAN().getText()) : InfluxLineParser.parseQuotedString(valueContext.QUOTED_STRING().getText()));
        out.put(key, value);
    }

    private static Object parseQuotedString(String text) {
        return BACKSLASH_PATTERN.matcher(text.substring(1, text.length() - 1)).replaceAll("\"");
    }

    private static Object parseNumber(String raw) {
        if (raw.endsWith("i")) {
            return Long.valueOf(raw.substring(0, raw.length() - 1));
        }
        return new Double(raw);
    }

    private static Object parseBool(String raw) {
        char first = raw.charAt(0);
        if (first == 't' || first == 'T') {
            return "true";
        }
        return "false";
    }

    private static String parseIdentifier(InfluxLineProtocolParser.IdentifierContext ctx) {
        if (ctx.BOOLEAN() != null || ctx.NUMBER() != null) {
            return ctx.getText();
        }
        return IDENTIFIER_PATTERN.matcher(ctx.IDENTIFIER_STRING().getText()).replaceAll("$1");
    }

    private static Long parseTimestamp(String timestamp) {
        if (timestamp.length() < 7) {
            return 0L;
        }
        return Long.parseLong(timestamp);
    }
}

