/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cli.utils;

import java.io.PrintStream;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class IoTPrinter {
    private final PrintStream screenPrinter;

    public IoTPrinter(PrintStream screenPrinter) {
        this.screenPrinter = screenPrinter;
    }

    public void printf(String format, Object ... args) {
        this.screenPrinter.printf(format, args);
    }

    public void print(String msg) {
        this.screenPrinter.print(msg);
    }

    public void printException(Exception msg) {
        this.screenPrinter.println(msg);
    }

    public void println() {
        this.screenPrinter.println();
    }

    public void println(String msg) {
        this.screenPrinter.println(msg);
    }

    public void printBlockLine(List<Integer> maxSizeList) {
        StringBuilder blockLine = new StringBuilder();
        for (Integer integer : maxSizeList) {
            blockLine.append("+").append(StringUtils.repeat((String)"-", (int)integer));
        }
        blockLine.append("+");
        this.println(blockLine.toString());
    }

    public void printRow(List<List<String>> lists, int i, List<Integer> maxSizeList) {
        this.printf("|", new Object[0]);
        for (int j = 0; j < maxSizeList.size(); ++j) {
            int maxSize = maxSizeList.get(j);
            String element = lists.get(j).get(i);
            int count = this.computeHANCount(element);
            if (count > 0) {
                int remain = maxSize - (element.length() + count);
                if (remain > 0) {
                    StringBuilder paddingStr = this.padding(remain);
                    maxSize -= count;
                    element = paddingStr.append(element).toString();
                } else if (remain == 0) {
                    maxSize -= count;
                }
            }
            this.printf("%" + maxSize + "s|", element);
        }
        this.println();
    }

    public void printCount(int cnt) {
        if (cnt == 0) {
            this.println("Empty set.");
        } else {
            this.println("Total line number = " + cnt);
        }
    }

    public StringBuilder padding(int count) {
        StringBuilder sb = new StringBuilder();
        for (int k = 0; k < count; ++k) {
            sb.append(' ');
        }
        return sb;
    }

    public int computeHANCount(String s) {
        return (int)s.codePoints().filter(codePoint -> Character.UnicodeScript.of(codePoint) == Character.UnicodeScript.HAN).count();
    }
}

