/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.encoding.decoder;

import java.nio.ByteBuffer;
import org.apache.tsfile.encoding.decoder.Decoder;
import org.apache.tsfile.encoding.decoder.IntZigzagDecoder;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.apache.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongZigzagDecoder
extends Decoder {
    private static final Logger logger = LoggerFactory.getLogger(IntZigzagDecoder.class);
    private int length;
    private int number;
    private int currentCount;
    private ByteBuffer byteCache;

    public LongZigzagDecoder() {
        super(TSEncoding.ZIGZAG);
        this.reset();
        logger.debug("tsfile-encoding LongZigzagDecoder: long zigzag decoder");
    }

    @Override
    public long readLong(ByteBuffer buffer) {
        if (this.currentCount == 0) {
            this.reset();
            this.getLengthAndNumber(buffer);
            this.currentCount = this.number;
        }
        long n = 0L;
        int i = 0;
        long b = 0L;
        while (this.byteCache.hasRemaining() && ((b = (long)this.byteCache.get()) & 0x80L) != 0L) {
            n |= (b & 0x7FL) << i;
            i += 7;
        }
        --this.currentCount;
        return (n |= b << i) >>> 1 ^ -(n & 1L);
    }

    private void getLengthAndNumber(ByteBuffer buffer) {
        this.length = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        this.number = ReadWriteForEncodingUtils.readUnsignedVarInt(buffer);
        byte[] tmp = new byte[this.length];
        buffer.get(tmp, 0, this.length);
        this.byteCache = ByteBuffer.wrap(tmp);
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) {
        return this.currentCount > 0 || buffer.remaining() > 0;
    }

    @Override
    public void reset() {
        this.length = 0;
        this.number = 0;
        this.currentCount = 0;
        if (this.byteCache == null) {
            this.byteCache = ByteBuffer.allocate(0);
        } else {
            this.byteCache.position(0);
        }
    }
}

