/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.coordinator.task;

import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTaskCoordinatorLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTaskCoordinatorLock.class);
    private final BlockingDeque<Long> deque = new LinkedBlockingDeque<Long>(1);
    private final AtomicLong idGenerator = new AtomicLong(0L);

    public void lock() {
        try {
            long id = this.idGenerator.incrementAndGet();
            LOGGER.debug("PipeTaskCoordinator lock (id: {}) waiting for thread {}", (Object)id, (Object)Thread.currentThread().getName());
            this.deque.put(id);
            LOGGER.debug("PipeTaskCoordinator lock (id: {}) acquired by thread {}", (Object)id, (Object)Thread.currentThread().getName());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while waiting for PipeTaskCoordinator lock, current thread: {}", (Object)Thread.currentThread().getName());
        }
    }

    public boolean tryLock() {
        try {
            long id = this.idGenerator.incrementAndGet();
            LOGGER.debug("PipeTaskCoordinator lock (id: {}) waiting for thread {}", (Object)id, (Object)Thread.currentThread().getName());
            if (this.deque.offer(id, 10L, TimeUnit.SECONDS)) {
                LOGGER.debug("PipeTaskCoordinator lock (id: {}) acquired by thread {}", (Object)id, (Object)Thread.currentThread().getName());
                return true;
            }
            LOGGER.info("PipeTaskCoordinator lock (id: {}) failed to acquire by thread {} because of timeout", (Object)id, (Object)Thread.currentThread().getName());
            return false;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error("Interrupted while waiting for PipeTaskCoordinator lock, current thread: {}", (Object)Thread.currentThread().getName());
            return false;
        }
    }

    public void unlock() {
        Long id = this.deque.poll();
        if (id == null) {
            LOGGER.error("PipeTaskCoordinator lock released by thread {} but the lock is not acquired by any thread", (Object)Thread.currentThread().getName());
        } else {
            LOGGER.debug("PipeTaskCoordinator lock (id: {}) released by thread {}", (Object)id, (Object)Thread.currentThread().getName());
        }
    }

    public boolean isLocked() {
        return !this.deque.isEmpty();
    }
}

