/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.join;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.queryengine.execution.MemoryEstimationHelper;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.ProcessOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.read.common.block.column.TimeColumnBuilder;
import org.apache.tsfile.utils.RamUsageEstimator;

public class InnerTimeJoinOperator
implements ProcessOperator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(InnerTimeJoinOperator.class);
    private final OperatorContext operatorContext;
    private final long maxReturnSize = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    private final int[] inputIndex;
    private final List<Operator> children;
    private final int inputOperatorsCount;
    private final TsBlock[] inputTsBlocks;
    private final boolean[] canCallNext;
    private final TsBlockBuilder resultBuilder;
    private final TimeComparator comparator;
    private final Map<InputLocation, Integer> outputColumnMap;
    private int currentChildIndex = 0;
    private boolean hasEmptyChildInput = false;

    public InnerTimeJoinOperator(OperatorContext operatorContext, List<Operator> children, List<TSDataType> dataTypes, TimeComparator comparator, Map<InputLocation, Integer> outputColumnMap) {
        this.operatorContext = operatorContext;
        this.children = children;
        this.inputOperatorsCount = children.size();
        this.inputTsBlocks = new TsBlock[this.inputOperatorsCount];
        this.canCallNext = new boolean[this.inputOperatorsCount];
        Preconditions.checkArgument((children.size() > 1 ? 1 : 0) != 0, (Object)"child size of InnerTimeJoinOperator should be larger than 1");
        this.inputIndex = new int[this.inputOperatorsCount];
        this.resultBuilder = new TsBlockBuilder(dataTypes);
        this.comparator = comparator;
        this.outputColumnMap = outputColumnMap;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        boolean hasReadyChild = false;
        ArrayList listenableFutures = new ArrayList();
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i)) continue;
            ListenableFuture<?> blocked = this.children.get(i).isBlocked();
            if (blocked.isDone()) {
                hasReadyChild = true;
                this.canCallNext[i] = true;
                continue;
            }
            listenableFutures.add(blocked);
        }
        return hasReadyChild || listenableFutures.isEmpty() ? NOT_BLOCKED : Futures.successfulAsList(listenableFutures);
    }

    @Override
    public TsBlock next() throws Exception {
        long maxRuntime = this.operatorContext.getMaxRunTime().roundTo(TimeUnit.NANOSECONDS);
        long start = System.nanoTime();
        if (!this.prepareInput(start, maxRuntime)) {
            return null;
        }
        if (System.nanoTime() - start < maxRuntime) {
            long currentEndTime = 0L;
            boolean init = false;
            for (int i = 0; i < this.inputOperatorsCount; ++i) {
                currentEndTime = init ? this.comparator.getCurrentEndTime(currentEndTime, this.inputTsBlocks[i].getEndTime()) : this.inputTsBlocks[i].getEndTime();
                init = true;
            }
            int[][] selectedRowIndexArray = this.buildTimeColumn(currentEndTime);
            if (selectedRowIndexArray[0].length > 0) {
                for (int i = 0; i < this.inputOperatorsCount; ++i) {
                    this.buildValueColumns(i, selectedRowIndexArray[i]);
                }
            }
        }
        this.cleanUpInputTsBlock();
        TsBlock res = this.resultBuilder.build();
        this.resultBuilder.reset();
        return res;
    }

    private int[][] buildTimeColumn(long currentEndTime) {
        TimeColumnBuilder timeBuilder = this.resultBuilder.getTimeColumnBuilder();
        ArrayList<List<Integer>> selectedRowIndexArray = new ArrayList<List<Integer>>(this.inputOperatorsCount);
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            selectedRowIndexArray.add(new ArrayList());
        }
        int column0Size = this.inputTsBlocks[0].getPositionCount();
        while (this.inputIndex[0] < column0Size && this.comparator.canContinueInclusive(this.inputTsBlocks[0].getTimeByIndex(this.inputIndex[0]), currentEndTime)) {
            long time = this.inputTsBlocks[0].getTimeByIndex(this.inputIndex[0]);
            this.inputIndex[0] = this.inputIndex[0] + 1;
            boolean allHave = true;
            int i = 1;
            while (i < this.inputOperatorsCount) {
                int size = this.inputTsBlocks[i].getPositionCount();
                this.updateInputIndex(i, time);
                if (this.inputIndex[i] == size || this.inputTsBlocks[i].getTimeByIndex(this.inputIndex[i]) != time) {
                    allHave = false;
                    break;
                }
                int n = i++;
                this.inputIndex[n] = this.inputIndex[n] + 1;
            }
            if (!allHave) continue;
            timeBuilder.writeLong(time);
            this.resultBuilder.declarePosition();
            this.appendOneSelectedRow(selectedRowIndexArray);
        }
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            this.updateInputIndexUntilLargerThan(i, currentEndTime);
        }
        return this.transformListToIntArray(selectedRowIndexArray);
    }

    private void appendOneSelectedRow(List<List<Integer>> selectedRowIndexArray) {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            selectedRowIndexArray.get(i).add(this.inputIndex[i] - 1);
        }
    }

    private void updateInputIndex(int i, long currentEndTime) {
        int size = this.inputTsBlocks[i].getPositionCount();
        while (this.inputIndex[i] < size && this.comparator.lessThan(this.inputTsBlocks[i].getTimeByIndex(this.inputIndex[i]), currentEndTime)) {
            int n = i;
            this.inputIndex[n] = this.inputIndex[n] + 1;
        }
    }

    private void updateInputIndexUntilLargerThan(int i, long currentEndTime) {
        int size = this.inputTsBlocks[i].getPositionCount();
        while (this.inputIndex[i] < size && this.comparator.canContinueInclusive(this.inputTsBlocks[i].getTimeByIndex(this.inputIndex[i]), currentEndTime)) {
            int n = i;
            this.inputIndex[n] = this.inputIndex[n] + 1;
        }
    }

    private void cleanUpInputTsBlock() {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.inputTsBlocks[i].getPositionCount() != this.inputIndex[i]) continue;
            this.inputTsBlocks[i] = null;
            this.inputIndex[i] = 0;
        }
    }

    private int[][] transformListToIntArray(List<List<Integer>> lists) {
        if (lists.size() <= 1) {
            throw new IllegalStateException("Child size of InnerTimeJoinOperator should be larger than 1.");
        }
        int[][] res = new int[lists.size()][lists.get(0).size()];
        for (int i = 0; i < res.length; ++i) {
            List<Integer> list = lists.get(i);
            int[] array = res[i];
            if (list.size() != array.length) {
                throw new IllegalStateException("All child should have same time column result!");
            }
            for (int j = 0; j < array.length; ++j) {
                array[j] = list.get(j);
            }
        }
        return res;
    }

    private void buildValueColumns(int childIndex, int[] selectedRowIndex) {
        TsBlock tsBlock = this.inputTsBlocks[childIndex];
        int size = this.inputTsBlocks[childIndex].getValueColumnCount();
        for (int i = 0; i < size; ++i) {
            ColumnBuilder columnBuilder = this.resultBuilder.getColumnBuilder(this.outputColumnMap.get(new InputLocation(childIndex, i)).intValue());
            Column column = tsBlock.getColumn(i);
            if (column.mayHaveNull()) {
                for (int rowIndex : selectedRowIndex) {
                    if (column.isNull(rowIndex)) {
                        columnBuilder.appendNull();
                        continue;
                    }
                    columnBuilder.write(column, rowIndex);
                }
                continue;
            }
            for (int rowIndex : selectedRowIndex) {
                columnBuilder.write(column, rowIndex);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean prepareInput(long start, long maxRuntime) throws Exception {
        while (System.nanoTime() - start < maxRuntime && this.currentChildIndex < this.inputOperatorsCount) {
            if (!this.isEmpty(this.currentChildIndex)) {
                ++this.currentChildIndex;
                continue;
            }
            if (this.canCallNext[this.currentChildIndex]) {
                if (!this.children.get(this.currentChildIndex).hasNextWithTimer()) return false;
                this.inputIndex[this.currentChildIndex] = 0;
                this.inputTsBlocks[this.currentChildIndex] = this.children.get(this.currentChildIndex).nextWithTimer();
                this.canCallNext[this.currentChildIndex] = false;
                if (this.isEmpty(this.currentChildIndex)) {
                    this.hasEmptyChildInput = true;
                }
            } else {
                this.hasEmptyChildInput = true;
            }
            ++this.currentChildIndex;
        }
        if (this.currentChildIndex != this.inputOperatorsCount) return false;
        this.currentChildIndex = 0;
        if (!this.hasEmptyChildInput) {
            return true;
        }
        this.hasEmptyChildInput = false;
        return false;
    }

    @Override
    public boolean hasNext() throws Exception {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i) || !this.canCallNext[i] || this.children.get(i).hasNextWithTimer()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (this.children.get(i) == null) continue;
            this.children.get(i).close();
        }
    }

    @Override
    public boolean isFinished() throws Exception {
        for (int i = 0; i < this.inputOperatorsCount; ++i) {
            if (!this.isEmpty(i) || !this.children.get(i).isFinished()) continue;
            return true;
        }
        return false;
    }

    @Override
    public long calculateMaxPeekMemory() {
        long maxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (Operator child : this.children) {
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, maxPeekMemory + child.calculateMaxPeekMemoryWithCounter());
            maxPeekMemory += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        return Math.max(maxPeekMemory += this.calculateMaxReturnSize(), childrenMaxPeekMemory);
    }

    @Override
    public long calculateMaxReturnSize() {
        return this.maxReturnSize;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        long currentRetainedSize = 0L;
        long minChildReturnSize = Long.MAX_VALUE;
        for (Operator child : this.children) {
            long tmpMaxReturnSize = child.calculateMaxReturnSize();
            currentRetainedSize += tmpMaxReturnSize + child.calculateRetainedSizeAfterCallingNext();
            minChildReturnSize = Math.min(minChildReturnSize, tmpMaxReturnSize);
        }
        return currentRetainedSize - minChildReturnSize;
    }

    public long ramBytesUsed() {
        return INSTANCE_SIZE + this.children.stream().mapToLong(MemoryEstimationHelper::getEstimatedSizeOfAccountableObject).sum() + MemoryEstimationHelper.getEstimatedSizeOfAccountableObject(this.operatorContext) + RamUsageEstimator.sizeOf((boolean[])this.canCallNext) + RamUsageEstimator.sizeOf((int[])this.inputIndex) + this.resultBuilder.getRetainedSizeInBytes();
    }

    protected boolean isEmpty(int columnIndex) {
        return this.inputTsBlocks[columnIndex] == null || this.inputTsBlocks[columnIndex].getPositionCount() == this.inputIndex[columnIndex];
    }
}

