/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.subscription;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.subscription.AbstractOperateSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOperateSubscriptionAndPipeProcedure
extends AbstractOperateSubscriptionProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOperateSubscriptionAndPipeProcedure.class);
    protected AtomicReference<PipeTaskInfo> pipeTaskInfo;

    @Override
    protected ProcedureLockState acquireLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        LOGGER.info("ProcedureId {} try to acquire subscription and pipe lock.", (Object)this.getProcId());
        this.pipeTaskInfo = configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().lock();
        if (this.pipeTaskInfo == null) {
            LOGGER.warn("ProcedureId {} failed to acquire pipe lock.", (Object)this.getProcId());
        } else {
            LOGGER.info("ProcedureId {} acquired pipe lock.", (Object)this.getProcId());
        }
        ProcedureLockState procedureLockState = super.acquireLock(configNodeProcedureEnv);
        switch (procedureLockState) {
            case LOCK_ACQUIRED: {
                if (this.pipeTaskInfo == null) {
                    LOGGER.warn("ProcedureId {}: LOCK_ACQUIRED. The following procedure should not be executed without pipe lock.", (Object)this.getProcId());
                    break;
                }
                LOGGER.info("ProcedureId {}: LOCK_ACQUIRED. The following procedure should be executed with subscription and pipe lock.", (Object)this.getProcId());
                break;
            }
            case LOCK_EVENT_WAIT: {
                if (this.pipeTaskInfo == null) {
                    LOGGER.warn("ProcedureId {}: LOCK_EVENT_WAIT. Without acquiring pipe lock.", (Object)this.getProcId());
                    break;
                }
                LOGGER.info("ProcedureId {}: LOCK_EVENT_WAIT. Pipe lock will be released.", (Object)this.getProcId());
                configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
                this.pipeTaskInfo = null;
                break;
            }
            default: {
                if (this.pipeTaskInfo == null) {
                    LOGGER.error("ProcedureId {}: {}. Invalid lock state. Without acquiring pipe lock.", (Object)this.getProcId(), (Object)procedureLockState);
                    break;
                }
                LOGGER.error("ProcedureId {}: {}. Invalid lock state. Pipe lock will be released.", (Object)this.getProcId(), (Object)procedureLockState);
                configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
                this.pipeTaskInfo = null;
            }
        }
        return procedureLockState;
    }

    @Override
    protected void releaseLock(ConfigNodeProcedureEnv configNodeProcedureEnv) {
        super.releaseLock(configNodeProcedureEnv);
        if (this.pipeTaskInfo == null) {
            LOGGER.warn("ProcedureId {} release lock. No need to release pipe lock.", (Object)this.getProcId());
        } else {
            LOGGER.info("ProcedureId {} release lock. Pipe lock will be released.", (Object)this.getProcId());
            configNodeProcedureEnv.getConfigManager().getPipeManager().getPipeTaskCoordinator().unlock();
            this.pipeTaskInfo = null;
        }
    }

    protected Map<Integer, TPushPipeMetaResp> pushMultiPipeMetaToDataNodes(List<String> pipeNames, ConfigNodeProcedureEnv env) throws IOException {
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        for (String pipeName : pipeNames) {
            PipeMeta pipeMeta = this.pipeTaskInfo.get().getPipeMetaByPipeName(pipeName);
            if (pipeMeta == null) {
                LOGGER.warn("Pipe {} not found in PipeTaskInfo, can not push its meta.", (Object)pipeName);
                continue;
            }
            pipeMetaBinaryList.add(AbstractOperatePipeProcedureV2.copyAndFilterOutNonWorkingDataRegionPipeTasks(pipeMeta).serialize());
        }
        return env.pushMultiPipeMetaToDataNodes(pipeMetaBinaryList);
    }

    protected Map<Integer, TPushPipeMetaResp> dropMultiPipeOnDataNodes(List<String> pipeNames, ConfigNodeProcedureEnv env) {
        return env.dropMultiPipeOnDataNodes(pipeNames);
    }
}

