/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class FindServersRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=420");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=422");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=421");
    private final RequestHeader requestHeader;
    private final String endpointUrl;
    private final String[] localeIds;
    private final String[] serverUris;

    public FindServersRequest(RequestHeader requestHeader, String endpointUrl, String[] localeIds, String[] serverUris) {
        this.requestHeader = requestHeader;
        this.endpointUrl = endpointUrl;
        this.localeIds = localeIds;
        this.serverUris = serverUris;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public String[] getLocaleIds() {
        return this.localeIds;
    }

    public String[] getServerUris() {
        return this.serverUris;
    }

    protected FindServersRequest(FindServersRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((FindServersRequestBuilder)b).requestHeader;
        this.endpointUrl = ((FindServersRequestBuilder)b).endpointUrl;
        this.localeIds = ((FindServersRequestBuilder)b).localeIds;
        this.serverUris = ((FindServersRequestBuilder)b).serverUris;
    }

    public static FindServersRequestBuilder<?, ?> builder() {
        return new FindServersRequestBuilderImpl();
    }

    public FindServersRequestBuilder<?, ?> toBuilder() {
        return new FindServersRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindServersRequest)) {
            return false;
        }
        FindServersRequest other = (FindServersRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        String this$endpointUrl = this.getEndpointUrl();
        String other$endpointUrl = other.getEndpointUrl();
        if (this$endpointUrl == null ? other$endpointUrl != null : !this$endpointUrl.equals(other$endpointUrl)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getLocaleIds(), other.getLocaleIds())) {
            return false;
        }
        return Arrays.deepEquals(this.getServerUris(), other.getServerUris());
    }

    protected boolean canEqual(Object other) {
        return other instanceof FindServersRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        String $endpointUrl = this.getEndpointUrl();
        result = result * 59 + ($endpointUrl == null ? 43 : $endpointUrl.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getLocaleIds());
        result = result * 59 + Arrays.deepHashCode(this.getServerUris());
        return result;
    }

    @Override
    public String toString() {
        return "FindServersRequest(requestHeader=" + this.getRequestHeader() + ", endpointUrl=" + this.getEndpointUrl() + ", localeIds=" + Arrays.deepToString(this.getLocaleIds()) + ", serverUris=" + Arrays.deepToString(this.getServerUris()) + ")";
    }

    private static final class FindServersRequestBuilderImpl
    extends FindServersRequestBuilder<FindServersRequest, FindServersRequestBuilderImpl> {
        private FindServersRequestBuilderImpl() {
        }

        @Override
        protected FindServersRequestBuilderImpl self() {
            return this;
        }

        @Override
        public FindServersRequest build() {
            return new FindServersRequest(this);
        }
    }

    public static abstract class FindServersRequestBuilder<C extends FindServersRequest, B extends FindServersRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private String endpointUrl;
        private String[] localeIds;
        private String[] serverUris;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FindServersRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(FindServersRequest instance, FindServersRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.endpointUrl(instance.endpointUrl);
            b.localeIds(instance.localeIds);
            b.serverUris(instance.serverUris);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return (B)this.self();
        }

        public B localeIds(String[] localeIds) {
            this.localeIds = localeIds;
            return (B)this.self();
        }

        public B serverUris(String[] serverUris) {
            this.serverUris = serverUris;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "FindServersRequest.FindServersRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", endpointUrl=" + this.endpointUrl + ", localeIds=" + Arrays.deepToString(this.localeIds) + ", serverUris=" + Arrays.deepToString(this.serverUris) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<FindServersRequest> {
        @Override
        public Class<FindServersRequest> getType() {
            return FindServersRequest.class;
        }

        @Override
        public FindServersRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            String endpointUrl = decoder.readString("EndpointUrl");
            String[] localeIds = decoder.readStringArray("LocaleIds");
            String[] serverUris = decoder.readStringArray("ServerUris");
            return new FindServersRequest(requestHeader, endpointUrl, localeIds, serverUris);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, FindServersRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeString("EndpointUrl", value.getEndpointUrl());
            encoder.writeStringArray("LocaleIds", value.getLocaleIds());
            encoder.writeStringArray("ServerUris", value.getServerUris());
        }
    }
}

