/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.pattern;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.datastructure.pattern.TreePattern;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.tsfile.file.metadata.IDeviceID;

public class PrefixTreePattern
extends TreePattern {
    public PrefixTreePattern(boolean isTreeModelDataAllowedToBeCaptured, String pattern) {
        super(isTreeModelDataAllowedToBeCaptured, pattern);
    }

    public PrefixTreePattern(String pattern) {
        this(true, pattern);
    }

    @Override
    public String getDefaultPattern() {
        return "root";
    }

    @Override
    public boolean isLegal() {
        if (!this.pattern.startsWith("root")) {
            return false;
        }
        try {
            PathUtils.isLegalPath(this.pattern);
        }
        catch (IllegalPathException e) {
            try {
                if ("root".equals(this.pattern) || "root.".equals(this.pattern)) {
                    return true;
                }
                String[] pathNodes = StringUtils.splitPreserveAllTokens((String)this.pattern, (String)"\\.");
                PathUtils.splitPathToDetachedNodes(String.join((CharSequence)".", Arrays.copyOfRange(pathNodes, 0, pathNodes.length - 1)));
                String lastNode = pathNodes[pathNodes.length - 1];
                if (!"".equals(lastNode)) {
                    Double.parseDouble(lastNode);
                }
            }
            catch (Exception ignored) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean coversDb(String db) {
        return this.pattern.length() <= db.length() && db.startsWith(this.pattern);
    }

    @Override
    public boolean coversDevice(IDeviceID device) {
        String deviceStr = device.toString();
        return this.pattern.length() <= deviceStr.length() && deviceStr.startsWith(this.pattern);
    }

    @Override
    public boolean mayOverlapWithDb(String db) {
        return this.pattern.length() <= db.length() && db.startsWith(this.pattern) || this.pattern.length() > db.length() && this.pattern.startsWith(db);
    }

    @Override
    public boolean mayOverlapWithDevice(IDeviceID device) {
        String deviceStr = device.toString();
        return this.pattern.length() <= deviceStr.length() && deviceStr.startsWith(this.pattern) || this.pattern.length() > deviceStr.length() && this.pattern.startsWith(deviceStr);
    }

    @Override
    public boolean matchesMeasurement(IDeviceID device, String measurement) {
        String deviceStr = device.toString();
        if (this.pattern.length() <= deviceStr.length()) {
            return true;
        }
        String dotAndMeasurement = "." + measurement;
        return this.pattern.length() <= deviceStr.length() + dotAndMeasurement.length() && dotAndMeasurement.startsWith(this.pattern.substring(deviceStr.length()));
    }

    @Override
    public String toString() {
        return "PrefixPipePattern" + super.toString();
    }
}

