/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;

public class IfExpression
extends Expression {
    private final Expression condition;
    private final Expression trueValue;
    @Nullable
    private final Expression falseValue;

    public IfExpression(Expression condition, Expression trueValue, @Nullable Expression falseValue) {
        super(null);
        this.condition = Objects.requireNonNull(condition, "condition is null");
        this.trueValue = Objects.requireNonNull(trueValue, "trueValue is null");
        this.falseValue = falseValue;
    }

    public IfExpression(NodeLocation location, Expression condition, Expression trueValue, @Nullable Expression falseValue) {
        super(Objects.requireNonNull(location, "location is null"));
        this.condition = Objects.requireNonNull(condition, "condition is null");
        this.trueValue = Objects.requireNonNull(trueValue, "trueValue is null");
        this.falseValue = falseValue;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public Expression getTrueValue() {
        return this.trueValue;
    }

    public Optional<Expression> getFalseValue() {
        return Optional.ofNullable(this.falseValue);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitIfExpression(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        if (this.falseValue != null) {
            nodes.add((Object)this.falseValue);
        }
        return nodes.add((Object)this.condition).add((Object)this.trueValue).build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        IfExpression o = (IfExpression)obj;
        return Objects.equals(this.condition, o.condition) && Objects.equals(this.trueValue, o.trueValue) && Objects.equals(this.falseValue, o.falseValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.condition, this.trueValue, this.falseValue);
    }

    @Override
    public boolean shallowEquals(Node other) {
        return IfExpression.sameClass(this, other);
    }
}

