/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus;

import java.io.File;
import java.util.List;
import java.util.function.Function;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.Utils;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;

@ThreadSafe
public interface IStateMachine {
    public void start();

    public void stop();

    default public boolean isReadOnly() {
        return false;
    }

    public TSStatus write(IConsensusRequest var1);

    public IConsensusRequest deserializeRequest(IConsensusRequest var1);

    public DataSet read(IConsensusRequest var1);

    default public boolean hasReleaseAllRegionRelatedResource(ConsensusGroupId groupId) {
        return true;
    }

    public boolean takeSnapshot(File var1);

    default public boolean takeSnapshot(File snapshotDir, String snapshotTmpId, String snapshotId) {
        return this.takeSnapshot(snapshotDir);
    }

    default public boolean clearSnapshot() {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public void loadSnapshot(File var1);

    default public List<File> getSnapshotFiles(File latestSnapshotRootDir) {
        return Utils.listAllRegularFilesRecursively(latestSnapshotRootDir);
    }

    default public EventApi event() {
        return (EventApi)((Object)this);
    }

    default public File getSnapshotRoot() {
        return null;
    }

    public static interface EventApi {
        default public void notifyLeaderChanged(ConsensusGroupId groupId, int newLeaderId) {
        }

        default public void notifyConfigurationChanged(long term, long index, List<Peer> newConfiguration) {
        }

        default public void notifyLeaderReady() {
        }

        default public void notifyNotLeader() {
        }
    }

    public static interface Registry
    extends Function<ConsensusGroupId, IStateMachine> {
    }
}

