/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.jackrabbit.commons.repository.JNDIRepositoryFactory;
import org.apache.jackrabbit.servlet.AbstractRepositoryServlet;

public class JNDIRepositoryServlet
extends AbstractRepositoryServlet {
    private static final long serialVersionUID = 8952525573562952560L;

    @Override
    protected Repository getRepository() throws RepositoryException {
        try {
            String location = Repository.class.getName().replace('.', '/');
            Hashtable<String, String> environment = new Hashtable<String, String>();
            Enumeration<String> names = this.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                if (name.equals("location")) {
                    location = this.getInitParameter(name);
                    continue;
                }
                if (name.equals(Repository.class.getName())) continue;
                environment.put(name, this.getInitParameter(name));
            }
            return new JNDIRepositoryFactory(new InitialContext(environment), location).getRepository();
        }
        catch (NamingException e) {
            throw new RepositoryException("Repository not found: Invalid JNDI context", e);
        }
    }
}

