/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.model;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.mail.Flags;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.model.ComposedMessageId;
import org.apache.james.mailbox.model.MessageId;
import org.apache.james.mailbox.model.ThreadId;

public class ComposedMessageIdWithMetaData {
    private final ComposedMessageId composedMessageId;
    private final Flags flags;
    private final ModSeq modSeq;
    private final ThreadId threadId;

    public static Builder builder() {
        return new Builder();
    }

    public ComposedMessageIdWithMetaData(ComposedMessageId composedMessageId, Flags flags, ModSeq modSeq, ThreadId threadId) {
        this.composedMessageId = composedMessageId;
        this.flags = flags;
        this.modSeq = modSeq;
        this.threadId = threadId;
    }

    public ComposedMessageId getComposedMessageId() {
        return this.composedMessageId;
    }

    public Flags getFlags() {
        return this.flags;
    }

    public ModSeq getModSeq() {
        return this.modSeq;
    }

    public ThreadId getThreadId() {
        return this.threadId;
    }

    public boolean isMatching(MessageId messageId) {
        return this.getComposedMessageId().getMessageId().equals(messageId);
    }

    public final boolean equals(Object o) {
        if (o instanceof ComposedMessageIdWithMetaData) {
            ComposedMessageIdWithMetaData other = (ComposedMessageIdWithMetaData)o;
            return Objects.equal((Object)this.composedMessageId, (Object)other.composedMessageId) && Objects.equal((Object)this.flags, (Object)other.flags) && Objects.equal((Object)this.modSeq, (Object)other.modSeq) && Objects.equal((Object)this.threadId, (Object)other.threadId);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.composedMessageId, this.flags, this.modSeq, this.threadId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("composedMessageId", (Object)this.composedMessageId).add("flags", (Object)this.flags).add("modSeq", (Object)this.modSeq).add("threadId", (Object)this.threadId).toString();
    }

    public static class Builder {
        private ComposedMessageId composedMessageId;
        private Flags flags;
        private ModSeq modSeq;
        private ThreadId threadId;

        private Builder() {
        }

        public Builder composedMessageId(ComposedMessageId composedMessageId) {
            this.composedMessageId = composedMessageId;
            return this;
        }

        public Builder flags(Flags flags) {
            this.flags = flags;
            return this;
        }

        public Builder modSeq(ModSeq modSeq) {
            this.modSeq = modSeq;
            return this;
        }

        public Builder threadId(ThreadId threadId) {
            this.threadId = threadId;
            return this;
        }

        public ComposedMessageIdWithMetaData build() {
            Preconditions.checkNotNull((Object)this.composedMessageId, (Object)"'composedMessageId' is mandatory");
            Preconditions.checkNotNull((Object)this.flags, (Object)"'flags' is mandatory");
            Preconditions.checkNotNull((Object)this.modSeq, (Object)"'modSeq' is mandatory");
            Preconditions.checkNotNull((Object)this.threadId, (Object)"'threadId' is mandatory");
            return new ComposedMessageIdWithMetaData(this.composedMessageId, this.flags, this.modSeq, this.threadId);
        }
    }
}

