/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.EnumSet;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.StatusRequest;

public class StatusCommandParser
extends AbstractImapCommandParser {
    private static final ImapRequestLineReader.NoopCharValidator NOOP_CHAR_VALIDATOR = new ImapRequestLineReader.NoopCharValidator();

    public StatusCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.STATUS_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        StatusDataItems statusDataItems = this.statusDataItems(request);
        request.eol();
        return new StatusRequest(mailboxName, statusDataItems, tag);
    }

    private StatusDataItems statusDataItems(ImapRequestLineReader request) throws DecodingException {
        ImmutableList<String> words = this.splitWords(request);
        EnumSet<StatusDataItems.StatusItem> items = EnumSet.copyOf((Collection)words.stream().map(Throwing.function(this::parseStatus).sneakyThrow()).collect(ImmutableList.toImmutableList()));
        return new StatusDataItems(items);
    }

    private ImmutableList<String> splitWords(ImapRequestLineReader request) throws DecodingException {
        ImmutableList.Builder words = ImmutableList.builder();
        request.nextWordChar();
        request.consumeChar('(');
        String nextWord = request.consumeWord(NOOP_CHAR_VALIDATOR);
        while (!nextWord.endsWith(")")) {
            words.add((Object)nextWord);
            nextWord = request.consumeWord(NOOP_CHAR_VALIDATOR);
            if (!nextWord.isEmpty()) continue;
            throw new DecodingException(HumanReadableText.FAILED, "Empty word encountered");
        }
        if (nextWord.length() > 1) {
            words.add((Object)nextWord.substring(0, nextWord.length() - 1));
        }
        return words.build();
    }

    private StatusDataItems.StatusItem parseStatus(String nextWord) throws DecodingException {
        if (nextWord.equalsIgnoreCase("MESSAGES")) {
            return StatusDataItems.StatusItem.MESSAGES;
        }
        if (nextWord.equalsIgnoreCase("RECENT")) {
            return StatusDataItems.StatusItem.RECENT;
        }
        if (nextWord.equalsIgnoreCase("UIDNEXT")) {
            return StatusDataItems.StatusItem.UID_NEXT;
        }
        if (nextWord.equalsIgnoreCase("UIDVALIDITY")) {
            return StatusDataItems.StatusItem.UID_VALIDITY;
        }
        if (nextWord.equalsIgnoreCase("UNSEEN")) {
            return StatusDataItems.StatusItem.UNSEEN;
        }
        if (nextWord.equalsIgnoreCase("HIGHESTMODSEQ")) {
            return StatusDataItems.StatusItem.HIGHEST_MODSEQ;
        }
        throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown status item: '" + nextWord + "'");
    }
}

