/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.tika;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.Weigher;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.james.mailbox.extractor.ParsedContent;
import org.apache.james.mailbox.extractor.TextExtractor;
import org.apache.james.mailbox.model.ContentType;
import org.apache.james.metrics.api.GaugeRegistry;
import org.apache.james.metrics.api.Metric;
import org.apache.james.metrics.api.MetricFactory;

public class CachingTextExtractor
implements TextExtractor {
    private final TextExtractor underlying;
    private final Cache<String, ParsedContent> cache;
    private final Metric weightMetric;

    public CachingTextExtractor(TextExtractor underlying, Duration cacheEvictionPeriod, Long cacheWeightInBytes, MetricFactory metricFactory, GaugeRegistry gaugeRegistry) {
        this.underlying = underlying;
        this.weightMetric = metricFactory.generate("textExtractor.cache.weight");
        Weigher weigher = (key, parsedContent) -> this.computeWeight((ParsedContent)parsedContent);
        RemovalListener removalListener = notification -> Optional.ofNullable((ParsedContent)notification.getValue()).map(this::computeWeight).ifPresent(arg_0 -> ((Metric)this.weightMetric).remove(arg_0));
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(cacheEvictionPeriod.toMillis(), TimeUnit.MILLISECONDS).maximumWeight(cacheWeightInBytes.longValue()).weigher(weigher).recordStats().removalListener(removalListener).build();
        this.recordStats(gaugeRegistry);
    }

    public void recordStats(GaugeRegistry gaugeRegistry) {
        gaugeRegistry.register("textExtractor.cache.hit.rate", () -> this.cache.stats().hitRate()).register("textExtractor.cache.hit.count", () -> this.cache.stats().hitCount());
        gaugeRegistry.register("textExtractor.cache.load.count", () -> this.cache.stats().loadCount()).register("textExtractor.cache.eviction.count", () -> this.cache.stats().evictionCount()).register("textExtractor.cache.load.exception.rate", () -> this.cache.stats().loadExceptionRate()).register("textExtractor.cache.load.miss.rate", () -> this.cache.stats().missRate()).register("textExtractor.cache.load.miss.count", () -> this.cache.stats().missCount()).register("textExtractor.cache.size", () -> this.cache.size());
    }

    private int computeWeight(ParsedContent parsedContent) {
        return parsedContent.getTextualContent().map(String::length).map(this::utf16LengthToBytesCount).orElse(0);
    }

    private int utf16LengthToBytesCount(Integer value) {
        return value * 2;
    }

    public ParsedContent extractContent(InputStream inputStream, ContentType contentType) throws Exception {
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        String key = Hashing.sha256().hashBytes(bytes).toString();
        try {
            return (ParsedContent)this.cache.get((Object)key, () -> this.retrieveAndUpdateWeight(bytes, contentType));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw this.unwrap((Exception)e);
        }
    }

    private ParsedContent retrieveAndUpdateWeight(byte[] bytes, ContentType contentType) throws Exception {
        ParsedContent parsedContent = this.underlying.extractContent((InputStream)new ByteArrayInputStream(bytes), contentType);
        this.weightMetric.add(this.computeWeight(parsedContent));
        return parsedContent;
    }

    private Exception unwrap(Exception e) {
        return Optional.ofNullable(e.getCause()).filter(throwable -> throwable instanceof Exception).map(throwable -> (Exception)throwable).orElse(e);
    }

    @VisibleForTesting
    long size() {
        return this.cache.size();
    }
}

