/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.BaseCompositeReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.uhighlight.DefaultPassageFormatter;
import org.apache.lucene.search.uhighlight.FieldHighlighter;
import org.apache.lucene.search.uhighlight.FieldOffsetStrategy;
import org.apache.lucene.search.uhighlight.LabelledCharArrayMatcher;
import org.apache.lucene.search.uhighlight.MemoryIndexOffsetStrategy;
import org.apache.lucene.search.uhighlight.MultiTermHighlighting;
import org.apache.lucene.search.uhighlight.NoOpOffsetStrategy;
import org.apache.lucene.search.uhighlight.PassageFormatter;
import org.apache.lucene.search.uhighlight.PassageScorer;
import org.apache.lucene.search.uhighlight.PhraseHelper;
import org.apache.lucene.search.uhighlight.PostingsOffsetStrategy;
import org.apache.lucene.search.uhighlight.PostingsWithTermVectorsOffsetStrategy;
import org.apache.lucene.search.uhighlight.SplittingBreakIterator;
import org.apache.lucene.search.uhighlight.TermVectorOffsetStrategy;
import org.apache.lucene.search.uhighlight.TokenStreamOffsetStrategy;
import org.apache.lucene.search.uhighlight.UHComponents;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.InPlaceMergeSorter;

public class UnifiedHighlighter {
    protected static final char MULTIVAL_SEP_CHAR = '\u0000';
    public static final int DEFAULT_MAX_LENGTH = 10000;
    public static final int DEFAULT_CACHE_CHARS_THRESHOLD = 524288;
    static final IndexSearcher EMPTY_INDEXSEARCHER;
    protected static final LabelledCharArrayMatcher[] ZERO_LEN_AUTOMATA_ARRAY;
    protected final IndexSearcher searcher;
    protected final Analyzer indexAnalyzer;
    private boolean defaultHandleMtq = true;
    private boolean defaultHighlightPhrasesStrictly = true;
    private boolean defaultPassageRelevancyOverSpeed = true;
    private int maxLength = 10000;
    private Supplier<BreakIterator> defaultBreakIterator = () -> BreakIterator.getSentenceInstance(Locale.ROOT);
    private Predicate<String> defaultFieldMatcher;
    private PassageScorer defaultScorer = new PassageScorer();
    private PassageFormatter defaultFormatter = new DefaultPassageFormatter();
    private int defaultMaxNoHighlightPassages = -1;
    protected volatile FieldInfos fieldInfos;
    private int cacheFieldValCharsThreshold = 524288;

    protected static Set<Term> extractTerms(Query query) throws IOException {
        HashSet<Term> queryTerms = new HashSet<Term>();
        EMPTY_INDEXSEARCHER.rewrite(query).visit(QueryVisitor.termCollector(queryTerms));
        return queryTerms;
    }

    public UnifiedHighlighter(IndexSearcher indexSearcher, Analyzer indexAnalyzer) {
        this.searcher = indexSearcher;
        this.indexAnalyzer = Objects.requireNonNull(indexAnalyzer, "indexAnalyzer is required (even if in some circumstances it isn't used)");
    }

    public void setHandleMultiTermQuery(boolean handleMtq) {
        this.defaultHandleMtq = handleMtq;
    }

    public void setHighlightPhrasesStrictly(boolean highlightPhrasesStrictly) {
        this.defaultHighlightPhrasesStrictly = highlightPhrasesStrictly;
    }

    public void setMaxLength(int maxLength) {
        if (maxLength < 0 || maxLength == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("maxLength must be < Integer.MAX_VALUE");
        }
        this.maxLength = maxLength;
    }

    public void setBreakIterator(Supplier<BreakIterator> breakIterator) {
        this.defaultBreakIterator = breakIterator;
    }

    public void setScorer(PassageScorer scorer) {
        this.defaultScorer = scorer;
    }

    public void setFormatter(PassageFormatter formatter) {
        this.defaultFormatter = formatter;
    }

    public void setMaxNoHighlightPassages(int defaultMaxNoHighlightPassages) {
        this.defaultMaxNoHighlightPassages = defaultMaxNoHighlightPassages;
    }

    public void setCacheFieldValCharsThreshold(int cacheFieldValCharsThreshold) {
        this.cacheFieldValCharsThreshold = cacheFieldValCharsThreshold;
    }

    public void setFieldMatcher(Predicate<String> predicate) {
        this.defaultFieldMatcher = predicate;
    }

    protected boolean shouldHandleMultiTermQuery(String field) {
        return this.defaultHandleMtq;
    }

    protected boolean shouldHighlightPhrasesStrictly(String field) {
        return this.defaultHighlightPhrasesStrictly;
    }

    protected boolean shouldPreferPassageRelevancyOverSpeed(String field) {
        return this.defaultPassageRelevancyOverSpeed;
    }

    protected Predicate<String> getFieldMatcher(String field) {
        if (this.defaultFieldMatcher != null) {
            return this.defaultFieldMatcher;
        }
        return qf -> field.equals(qf);
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    protected BreakIterator getBreakIterator(String field) {
        return this.defaultBreakIterator.get();
    }

    protected PassageScorer getScorer(String field) {
        return this.defaultScorer;
    }

    protected PassageFormatter getFormatter(String field) {
        return this.defaultFormatter;
    }

    protected int getMaxNoHighlightPassages(String field) {
        return this.defaultMaxNoHighlightPassages;
    }

    public int getCacheFieldValCharsThreshold() {
        return this.cacheFieldValCharsThreshold;
    }

    public IndexSearcher getIndexSearcher() {
        return this.searcher;
    }

    public Analyzer getIndexAnalyzer() {
        return this.indexAnalyzer;
    }

    protected OffsetSource getOffsetSource(String field) {
        FieldInfo fieldInfo = this.getFieldInfo(field);
        if (fieldInfo != null) {
            if (fieldInfo.getIndexOptions() == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
                return fieldInfo.hasVectors() ? OffsetSource.POSTINGS_WITH_TERM_VECTORS : OffsetSource.POSTINGS;
            }
            if (fieldInfo.hasVectors()) {
                return OffsetSource.TERM_VECTORS;
            }
        }
        return OffsetSource.ANALYSIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FieldInfo getFieldInfo(String field) {
        if (this.searcher == null) {
            return null;
        }
        FieldInfos fieldInfos = this.fieldInfos;
        if (fieldInfos == null) {
            UnifiedHighlighter unifiedHighlighter = this;
            synchronized (unifiedHighlighter) {
                fieldInfos = this.fieldInfos;
                if (fieldInfos == null) {
                    this.fieldInfos = fieldInfos = FieldInfos.getMergedFieldInfos((IndexReader)this.searcher.getIndexReader());
                }
            }
        }
        return fieldInfos.fieldInfo(field);
    }

    public String[] highlight(String field, Query query, TopDocs topDocs) throws IOException {
        return this.highlight(field, query, topDocs, 1);
    }

    public String[] highlight(String field, Query query, TopDocs topDocs, int maxPassages) throws IOException {
        Map<String, String[]> res = this.highlightFields(new String[]{field}, query, topDocs, new int[]{maxPassages});
        return res.get(field);
    }

    public Map<String, String[]> highlightFields(String[] fields, Query query, TopDocs topDocs) throws IOException {
        int[] maxPassages = new int[fields.length];
        Arrays.fill(maxPassages, 1);
        return this.highlightFields(fields, query, topDocs, maxPassages);
    }

    public Map<String, String[]> highlightFields(String[] fields, Query query, TopDocs topDocs, int[] maxPassages) throws IOException {
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        int[] docids = new int[scoreDocs.length];
        for (int i = 0; i < docids.length; ++i) {
            docids[i] = scoreDocs[i].doc;
        }
        return this.highlightFields(fields, query, docids, maxPassages);
    }

    public Map<String, String[]> highlightFields(String[] fieldsIn, Query query, int[] docidsIn, int[] maxPassagesIn) throws IOException {
        HashMap<String, String[]> snippets = new HashMap<String, String[]>();
        for (Map.Entry<String, Object[]> ent : this.highlightFieldsAsObjects(fieldsIn, query, docidsIn, maxPassagesIn).entrySet()) {
            Object[] snippetObjects = ent.getValue();
            String[] snippetStrings = new String[snippetObjects.length];
            snippets.put(ent.getKey(), snippetStrings);
            for (int i = 0; i < snippetObjects.length; ++i) {
                Object snippet = snippetObjects[i];
                if (snippet == null) continue;
                snippetStrings[i] = snippet.toString();
            }
        }
        return snippets;
    }

    protected Map<String, Object[]> highlightFieldsAsObjects(String[] fieldsIn, Query query, int[] docIdsIn, int[] maxPassagesIn) throws IOException {
        List<CharSequence[]> fieldValsByDoc;
        if (fieldsIn.length < 1) {
            throw new IllegalArgumentException("fieldsIn must not be empty");
        }
        if (fieldsIn.length != maxPassagesIn.length) {
            throw new IllegalArgumentException("invalid number of maxPassagesIn");
        }
        if (this.searcher == null) {
            throw new IllegalStateException("This method requires that an indexSearcher was passed in the constructor.  Perhaps you mean to call highlightWithoutSearcher?");
        }
        int[] docIds = new int[docIdsIn.length];
        int[] docInIndexes = new int[docIds.length];
        this.copyAndSortDocIdsWithIndex(docIdsIn, docIds, docInIndexes);
        String[] fields = new String[fieldsIn.length];
        int[] maxPassages = new int[maxPassagesIn.length];
        this.copyAndSortFieldsWithMaxPassages(fieldsIn, maxPassagesIn, fields, maxPassages);
        Set<Term> queryTerms = UnifiedHighlighter.extractTerms(query);
        FieldHighlighter[] fieldHighlighters = new FieldHighlighter[fields.length];
        int numTermVectors = 0;
        int numPostings = 0;
        block5: for (int f = 0; f < fields.length; ++f) {
            FieldHighlighter fieldHighlighter;
            fieldHighlighters[f] = fieldHighlighter = this.getFieldHighlighter(fields[f], query, queryTerms, maxPassages[f]);
            switch (fieldHighlighter.getOffsetSource()) {
                case TERM_VECTORS: {
                    ++numTermVectors;
                    continue block5;
                }
                case POSTINGS: {
                    ++numPostings;
                    continue block5;
                }
                case POSTINGS_WITH_TERM_VECTORS: {
                    ++numTermVectors;
                    ++numPostings;
                    continue block5;
                }
            }
        }
        int cacheCharsThreshold = this.calculateOptimalCacheCharsThreshold(numTermVectors, numPostings);
        IndexReader indexReaderWithTermVecCache = numTermVectors >= 2 ? TermVectorReusingLeafReader.wrap(this.searcher.getIndexReader()) : null;
        Object[][] highlightDocsInByField = new Object[fields.length][docIds.length];
        DocIdSetIterator docIdIter = this.asDocIdSetIterator(docIds);
        for (int batchDocIdx = 0; batchDocIdx < docIds.length; batchDocIdx += fieldValsByDoc.size()) {
            fieldValsByDoc = this.loadFieldValues(fields, docIdIter, cacheCharsThreshold);
            for (int fieldIdx = 0; fieldIdx < fields.length; ++fieldIdx) {
                Object[] resultByDocIn = highlightDocsInByField[fieldIdx];
                FieldHighlighter fieldHighlighter = fieldHighlighters[fieldIdx];
                int docIdx = batchDocIdx;
                while (docIdx - batchDocIdx < fieldValsByDoc.size()) {
                    int docId = docIds[docIdx];
                    CharSequence content = fieldValsByDoc.get(docIdx - batchDocIdx)[fieldIdx];
                    if (content != null) {
                        LeafReader leafReader;
                        IndexReader indexReader;
                        IndexReader indexReader2 = indexReader = fieldHighlighter.getOffsetSource() == OffsetSource.TERM_VECTORS && indexReaderWithTermVecCache != null ? indexReaderWithTermVecCache : this.searcher.getIndexReader();
                        if (indexReader instanceof LeafReader) {
                            leafReader = (LeafReader)indexReader;
                        } else {
                            List leaves = indexReader.leaves();
                            LeafReaderContext leafReaderContext = (LeafReaderContext)leaves.get(ReaderUtil.subIndex((int)docId, (List)leaves));
                            leafReader = leafReaderContext.reader();
                            docId -= leafReaderContext.docBase;
                        }
                        int docInIndex = docInIndexes[docIdx];
                        assert (resultByDocIn[docInIndex] == null);
                        resultByDocIn[docInIndex] = fieldHighlighter.highlightFieldForDoc(leafReader, docId, content.toString());
                    }
                    ++docIdx;
                }
            }
        }
        IOUtils.close((Closeable[])new Closeable[]{indexReaderWithTermVecCache});
        assert (docIdIter.docID() == Integer.MAX_VALUE || docIdIter.nextDoc() == Integer.MAX_VALUE);
        HashMap<String, Object[]> resultMap = new HashMap<String, Object[]>(fields.length);
        for (int f = 0; f < fields.length; ++f) {
            resultMap.put(fields[f], highlightDocsInByField[f]);
        }
        return resultMap;
    }

    private int calculateOptimalCacheCharsThreshold(int numTermVectors, int numPostings) {
        if (numPostings == 0 && numTermVectors == 0) {
            return 0;
        }
        if (numTermVectors >= 2) {
            return 0;
        }
        return this.getCacheFieldValCharsThreshold();
    }

    private void copyAndSortFieldsWithMaxPassages(String[] fieldsIn, int[] maxPassagesIn, final String[] fields, final int[] maxPassages) {
        System.arraycopy(fieldsIn, 0, fields, 0, fieldsIn.length);
        System.arraycopy(maxPassagesIn, 0, maxPassages, 0, maxPassagesIn.length);
        new InPlaceMergeSorter(){

            protected void swap(int i, int j) {
                String tmp = fields[i];
                fields[i] = fields[j];
                fields[j] = tmp;
                int tmp2 = maxPassages[i];
                maxPassages[i] = maxPassages[j];
                maxPassages[j] = tmp2;
            }

            protected int compare(int i, int j) {
                return fields[i].compareTo(fields[j]);
            }
        }.sort(0, fields.length);
    }

    private void copyAndSortDocIdsWithIndex(int[] docIdsIn, final int[] docIds, final int[] docInIndexes) {
        System.arraycopy(docIdsIn, 0, docIds, 0, docIdsIn.length);
        for (int i = 0; i < docInIndexes.length; ++i) {
            docInIndexes[i] = i;
        }
        new InPlaceMergeSorter(){

            protected void swap(int i, int j) {
                int tmp = docIds[i];
                docIds[i] = docIds[j];
                docIds[j] = tmp;
                tmp = docInIndexes[i];
                docInIndexes[i] = docInIndexes[j];
                docInIndexes[j] = tmp;
            }

            protected int compare(int i, int j) {
                return Integer.compare(docIds[i], docIds[j]);
            }
        }.sort(0, docIds.length);
    }

    public Object highlightWithoutSearcher(String field, Query query, String content, int maxPassages) throws IOException {
        if (this.searcher != null) {
            throw new IllegalStateException("highlightWithoutSearcher should only be called on a " + this.getClass().getSimpleName() + " without an IndexSearcher.");
        }
        Objects.requireNonNull(content, "content is required");
        Set<Term> queryTerms = UnifiedHighlighter.extractTerms(query);
        return this.getFieldHighlighter(field, query, queryTerms, maxPassages).highlightFieldForDoc(null, -1, content);
    }

    protected FieldHighlighter getFieldHighlighter(String field, Query query, Set<Term> allTerms, int maxPassages) {
        UHComponents components = this.getHighlightComponents(field, query, allTerms);
        OffsetSource offsetSource = this.getOptimizedOffsetSource(components);
        return new FieldHighlighter(field, this.getOffsetStrategy(offsetSource, components), new SplittingBreakIterator(this.getBreakIterator(field), '\u0000'), this.getScorer(field), maxPassages, this.getMaxNoHighlightPassages(field), this.getFormatter(field));
    }

    protected UHComponents getHighlightComponents(String field, Query query, Set<Term> allTerms) {
        Predicate<String> fieldMatcher = this.getFieldMatcher(field);
        Set<HighlightFlag> highlightFlags = this.getFlags(field);
        PhraseHelper phraseHelper = this.getPhraseHelper(field, query, highlightFlags);
        boolean queryHasUnrecognizedPart = this.hasUnrecognizedQuery(fieldMatcher, query);
        BytesRef[] terms = null;
        LabelledCharArrayMatcher[] automata = null;
        if (!highlightFlags.contains((Object)HighlightFlag.WEIGHT_MATCHES) || !queryHasUnrecognizedPart) {
            terms = UnifiedHighlighter.filterExtractedTerms(fieldMatcher, allTerms);
            automata = this.getAutomata(field, query, highlightFlags);
        }
        return new UHComponents(field, fieldMatcher, query, terms, phraseHelper, automata, queryHasUnrecognizedPart, highlightFlags);
    }

    protected boolean hasUnrecognizedQuery(final Predicate<String> fieldMatcher, Query query) {
        final boolean[] hasUnknownLeaf = new boolean[1];
        query.visit(new QueryVisitor(){

            public boolean acceptField(String field) {
                return !hasUnknownLeaf[0] && fieldMatcher.test(field);
            }

            public void visitLeaf(Query query) {
                if (!(MultiTermHighlighting.canExtractAutomataFromLeafQuery(query) || query instanceof MatchAllDocsQuery || query instanceof MatchNoDocsQuery)) {
                    hasUnknownLeaf[0] = true;
                }
            }
        });
        return hasUnknownLeaf[0];
    }

    protected static BytesRef[] filterExtractedTerms(Predicate<String> fieldMatcher, Set<Term> queryTerms) {
        TreeSet<BytesRef> filteredTerms = new TreeSet<BytesRef>();
        for (Term term : queryTerms) {
            if (!fieldMatcher.test(term.field())) continue;
            filteredTerms.add(term.bytes());
        }
        return filteredTerms.toArray(new BytesRef[filteredTerms.size()]);
    }

    protected Set<HighlightFlag> getFlags(String field) {
        EnumSet<HighlightFlag> highlightFlags = EnumSet.noneOf(HighlightFlag.class);
        if (this.shouldHandleMultiTermQuery(field)) {
            highlightFlags.add(HighlightFlag.MULTI_TERM_QUERY);
        }
        if (this.shouldHighlightPhrasesStrictly(field)) {
            highlightFlags.add(HighlightFlag.PHRASES);
        }
        if (this.shouldPreferPassageRelevancyOverSpeed(field)) {
            highlightFlags.add(HighlightFlag.PASSAGE_RELEVANCY_OVER_SPEED);
        }
        return highlightFlags;
    }

    protected PhraseHelper getPhraseHelper(String field, Query query, Set<HighlightFlag> highlightFlags) {
        boolean useWeightMatchesIter = highlightFlags.contains((Object)HighlightFlag.WEIGHT_MATCHES);
        if (useWeightMatchesIter) {
            return PhraseHelper.NONE;
        }
        boolean highlightPhrasesStrictly = highlightFlags.contains((Object)HighlightFlag.PHRASES);
        boolean handleMultiTermQuery = highlightFlags.contains((Object)HighlightFlag.MULTI_TERM_QUERY);
        return highlightPhrasesStrictly ? new PhraseHelper(query, field, this.getFieldMatcher(field), this::requiresRewrite, this::preSpanQueryRewrite, !handleMultiTermQuery) : PhraseHelper.NONE;
    }

    protected LabelledCharArrayMatcher[] getAutomata(String field, Query query, Set<HighlightFlag> highlightFlags) {
        boolean lookInSpan = !highlightFlags.contains((Object)HighlightFlag.PHRASES) || highlightFlags.contains((Object)HighlightFlag.WEIGHT_MATCHES);
        return highlightFlags.contains((Object)HighlightFlag.MULTI_TERM_QUERY) ? MultiTermHighlighting.extractAutomata(query, this.getFieldMatcher(field), lookInSpan) : ZERO_LEN_AUTOMATA_ARRAY;
    }

    protected OffsetSource getOptimizedOffsetSource(UHComponents components) {
        boolean mtqOrRewrite;
        OffsetSource offsetSource = this.getOffsetSource(components.getField());
        boolean bl = mtqOrRewrite = components.getAutomata() == null || components.getAutomata().length > 0 || components.getPhraseHelper().willRewrite() || components.hasUnrecognizedQueryPart();
        if (!mtqOrRewrite && components.getTerms() != null && components.getTerms().length == 0) {
            return OffsetSource.NONE_NEEDED;
        }
        switch (offsetSource) {
            case POSTINGS: {
                if (!mtqOrRewrite) break;
                return OffsetSource.ANALYSIS;
            }
            case POSTINGS_WITH_TERM_VECTORS: {
                if (mtqOrRewrite) break;
                return OffsetSource.POSTINGS;
            }
        }
        return offsetSource;
    }

    protected FieldOffsetStrategy getOffsetStrategy(OffsetSource offsetSource, UHComponents components) {
        switch (offsetSource) {
            case ANALYSIS: {
                if (!(components.getPhraseHelper().hasPositionSensitivity() || components.getHighlightFlags().contains((Object)HighlightFlag.PASSAGE_RELEVANCY_OVER_SPEED) || components.getHighlightFlags().contains((Object)HighlightFlag.WEIGHT_MATCHES))) {
                    return new TokenStreamOffsetStrategy(components, this.getIndexAnalyzer());
                }
                return new MemoryIndexOffsetStrategy(components, this.getIndexAnalyzer());
            }
            case NONE_NEEDED: {
                return NoOpOffsetStrategy.INSTANCE;
            }
            case TERM_VECTORS: {
                return new TermVectorOffsetStrategy(components);
            }
            case POSTINGS: {
                return new PostingsOffsetStrategy(components);
            }
            case POSTINGS_WITH_TERM_VECTORS: {
                return new PostingsWithTermVectorsOffsetStrategy(components);
            }
        }
        throw new IllegalArgumentException("Unrecognized offset source " + (Object)((Object)offsetSource));
    }

    protected Boolean requiresRewrite(SpanQuery spanQuery) {
        return null;
    }

    protected Collection<Query> preSpanQueryRewrite(Query query) {
        return null;
    }

    private DocIdSetIterator asDocIdSetIterator(final int[] sortedDocIds) {
        return new DocIdSetIterator(){
            int idx = -1;

            public int docID() {
                if (this.idx < 0 || this.idx >= sortedDocIds.length) {
                    return Integer.MAX_VALUE;
                }
                return sortedDocIds[this.idx];
            }

            public int nextDoc() throws IOException {
                ++this.idx;
                return this.docID();
            }

            public int advance(int target) throws IOException {
                return super.slowAdvance(target);
            }

            public long cost() {
                return Math.max(0, sortedDocIds.length - (this.idx + 1));
            }
        };
    }

    protected List<CharSequence[]> loadFieldValues(String[] fields, DocIdSetIterator docIter, int cacheCharsThreshold) throws IOException {
        int docId;
        ArrayList<CharSequence[]> docListOfFields = new ArrayList<CharSequence[]>(cacheCharsThreshold == 0 ? 1 : (int)Math.min(64L, docIter.cost()));
        LimitedStoredFieldVisitor visitor = this.newLimitedStoredFieldsVisitor(fields);
        int sumChars = 0;
        while ((docId = docIter.nextDoc()) != Integer.MAX_VALUE) {
            visitor.init();
            this.searcher.doc(docId, (StoredFieldVisitor)visitor);
            CharSequence[] valuesByField = visitor.getValuesByField();
            docListOfFields.add(valuesByField);
            for (CharSequence val : valuesByField) {
                sumChars += val == null ? 0 : val.length();
            }
            if (sumChars <= cacheCharsThreshold && cacheCharsThreshold != 0) continue;
        }
        return docListOfFields;
    }

    protected LimitedStoredFieldVisitor newLimitedStoredFieldsVisitor(String[] fields) {
        return new LimitedStoredFieldVisitor(fields, '\u0000', this.getMaxLength());
    }

    static {
        try {
            MultiReader emptyReader = new MultiReader(new IndexReader[0]);
            EMPTY_INDEXSEARCHER = new IndexSearcher((IndexReader)emptyReader);
            EMPTY_INDEXSEARCHER.setQueryCache(null);
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
        ZERO_LEN_AUTOMATA_ARRAY = new LabelledCharArrayMatcher[0];
    }

    public static enum HighlightFlag {
        PHRASES,
        MULTI_TERM_QUERY,
        PASSAGE_RELEVANCY_OVER_SPEED,
        WEIGHT_MATCHES;

    }

    private static class TermVectorReusingLeafReader
    extends FilterLeafReader {
        private int lastDocId = -1;
        private Fields tvFields;

        static IndexReader wrap(IndexReader reader) throws IOException {
            LeafReader[] leafReaders = (LeafReader[])reader.leaves().stream().map(LeafReaderContext::reader).map(TermVectorReusingLeafReader::new).toArray(LeafReader[]::new);
            return new BaseCompositeReader<IndexReader>((IndexReader[])leafReaders){

                protected void doClose() {
                }

                public IndexReader.CacheHelper getReaderCacheHelper() {
                    return null;
                }
            };
        }

        TermVectorReusingLeafReader(LeafReader in) {
            super(in);
        }

        public Fields getTermVectors(int docID) throws IOException {
            if (docID != this.lastDocId) {
                this.lastDocId = docID;
                this.tvFields = this.in.getTermVectors(docID);
            }
            return this.tvFields;
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }

    protected static class LimitedStoredFieldVisitor
    extends StoredFieldVisitor {
        protected final String[] fields;
        protected final char valueSeparator;
        protected final int maxLength;
        protected CharSequence[] values;
        protected int currentField;

        public LimitedStoredFieldVisitor(String[] fields, char valueSeparator, int maxLength) {
            this.fields = fields;
            this.valueSeparator = valueSeparator;
            this.maxLength = maxLength;
        }

        void init() {
            this.values = new CharSequence[this.fields.length];
            this.currentField = -1;
        }

        public void stringField(FieldInfo fieldInfo, byte[] byteValue) throws IOException {
            StringBuilder curValueBuilder;
            String value = new String(byteValue, StandardCharsets.UTF_8);
            assert (this.currentField >= 0);
            CharSequence curValue = this.values[this.currentField];
            if (curValue == null) {
                this.values[this.currentField] = value.substring(0, Math.min(this.maxLength, value.length()));
                return;
            }
            int lengthBudget = this.maxLength - curValue.length();
            if (lengthBudget <= 0) {
                return;
            }
            if (curValue instanceof StringBuilder) {
                curValueBuilder = (StringBuilder)curValue;
            } else {
                curValueBuilder = new StringBuilder(curValue.length() + Math.min(lengthBudget, value.length() + 256));
                curValueBuilder.append(curValue);
            }
            curValueBuilder.append(this.valueSeparator);
            curValueBuilder.append(value.substring(0, Math.min(lengthBudget - 1, value.length())));
            this.values[this.currentField] = curValueBuilder;
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            this.currentField = Arrays.binarySearch(this.fields, fieldInfo.name);
            if (this.currentField < 0) {
                return StoredFieldVisitor.Status.NO;
            }
            CharSequence curVal = this.values[this.currentField];
            if (curVal != null && curVal.length() >= this.maxLength) {
                return this.fields.length == 1 ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
            }
            return StoredFieldVisitor.Status.YES;
        }

        CharSequence[] getValuesByField() {
            return this.values;
        }
    }

    public static enum OffsetSource {
        POSTINGS,
        TERM_VECTORS,
        ANALYSIS,
        POSTINGS_WITH_TERM_VECTORS,
        NONE_NEEDED;

    }
}

