/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.parser.AbstractUidCommandParser;
import org.apache.james.imap.message.request.ListRequest;

public class ListCommandParser
extends AbstractUidCommandParser {
    public ListCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.LIST_COMMAND, statusResponseFactory);
    }

    protected ListCommandParser(ImapCommand command, StatusResponseFactory statusResponseFactory) {
        super(command, statusResponseFactory);
    }

    public String listMailbox(ImapRequestLineReader request) throws DecodingException {
        char next = request.nextWordChar();
        switch (next) {
            case '\"': {
                return request.consumeQuoted();
            }
            case '{': {
                return request.consumeLiteral(null);
            }
        }
        return request.consumeWord(new ListCharValidator());
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, boolean useUids, ImapSession session) throws DecodingException {
        String referenceName = request.mailbox();
        String mailboxPattern = this.listMailbox(request);
        request.eol();
        return this.createMessage(referenceName, mailboxPattern, tag);
    }

    protected ImapMessage createMessage(String referenceName, String mailboxPattern, Tag tag) {
        return new ListRequest(referenceName, mailboxPattern, tag);
    }

    private static class ListCharValidator
    extends ImapRequestLineReader.AtomCharValidator {
        private ListCharValidator() {
        }

        @Override
        public boolean isValid(char chr) {
            if (ImapRequestLineReader.isListWildcard(chr)) {
                return true;
            }
            return super.isValid(chr);
        }
    }
}

