/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.utils.ClassName;

public class ExtensionConfiguration {
    public static final ExtensionConfiguration DEFAULT = new ExtensionConfiguration((List<ClassName>)ImmutableList.of(), (List<ClassName>)ImmutableList.of());
    private final List<ClassName> additionalGuiceModulesForExtensions;
    private final List<ClassName> taskExtensions;
    private final List<ClassName> startables;

    public static ExtensionConfiguration from(Configuration configuration) {
        return new ExtensionConfiguration((List)Arrays.stream(configuration.getStringArray("guice.extension.module")).map(ClassName::new).collect(ImmutableList.toImmutableList()), (List)Arrays.stream(configuration.getStringArray("guice.extension.startable")).map(ClassName::new).collect(ImmutableList.toImmutableList()), (List)Arrays.stream(configuration.getStringArray("guice.extension.task")).map(ClassName::new).collect(ImmutableList.toImmutableList()));
    }

    public ExtensionConfiguration(List<ClassName> additionalGuiceModulesForExtensions, List<ClassName> startables) {
        this(additionalGuiceModulesForExtensions, startables, List.of());
    }

    public ExtensionConfiguration(List<ClassName> additionalGuiceModulesForExtensions, List<ClassName> startables, List<ClassName> taskExtensions) {
        this.additionalGuiceModulesForExtensions = additionalGuiceModulesForExtensions;
        this.startables = startables;
        this.taskExtensions = taskExtensions;
    }

    public List<ClassName> getAdditionalGuiceModulesForExtensions() {
        return this.additionalGuiceModulesForExtensions;
    }

    public List<ClassName> getStartables() {
        return this.startables;
    }

    public List<ClassName> getTaskExtensions() {
        return this.taskExtensions;
    }
}

