/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.monitoring;

import com.google.crypto.tink.KeyStatus;
import com.google.crypto.tink.Parameters;
import com.google.crypto.tink.annotations.Alpha;
import com.google.crypto.tink.monitoring.MonitoringAnnotations;
import com.google.errorprone.annotations.Immutable;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@Immutable
@Alpha
public final class MonitoringKeysetInfo {
    private final MonitoringAnnotations annotations;
    private final List<Entry> entries;
    @Nullable
    private final Integer primaryKeyId;

    private MonitoringKeysetInfo(MonitoringAnnotations annotations, List<Entry> entries, Integer primaryKeyId) {
        this.annotations = annotations;
        this.entries = entries;
        this.primaryKeyId = primaryKeyId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public MonitoringAnnotations getAnnotations() {
        return this.annotations;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    @Nullable
    public Integer getPrimaryKeyId() {
        return this.primaryKeyId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MonitoringKeysetInfo)) {
            return false;
        }
        MonitoringKeysetInfo info = (MonitoringKeysetInfo)obj;
        return this.annotations.equals(info.annotations) && this.entries.equals(info.entries) && Objects.equals(this.primaryKeyId, info.primaryKeyId);
    }

    public int hashCode() {
        return Objects.hash(this.annotations, this.entries);
    }

    public String toString() {
        return String.format("(annotations=%s, entries=%s, primaryKeyId=%s)", this.annotations, this.entries, this.primaryKeyId);
    }

    public static final class Builder {
        @Nullable
        private ArrayList<Entry> builderEntries = new ArrayList();
        private MonitoringAnnotations builderAnnotations = MonitoringAnnotations.EMPTY;
        @Nullable
        private Integer builderPrimaryKeyId = null;

        public Builder setAnnotations(MonitoringAnnotations annotations) {
            if (this.builderEntries == null) {
                throw new IllegalStateException("setAnnotations cannot be called after build()");
            }
            this.builderAnnotations = annotations;
            return this;
        }

        public Builder addEntry(KeyStatus status, int keyId, Parameters parameters) {
            if (this.builderEntries == null) {
                throw new IllegalStateException("addEntry cannot be called after build()");
            }
            this.builderEntries.add(new Entry(status, keyId, parameters));
            return this;
        }

        public Builder setPrimaryKeyId(int primaryKeyId) {
            if (this.builderEntries == null) {
                throw new IllegalStateException("setPrimaryKeyId cannot be called after build()");
            }
            this.builderPrimaryKeyId = primaryKeyId;
            return this;
        }

        private boolean isKeyIdInEntries(int keyId) {
            for (Entry entry : this.builderEntries) {
                if (entry.getKeyId() != keyId) continue;
                return true;
            }
            return false;
        }

        public MonitoringKeysetInfo build() throws GeneralSecurityException {
            if (this.builderEntries == null) {
                throw new IllegalStateException("cannot call build() twice");
            }
            if (this.builderPrimaryKeyId != null && !this.isKeyIdInEntries(this.builderPrimaryKeyId)) {
                throw new GeneralSecurityException("primary key ID is not present in entries");
            }
            MonitoringKeysetInfo output = new MonitoringKeysetInfo(this.builderAnnotations, Collections.unmodifiableList(this.builderEntries), this.builderPrimaryKeyId);
            this.builderEntries = null;
            return output;
        }
    }

    @Immutable
    public static final class Entry {
        private final KeyStatus status;
        private final int keyId;
        private final Parameters parameters;

        public KeyStatus getStatus() {
            return this.status;
        }

        public int getKeyId() {
            return this.keyId;
        }

        public Parameters getParameters() {
            return this.parameters;
        }

        private Entry(KeyStatus status, int keyId, Parameters parameters) {
            this.status = status;
            this.keyId = keyId;
            this.parameters = parameters;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)obj;
            return this.status == entry.status && this.keyId == entry.keyId && this.parameters.equals(entry.parameters);
        }

        public int hashCode() {
            return Objects.hash(this.status, this.keyId, this.parameters.hashCode());
        }

        public String toString() {
            return String.format("(status=%s, keyId=%s, parameters='%s')", this.status, this.keyId, this.parameters);
        }
    }
}

