/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.internal.core.graph.TinkerpopBufferUtil;
import com.datastax.dse.driver.internal.core.graph.binary.buffer.DseNettyBufferFactory;
import com.datastax.dse.driver.internal.core.protocol.TinkerpopBufferPrimitiveCodec;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.data.SettableByIndex;
import com.datastax.oss.driver.api.core.type.CustomType;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.type.DataTypeHelper;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.PrimitiveCodec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;

class ComplexTypeSerializerUtil {
    private static final PrimitiveCodec<Buffer> codec = new TinkerpopBufferPrimitiveCodec(new DseNettyBufferFactory());

    ComplexTypeSerializerUtil() {
    }

    static void encodeTypeDefinition(DataType type, Buffer buffer, DefaultDriverContext driverContext) {
        RawType protocolType = ComplexTypeSerializerUtil.toProtocolSpec(type);
        protocolType.encode((Object)buffer, codec, driverContext.getProtocolVersion().getCode());
    }

    static DataType decodeTypeDefinition(Buffer buffer, DefaultDriverContext driverContext) {
        RawType type = RawType.decode((Object)buffer, codec, (int)driverContext.getProtocolVersion().getCode());
        return DataTypeHelper.fromProtocolSpec(type, driverContext);
    }

    static void encodeValue(@Nullable GettableByIndex value, Buffer tinkerBuff) {
        if (value == null) {
            return;
        }
        for (int i = 0; i < value.size(); ++i) {
            ByteBuffer fieldBuffer = value.getBytesUnsafe(i);
            if (fieldBuffer == null) {
                tinkerBuff.writeInt(-1);
                continue;
            }
            tinkerBuff.writeInt(fieldBuffer.remaining());
            tinkerBuff.writeBytes(fieldBuffer.duplicate());
        }
    }

    static <T extends SettableByIndex<T>> T decodeValue(Buffer tinkerBuff, T val, int size) {
        try {
            for (int i = 0; i < size; ++i) {
                int fieldSize = tinkerBuff.readInt();
                if (fieldSize < 0) continue;
                val = val.setBytesUnsafe(i, TinkerpopBufferUtil.readBytes(tinkerBuff, fieldSize));
            }
            return val;
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Not enough bytes to deserialize a UDT value", e);
        }
    }

    private static RawType toProtocolSpec(DataType dataType) {
        int id = dataType.getProtocolCode();
        RawType type = (RawType)RawType.PRIMITIVES.get(id);
        if (type != null) {
            return type;
        }
        switch (id) {
            case 0: {
                CustomType customType = (CustomType)dataType;
                type = new RawType.RawCustom(customType.getClassName());
                break;
            }
            case 32: {
                ListType listType = (ListType)dataType;
                type = new RawType.RawList(ComplexTypeSerializerUtil.toProtocolSpec(listType.getElementType()));
                break;
            }
            case 34: {
                SetType setType = (SetType)dataType;
                type = new RawType.RawSet(ComplexTypeSerializerUtil.toProtocolSpec(setType.getElementType()));
                break;
            }
            case 33: {
                MapType mapType = (MapType)dataType;
                type = new RawType.RawMap(ComplexTypeSerializerUtil.toProtocolSpec(mapType.getKeyType()), ComplexTypeSerializerUtil.toProtocolSpec(mapType.getValueType()));
                break;
            }
            case 49: {
                TupleType tupleType = (TupleType)dataType;
                ImmutableList.Builder subTypesList = ImmutableList.builderWithExpectedSize((int)tupleType.getComponentTypes().size());
                for (int i = 0; i < tupleType.getComponentTypes().size(); ++i) {
                    subTypesList.add((Object)ComplexTypeSerializerUtil.toProtocolSpec(tupleType.getComponentTypes().get(i)));
                }
                type = new RawType.RawTuple((List)subTypesList.build());
                break;
            }
            case 48: {
                UserDefinedType userDefinedType = (UserDefinedType)dataType;
                ImmutableMap.Builder subTypesMap = ImmutableMap.builderWithExpectedSize((int)userDefinedType.getFieldNames().size());
                for (int i = 0; i < userDefinedType.getFieldTypes().size(); ++i) {
                    subTypesMap.put((Object)userDefinedType.getFieldNames().get(i).asInternal(), (Object)ComplexTypeSerializerUtil.toProtocolSpec(userDefinedType.getFieldTypes().get(i)));
                }
                type = new RawType.RawUdt(Objects.requireNonNull(userDefinedType.getKeyspace()).asInternal(), userDefinedType.getName().asInternal(), (Map)subTypesMap.build());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + dataType.asCql(true, true));
            }
        }
        return type;
    }
}

