/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import org.apache.james.mailbox.cassandra.mail.task.SolveMailboxInconsistenciesService;
import org.apache.james.mailbox.cassandra.mail.task.SolveMailboxInconsistenciesTask;
import org.apache.james.webadmin.tasks.TaskFromRequestRegistry;
import org.apache.james.webadmin.tasks.TaskRegistrationKey;

public class SolveMailboxInconsistenciesRequestToTask
extends TaskFromRequestRegistry.TaskRegistration {
    private static final TaskRegistrationKey REGISTRATION_KEY = TaskRegistrationKey.of((String)"SolveInconsistencies");

    @Inject
    public SolveMailboxInconsistenciesRequestToTask(SolveMailboxInconsistenciesService service) {
        super(REGISTRATION_KEY, request -> {
            String header = request.headers("I-KNOW-WHAT-I-M-DOING");
            Preconditions.checkArgument((header != null && header.equalsIgnoreCase("ALL-SERVICES-ARE-OFFLINE") ? 1 : 0) != 0, (Object)"Due to concurrency risks, a `I-KNOW-WHAT-I-M-DOING` header should be positioned to `ALL-SERVICES-ARE-OFFLINE` in order to prevent accidental calls. Check the documentation for details.");
            return new SolveMailboxInconsistenciesTask(service);
        });
    }
}

