/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jmap.JMAPConfiguration;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.user.api.AlreadyExistInUsersRepositoryException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.util.FunctionalUtils;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class UserProvisioner {
    private final JMAPConfiguration jmapConfiguration;
    private final UsersRepository usersRepository;
    private final MetricFactory metricFactory;

    @Inject
    @VisibleForTesting
    UserProvisioner(JMAPConfiguration jmapConfiguration, UsersRepository usersRepository, MetricFactory metricFactory) {
        this.jmapConfiguration = jmapConfiguration;
        this.usersRepository = usersRepository;
        this.metricFactory = metricFactory;
    }

    public Mono<Void> provisionUser(MailboxSession session) {
        if (session != null && !this.usersRepository.isReadOnly() && this.jmapConfiguration.isUserProvisioningEnabled()) {
            return this.createAccountIfNeeded(session);
        }
        return Mono.empty();
    }

    private Mono<Void> createAccountIfNeeded(MailboxSession session) {
        Username username = session.getUser();
        return Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-user-provisioning", (Publisher)this.needsAccountCreation(username).filter(FunctionalUtils.identityPredicate()).flatMap(any -> this.createAccount(username)).onErrorResume(AlreadyExistInUsersRepositoryException.class, e -> Mono.empty())));
    }

    private Mono<Void> createAccount(Username username) {
        return Mono.fromRunnable((Runnable)Throwing.runnable(() -> this.usersRepository.addUser(username, this.generatePassword()))).subscribeOn(ReactorUtils.BLOCKING_CALL_WRAPPER).then();
    }

    private Mono<Boolean> needsAccountCreation(Username username) {
        return Mono.from((Publisher)this.usersRepository.containsReactive(username)).map(FunctionalUtils.negate());
    }

    private String generatePassword() {
        return UUID.randomUUID().toString();
    }
}

