/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jsieve.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jsieve.Argument;
import org.apache.jsieve.NumberArgument;
import org.apache.jsieve.StringListArgument;
import org.apache.jsieve.TagArgument;
import org.apache.jsieve.exception.SyntaxException;

public class ArgumentParser {
    private List<Argument> remainingArguments = new ArrayList<Argument>();
    private Set<String> singleTags = new HashSet<String>();
    private Map<String, Argument> tagsWithValues = new HashMap<String, Argument>();

    public ArgumentParser(List<Argument> arguments) {
        this.initialize(arguments);
    }

    public void initialize(List<Argument> arguments) {
        TagArgument previousSeenTagArgument = null;
        for (Argument argument : arguments) {
            if (argument instanceof TagArgument) {
                TagArgument tagArgument = (TagArgument)argument;
                this.handlePreviousTagArgument(previousSeenTagArgument);
                previousSeenTagArgument = tagArgument;
                continue;
            }
            this.handleOtherArguments(previousSeenTagArgument, argument);
            previousSeenTagArgument = null;
        }
        if (previousSeenTagArgument != null) {
            this.singleTags.add(previousSeenTagArgument.getTag());
        }
    }

    private void handlePreviousTagArgument(TagArgument previousSeenTagArgument) {
        if (previousSeenTagArgument != null) {
            this.singleTags.add(previousSeenTagArgument.getTag());
        }
    }

    private void handleOtherArguments(TagArgument lastSeenTagArgument, Argument argument) {
        if (lastSeenTagArgument == null) {
            this.remainingArguments.add(argument);
        } else {
            this.tagsWithValues.put(lastSeenTagArgument.getTag(), argument);
        }
    }

    public String getStringValueForTag(String tag, String exceptionMessage) throws SyntaxException {
        Argument argument = this.retrieveArgumentIfExists(tag, exceptionMessage);
        if (argument == null) {
            return null;
        }
        return this.retrieveSingleStringValue(argument, exceptionMessage);
    }

    public Integer getNumericValueForTag(String tag, String exceptionMessage) throws SyntaxException {
        Argument argument = this.retrieveArgumentIfExists(tag, exceptionMessage);
        if (argument == null) {
            return null;
        }
        return this.retrieveNumericValue(argument, exceptionMessage);
    }

    public List<String> getStringListForTag(String tag, String exceptionMessage) throws SyntaxException {
        Argument argument = this.retrieveArgumentIfExists(tag, exceptionMessage);
        if (argument == null) {
            return new ArrayList<String>();
        }
        return this.retrieveStringValues(argument, exceptionMessage);
    }

    public Set<String> getSingleTags() {
        return new HashSet<String>(this.singleTags);
    }

    public String getRemainingStringValue(String exceptionMessage) throws SyntaxException {
        if (this.remainingArguments.size() > 1) {
            throw new SyntaxException(exceptionMessage);
        }
        if (this.remainingArguments.size() == 0) {
            return null;
        }
        return this.retrieveSingleStringValue(this.remainingArguments.get(0), exceptionMessage);
    }

    public void throwOnUnvalidSeenSingleTag(String ... validTags) throws SyntaxException {
        this.validateTagCollectionWithExpectations(this.singleTags, validTags);
    }

    public void throwOnUnvalidSeenTagWithValue(String ... validTags) throws SyntaxException {
        this.validateTagCollectionWithExpectations(this.tagsWithValues.keySet(), validTags);
    }

    private void validateTagCollectionWithExpectations(Set<String> seenTags, String[] expectations) throws SyntaxException {
        Set<String> validTagList = this.getSetFromStringArray(expectations);
        if (!validTagList.containsAll(seenTags)) {
            throw new SyntaxException(this.buildUnwantedTagsErrorMessage(this.retrieveUnwantedTags(seenTags, validTagList)));
        }
    }

    private Set<String> getSetFromStringArray(String[] validTags) {
        HashSet<String> validTagList = new HashSet<String>();
        for (String validTag : validTags) {
            validTagList.add(validTag);
        }
        return validTagList;
    }

    private Set<String> retrieveUnwantedTags(Set<String> seenTags, Set<String> validTagList) {
        HashSet<String> unwantedTags = new HashSet<String>(seenTags);
        unwantedTags.removeAll(validTagList);
        return unwantedTags;
    }

    private String buildUnwantedTagsErrorMessage(Set<String> unwantedTags) {
        StringBuilder errorMessageBuilder = new StringBuilder().append("Unexpected tags : [");
        for (String unwantedTag : unwantedTags) {
            errorMessageBuilder.append("\"").append(unwantedTag).append("\"");
        }
        errorMessageBuilder.append("]");
        String errorMessage = errorMessageBuilder.toString();
        return errorMessage;
    }

    private Argument retrieveArgumentIfExists(String tag, String exceptionMessage) throws SyntaxException {
        Argument argument = this.tagsWithValues.get(tag);
        if (argument == null) {
            if (this.singleTags.contains(tag)) {
                throw new SyntaxException(exceptionMessage);
            }
            return null;
        }
        return argument;
    }

    private List<String> retrieveStringValues(Argument argument, String exceptionMessage) throws SyntaxException {
        if (!(argument instanceof StringListArgument)) {
            throw new SyntaxException(exceptionMessage);
        }
        StringListArgument stringListArgument = (StringListArgument)argument;
        return stringListArgument.getList();
    }

    private String retrieveSingleStringValue(Argument argument, String exceptionMessage) throws SyntaxException {
        List<String> stringsValue = this.retrieveStringValues(argument, exceptionMessage);
        if (stringsValue.size() != 1) {
            throw new SyntaxException(exceptionMessage);
        }
        return stringsValue.get(0);
    }

    private Integer retrieveNumericValue(Argument argument, String exceptionMessage) throws SyntaxException {
        if (!(argument instanceof NumberArgument)) {
            throw new SyntaxException(exceptionMessage);
        }
        NumberArgument numberArgument = (NumberArgument)argument;
        return numberArgument.getInteger();
    }
}

