/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogFieldSyntax;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RedactedValueException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.TokenizedValueException;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBuffer;
import com.unboundid.util.json.JSONField;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONLogFieldSyntax
extends LogFieldSyntax<JSONObject> {
    @NotNull
    public static final String SYNTAX_NAME = "json";
    @NotNull
    private static final JSONObject REDACTED_JSON_OBJECT = new JSONObject(new JSONField("redacted", "{REDACTED}"));
    @NotNull
    private static final String REDACTED_JSON_OBJECT_STRING = REDACTED_JSON_OBJECT.toSingleLineString();
    @NotNull
    private static final String REDACTED_JSON_OBJECT_STRING_WITH_REPLACED_QUOTES = REDACTED_JSON_OBJECT_STRING.replace('\"', '\'');
    private final boolean allFieldsAreSensitive;
    @NotNull
    private final Set<String> excludedSensitiveFields;
    @NotNull
    private final Set<String> includedSensitiveFields;

    public JSONLogFieldSyntax(int maxStringLengthCharacters, @Nullable Collection<String> includedSensitiveFields, @Nullable Collection<String> excludedSensitiveFields) {
        super(maxStringLengthCharacters);
        this.includedSensitiveFields = JSONLogFieldSyntax.getLowercaseNames(includedSensitiveFields);
        this.excludedSensitiveFields = JSONLogFieldSyntax.getLowercaseNames(excludedSensitiveFields);
        this.allFieldsAreSensitive = this.includedSensitiveFields.isEmpty() && this.excludedSensitiveFields.isEmpty();
    }

    @NotNull
    private static Set<String> getLowercaseNames(@Nullable Collection<String> names) {
        if (names == null) {
            return Collections.emptySet();
        }
        HashSet<String> lowercaseNames = new HashSet<String>();
        for (String name : names) {
            lowercaseNames.add(StaticUtils.toLowerCase(name));
        }
        return Collections.unmodifiableSet(lowercaseNames);
    }

    @NotNull
    public Set<String> getIncludedSensitiveFields() {
        return this.includedSensitiveFields;
    }

    @NotNull
    public Set<String> getExcludedSensitiveFields() {
        return this.excludedSensitiveFields;
    }

    @Override
    @NotNull
    public String getSyntaxName() {
        return SYNTAX_NAME;
    }

    @Override
    public void valueToSanitizedString(@NotNull JSONObject value, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.sanitize(value).toSingleLineString());
    }

    @NotNull
    private JSONValue sanitize(@NotNull JSONValue value) {
        if (value instanceof JSONObject) {
            Map<String, JSONValue> originalFields = ((JSONObject)value).getFields();
            LinkedHashMap<String, JSONValue> sanitizedFields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(originalFields.size()));
            for (Map.Entry<String, JSONValue> e : originalFields.entrySet()) {
                sanitizedFields.put(e.getKey(), this.sanitize(e.getValue()));
            }
            return new JSONObject(sanitizedFields);
        }
        if (value instanceof JSONArray) {
            List<JSONValue> originalValues = ((JSONArray)value).getValues();
            ArrayList<JSONValue> sanitizedValues = new ArrayList<JSONValue>(originalValues.size());
            for (JSONValue v : originalValues) {
                sanitizedValues.add(this.sanitize(v));
            }
            return new JSONArray(sanitizedValues);
        }
        if (value instanceof JSONString) {
            String stringValue = ((JSONString)value).stringValue();
            return new JSONString(this.sanitize(stringValue));
        }
        return value;
    }

    @Override
    public void logSanitizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull JSONObject fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append(this.valueToSanitizedString(fieldValue).replace('\"', '\''));
        buffer.append('\"');
    }

    @Override
    public void logSanitizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONObject fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendValue(fieldName, this.sanitize(fieldValue));
    }

    @Override
    public void logSanitizedValueToJSONFormattedLog(@NotNull JSONObject value, @NotNull JSONBuffer buffer) {
        buffer.appendValue(this.sanitize(value));
    }

    @Override
    @NotNull
    public JSONObject parseValue(@NotNull String valueString) throws RedactedValueException, TokenizedValueException, LogSyntaxException {
        try {
            return new JSONObject(valueString);
        }
        catch (Exception e) {
            Debug.debugException(e);
            if (this.valueStringIsCompletelyRedacted(valueString)) {
                throw new RedactedValueException(LogSyntaxMessages.ERR_JSON_LOG_SYNTAX_CANNOT_PARSE_REDACTED.get(), e);
            }
            if (this.valueStringIsCompletelyTokenized(valueString)) {
                throw new TokenizedValueException(LogSyntaxMessages.ERR_JSON_LOG_SYNTAX_CANNOT_PARSE_TOKENIZED.get(), e);
            }
            throw new LogSyntaxException(LogSyntaxMessages.ERR_JSON_LOG_SYNTAX_CANNOT_PARSE.get(), e);
        }
    }

    @Override
    public boolean valueStringIsCompletelyRedacted(@NotNull String valueString) {
        return valueString.equals("{REDACTED}") || valueString.equals(REDACTED_JSON_OBJECT_STRING);
    }

    @Override
    public boolean completelyRedactedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void redactEntireValue(@NotNull ByteStringBuffer buffer) {
        buffer.append(REDACTED_JSON_OBJECT_STRING);
    }

    @Override
    public void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append(REDACTED_JSON_OBJECT_STRING_WITH_REPLACED_QUOTES);
        buffer.append('\"');
    }

    @Override
    public void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONBuffer buffer) {
        buffer.appendValue(fieldName, REDACTED_JSON_OBJECT);
    }

    @Override
    public void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer buffer) {
        buffer.appendValue(REDACTED_JSON_OBJECT);
    }

    @Override
    public boolean supportsRedactedComponents() {
        return true;
    }

    @Override
    public boolean valueWithRedactedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void redactComponents(@NotNull JSONObject value, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.redactValue(value).toString());
    }

    @NotNull
    private JSONValue redactValue(@NotNull JSONValue value) {
        if (value instanceof JSONObject) {
            Map<String, JSONValue> originalFields = ((JSONObject)value).getFields();
            LinkedHashMap<String, JSONValue> redactedFields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(originalFields.size()));
            for (Map.Entry<String, JSONValue> e : originalFields.entrySet()) {
                String fieldName = e.getKey();
                if (this.shouldRedactOrTokenize(fieldName)) {
                    redactedFields.put(fieldName, new JSONString("{REDACTED}"));
                    continue;
                }
                redactedFields.put(fieldName, this.redactValue(e.getValue()));
            }
            return new JSONObject(redactedFields);
        }
        if (value instanceof JSONArray) {
            List<JSONValue> originalValues = ((JSONArray)value).getValues();
            ArrayList<JSONValue> redactedValues = new ArrayList<JSONValue>(originalValues.size());
            for (JSONValue v : originalValues) {
                redactedValues.add(this.redactValue(v));
            }
            return new JSONArray(redactedValues);
        }
        return this.sanitize(value);
    }

    private boolean shouldRedactOrTokenize(@NotNull String fieldName) {
        if (this.allFieldsAreSensitive) {
            return true;
        }
        String lowerName = StaticUtils.toLowerCase(fieldName);
        if (this.includedSensitiveFields.contains(lowerName)) {
            return true;
        }
        if (this.excludedSensitiveFields.isEmpty()) {
            return false;
        }
        return !this.excludedSensitiveFields.contains(lowerName);
    }

    @Override
    public void logRedactedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull JSONObject fieldValue, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append(this.redactComponents(fieldValue).replace('\"', '\''));
        buffer.append('\"');
    }

    @Override
    public void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONObject fieldValue, @NotNull JSONBuffer buffer) {
        buffer.appendValue(fieldName, this.redactValue(fieldValue));
    }

    @Override
    public void logRedactedComponentsValueToJSONFormattedLog(@NotNull JSONObject value, @NotNull JSONBuffer buffer) {
        buffer.appendValue(this.redactValue(value));
    }

    @Override
    public boolean valueStringIsCompletelyTokenized(@NotNull String valueString) {
        if (super.valueStringIsCompletelyTokenized(valueString)) {
            return true;
        }
        try {
            JSONObject jsonObject = new JSONObject(valueString);
            Map<String, JSONValue> fields = jsonObject.getFields();
            return fields.size() == 1 && fields.containsKey("tokenized");
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    @Override
    public boolean completelyTokenizedValueConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeEntireValue(@NotNull JSONObject value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        JSONObject tokenizedObject = new JSONObject(new JSONField("tokenized", this.tokenize(value.toNormalizedString(), pepper)));
        buffer.append(tokenizedObject.toSingleLineString());
    }

    @Override
    public void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String fieldName, @NotNull JSONObject fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append(this.tokenizeEntireValue(fieldValue, pepper).replace('\"', '\''));
        buffer.append('\"');
    }

    @Override
    public void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONObject fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendValue(fieldName, new JSONObject(new JSONField("tokenized", this.tokenize(fieldValue.toNormalizedString(), pepper))));
    }

    @Override
    public void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull JSONObject value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendValue(new JSONObject(new JSONField("tokenized", this.tokenize(value.toNormalizedString(), pepper))));
    }

    @Override
    public boolean supportsTokenizedComponents() {
        return true;
    }

    @Override
    public boolean valueWithTokenizedComponentsConformsToSyntax() {
        return true;
    }

    @Override
    public void tokenizeComponents(@NotNull JSONObject value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(this.tokenizeValue(value, pepper).toString());
    }

    @NotNull
    private JSONValue tokenizeValue(@NotNull JSONValue value, @NotNull byte[] pepper) {
        if (value instanceof JSONObject) {
            Map<String, JSONValue> originalFields = ((JSONObject)value).getFields();
            LinkedHashMap<String, JSONValue> tokenizedFields = new LinkedHashMap<String, JSONValue>(StaticUtils.computeMapCapacity(originalFields.size()));
            for (Map.Entry<String, JSONValue> e : originalFields.entrySet()) {
                String fieldName = e.getKey();
                JSONValue fieldValue = e.getValue();
                if (this.shouldRedactOrTokenize(fieldName)) {
                    String tokenizedValue = this.tokenize(fieldValue.toNormalizedString(), pepper);
                    tokenizedFields.put(fieldName, new JSONString(tokenizedValue));
                    continue;
                }
                tokenizedFields.put(fieldName, this.tokenizeValue(fieldValue, pepper));
            }
            return new JSONObject(tokenizedFields);
        }
        if (value instanceof JSONArray) {
            List<JSONValue> originalValues = ((JSONArray)value).getValues();
            ArrayList<JSONValue> tokenizedValues = new ArrayList<JSONValue>(originalValues.size());
            for (JSONValue v : originalValues) {
                tokenizedValues.add(this.tokenizeValue(v, pepper));
            }
            return new JSONArray(tokenizedValues);
        }
        return this.sanitize(value);
    }

    @Override
    public void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String fieldName, @NotNull JSONObject fieldValue, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        buffer.append(' ');
        buffer.append(fieldName);
        buffer.append("=\"");
        buffer.append(this.tokenizeComponents(fieldValue, pepper).replace('\"', '\''));
        buffer.append('\"');
    }

    @Override
    public void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String fieldName, @NotNull JSONObject fieldValue, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendValue(fieldName, this.tokenizeValue(fieldValue, pepper));
    }

    @Override
    public void logTokenizedComponentsValueToJSONFormattedLog(@NotNull JSONObject value, @NotNull byte[] pepper, @NotNull JSONBuffer buffer) {
        buffer.appendValue(this.tokenizeValue(value, pepper));
    }
}

