/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.inmemory.mail;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.james.mailbox.inmemory.InMemoryId;
import org.apache.james.mailbox.model.MailboxAnnotation;
import org.apache.james.mailbox.model.MailboxAnnotationKey;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.store.mail.AnnotationMapper;

public class InMemoryAnnotationMapper
implements AnnotationMapper {
    private final Table<InMemoryId, String, String> mailboxesAnnotations;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public InMemoryAnnotationMapper() {
        this.mailboxesAnnotations = HashBasedTable.create();
    }

    private List<MailboxAnnotation> retrieveAllAnnotations(InMemoryId mailboxId) {
        this.lock.readLock().lock();
        try {
            List list = (List)this.mailboxesAnnotations.row((Object)mailboxId).entrySet().stream().map(input -> MailboxAnnotation.newInstance((MailboxAnnotationKey)new MailboxAnnotationKey((String)input.getKey()), (String)((String)input.getValue()))).collect(ImmutableList.toImmutableList());
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<MailboxAnnotation> getAllAnnotations(MailboxId mailboxId) {
        return this.retrieveAllAnnotations((InMemoryId)mailboxId);
    }

    public List<MailboxAnnotation> getAnnotationsByKeys(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.retrieveAllAnnotations((InMemoryId)mailboxId).stream().filter(input -> keys.contains(input.getKey())).collect(ImmutableList.toImmutableList());
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithAllDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.retrieveAllAnnotations((InMemoryId)mailboxId).stream().filter(this.getPredicateFilterByAll(keys)).collect(ImmutableList.toImmutableList());
    }

    public List<MailboxAnnotation> getAnnotationsByKeysWithOneDepth(MailboxId mailboxId, Set<MailboxAnnotationKey> keys) {
        return (List)this.getAnnotationsByKeysWithAllDepth(mailboxId, keys).stream().filter(this.getPredicateFilterByOne(keys)).collect(ImmutableList.toImmutableList());
    }

    private Predicate<MailboxAnnotation> getPredicateFilterByAll(Set<MailboxAnnotationKey> keys) {
        return input -> keys.stream().anyMatch(this.filterAnnotationsByPrefix((MailboxAnnotation)input));
    }

    private Predicate<MailboxAnnotation> getPredicateFilterByOne(Set<MailboxAnnotationKey> keys) {
        return input -> keys.stream().anyMatch(this.filterAnnotationsByParentKey(input.getKey()));
    }

    private Predicate<MailboxAnnotationKey> filterAnnotationsByParentKey(MailboxAnnotationKey input) {
        return key -> input.countComponents() <= key.countComponents() + 1;
    }

    private Predicate<MailboxAnnotationKey> filterAnnotationsByPrefix(MailboxAnnotation input) {
        return key -> key.equals((Object)input.getKey()) || StringUtils.startsWith((CharSequence)input.getKey().asString(), (CharSequence)(key.asString() + "/"));
    }

    public void insertAnnotation(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        Preconditions.checkArgument((!mailboxAnnotation.isNil() ? 1 : 0) != 0);
        this.lock.writeLock().lock();
        try {
            this.mailboxesAnnotations.put((Object)((InMemoryId)mailboxId), (Object)mailboxAnnotation.getKey().asString(), (Object)((String)mailboxAnnotation.getValue().get()));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void deleteAnnotation(MailboxId mailboxId, MailboxAnnotationKey key) {
        this.lock.writeLock().lock();
        try {
            this.mailboxesAnnotations.remove((Object)((InMemoryId)mailboxId), (Object)key.asString());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean exist(MailboxId mailboxId, MailboxAnnotation mailboxAnnotation) {
        return this.mailboxesAnnotations.contains((Object)((InMemoryId)mailboxId), (Object)mailboxAnnotation.getKey().asString());
    }

    public int countAnnotations(MailboxId mailboxId) {
        return this.mailboxesAnnotations.row((Object)((InMemoryId)mailboxId)).size();
    }
}

