/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.memory.change;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collector;
import org.apache.james.jmap.api.change.EmailChange;
import org.apache.james.jmap.api.change.EmailChangeRepository;
import org.apache.james.jmap.api.change.EmailChanges;
import org.apache.james.jmap.api.change.Limit;
import org.apache.james.jmap.api.change.State;
import org.apache.james.jmap.api.exception.ChangeNotFoundException;
import org.apache.james.jmap.api.model.AccountId;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MemoryEmailChangeRepository
implements EmailChangeRepository {
    public static final String LIMIT_NAME = "emailChangeDefaultLimit";
    private final Multimap<AccountId, EmailChange> emailChangeMap;
    private final Limit defaultLimit;

    @Inject
    public MemoryEmailChangeRepository(@Named(value="emailChangeDefaultLimit") Limit defaultLimit) {
        this.defaultLimit = defaultLimit;
        this.emailChangeMap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
    }

    @Override
    public Mono<Void> save(EmailChange change) {
        Preconditions.checkNotNull((Object)change.getAccountId());
        Preconditions.checkNotNull((Object)change.getState());
        return Mono.just((Object)this.emailChangeMap.put((Object)change.getAccountId(), (Object)change)).then();
    }

    @Override
    public Mono<State> getLatestState(AccountId accountId) {
        return this.allChanges(accountId).filter(change -> !change.isShared()).map(EmailChange::getState).last((Object)State.INITIAL);
    }

    @Override
    public Mono<EmailChanges> getSinceState(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        maxChanges.ifPresent(limit -> Preconditions.checkArgument((limit.getValue() > 0 ? 1 : 0) != 0, (Object)"maxChanges must be a positive integer"));
        return this.resolveAllChanges(accountId, state).filter(change -> !change.isShared()).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    @Override
    public Mono<EmailChanges> getSinceStateWithDelegation(AccountId accountId, State state, Optional<Limit> maxChanges) {
        Preconditions.checkNotNull((Object)accountId);
        Preconditions.checkNotNull((Object)state);
        return this.resolveAllChanges(accountId, state).collect((Collector)new EmailChanges.Builder.EmailChangeCollector(state, maxChanges.orElse(this.defaultLimit)));
    }

    @Override
    public Mono<State> getLatestStateWithDelegation(AccountId accountId) {
        return this.allChanges(accountId).sort(Comparator.comparing(EmailChange::getDate)).map(EmailChange::getState).last((Object)State.INITIAL);
    }

    private Flux<EmailChange> resolveAllChanges(AccountId accountId, State state) {
        if (state.equals(State.INITIAL)) {
            return this.allChanges(accountId);
        }
        return this.allChangesSince(accountId, state);
    }

    private Flux<EmailChange> allChangesSince(AccountId accountId, State state) {
        return this.findByState(accountId, state).flatMapIterable(currentState -> (Iterable)this.emailChangeMap.get((Object)accountId).stream().filter(change -> change.getDate().isAfter(currentState.getDate())).sorted(Comparator.comparing(EmailChange::getDate)).collect(ImmutableList.toImmutableList()));
    }

    private Flux<EmailChange> allChanges(AccountId accountId) {
        return Flux.fromIterable((Iterable)this.emailChangeMap.get((Object)accountId)).sort(Comparator.comparing(EmailChange::getDate));
    }

    private Mono<EmailChange> findByState(AccountId accountId, State state) {
        return Flux.fromIterable((Iterable)this.emailChangeMap.get((Object)accountId)).filter(change -> change.getState().equals(state)).switchIfEmpty((Publisher)Mono.error(() -> new ChangeNotFoundException(state, String.format("State '%s' could not be found", state.getValue())))).single();
    }
}

