/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.server.core.filesystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.apache.james.filesystem.api.FileSystem;
import org.apache.james.filesystem.api.JamesDirectoriesProvider;
import org.apache.james.server.core.JamesServerResourceLoader;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.server.core.filesystem.ResourceFactory;

public class FileSystemImpl
implements FileSystem {
    private final JamesDirectoriesProvider directoryProvider;
    private final ResourceFactory resourceLoader;

    public static FileSystemImpl forTesting() {
        return new FileSystemImpl(new JamesServerResourceLoader("../testsFileSystemExtension/" + String.valueOf(UUID.randomUUID())));
    }

    public static FileSystemImpl forTestingWithConfigurationFromClasspath() {
        return new FileSystemImpl(Configuration.builder().workingDirectory("../").configurationFromClasspath().build().directories());
    }

    public FileSystemImpl(JamesDirectoriesProvider directoryProvider) {
        this.directoryProvider = directoryProvider;
        this.resourceLoader = new ResourceFactory(directoryProvider);
    }

    public File getBasedir() throws FileNotFoundException {
        return new File(this.directoryProvider.getRootDirectory());
    }

    public InputStream getResource(String url) throws IOException {
        return this.resourceLoader.getResource(url).getInputStream();
    }

    public File getFile(String fileURL) throws FileNotFoundException {
        try {
            return this.resourceLoader.getResource(fileURL).getFile();
        }
        catch (IOException e) {
            throw new FileNotFoundException(e.getMessage());
        }
    }

    public File getFileWithinBaseDir(String fileURL) throws FileNotFoundException, IOException {
        File file = this.getFile(fileURL);
        this.resourceLoader.validate(file);
        return file;
    }
}

