/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.protocol;

import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.FrameCodec;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.util.List;
import net.jcip.annotations.ThreadSafe;

@ChannelHandler.Sharable
@ThreadSafe
public class FrameEncoder
extends MessageToMessageEncoder<Frame> {
    private final FrameCodec<ByteBuf> frameCodec;
    private final int maxFrameLength;

    public FrameEncoder(FrameCodec<ByteBuf> frameCodec, int maxFrameLength) {
        super(Frame.class);
        this.frameCodec = frameCodec;
        this.maxFrameLength = maxFrameLength;
    }

    protected void encode(ChannelHandlerContext ctx, Frame frame, List<Object> out) throws Exception {
        ByteBuf buffer = (ByteBuf)this.frameCodec.encode(frame);
        int actualLength = buffer.readableBytes();
        if (actualLength > this.maxFrameLength) {
            throw new FrameTooLongException(ctx.channel().remoteAddress(), String.format("Outgoing frame length exceeds %d: %d", this.maxFrameLength, actualLength));
        }
        out.add(buffer);
    }
}

