/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.postgres;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.apache.james.backends.postgres.RowLevelSecurity;
import org.jooq.DDLQuery;
import org.jooq.DSLContext;

public class PostgresTable {
    private final String name;
    private final boolean supportsRowLevelSecurity;
    private final Function<DSLContext, DDLQuery> createTableStepFunction;
    private final List<AdditionalAlterQuery> additionalAlterQueries;

    public static RequireCreateTableStep name(String tableName) {
        Preconditions.checkNotNull((Object)tableName);
        String strategyName = tableName.toLowerCase();
        return createTableFunction -> supportsRowLevelSecurity -> new FinalStage(strategyName, supportsRowLevelSecurity, dsl -> createTableFunction.createTable((DSLContext)dsl, strategyName));
    }

    private PostgresTable(String name, boolean supportsRowLevelSecurity, Function<DSLContext, DDLQuery> createTableStepFunction, List<AdditionalAlterQuery> additionalAlterQueries) {
        this.name = name;
        this.supportsRowLevelSecurity = supportsRowLevelSecurity;
        this.createTableStepFunction = createTableStepFunction;
        this.additionalAlterQueries = additionalAlterQueries;
    }

    public String getName() {
        return this.name;
    }

    public Function<DSLContext, DDLQuery> getCreateTableStepFunction() {
        return this.createTableStepFunction;
    }

    public boolean supportsRowLevelSecurity() {
        return this.supportsRowLevelSecurity;
    }

    public List<AdditionalAlterQuery> getAdditionalAlterQueries() {
        return this.additionalAlterQueries;
    }

    @FunctionalInterface
    public static interface RequireCreateTableStep {
        public RequireRowLevelSecurity createTableStep(CreateTableFunction var1);
    }

    @FunctionalInterface
    public static interface CreateTableFunction {
        public DDLQuery createTable(DSLContext var1, String var2);
    }

    @FunctionalInterface
    public static interface RequireRowLevelSecurity {
        public FinalStage supportsRowLevelSecurity(boolean var1);

        default public FinalStage disableRowLevelSecurity() {
            return this.supportsRowLevelSecurity(false);
        }

        default public FinalStage supportsRowLevelSecurity() {
            return this.supportsRowLevelSecurity(true);
        }
    }

    public static class FinalStage {
        private final String tableName;
        private final boolean supportsRowLevelSecurity;
        private final Function<DSLContext, DDLQuery> createTableStepFunction;
        private final ImmutableList.Builder<AdditionalAlterQuery> additionalAlterQueries;

        public FinalStage(String tableName, boolean supportsRowLevelSecurity, Function<DSLContext, DDLQuery> createTableStepFunction) {
            this.tableName = tableName;
            this.supportsRowLevelSecurity = supportsRowLevelSecurity;
            this.createTableStepFunction = createTableStepFunction;
            this.additionalAlterQueries = ImmutableList.builder();
        }

        public FinalStage addAdditionalAlterQueries(String ... additionalAlterQueries) {
            this.additionalAlterQueries.addAll(Arrays.stream(additionalAlterQueries).map(AllCasesAdditionalAlterQuery::new).toList());
            return this;
        }

        public FinalStage addAdditionalAlterQueries(AdditionalAlterQuery ... additionalAlterQueries) {
            this.additionalAlterQueries.add((Object[])additionalAlterQueries);
            return this;
        }

        public PostgresTable build() {
            return new PostgresTable(this.tableName, this.supportsRowLevelSecurity, this.createTableStepFunction, (List<AdditionalAlterQuery>)this.additionalAlterQueries.build());
        }
    }

    public static class AllCasesAdditionalAlterQuery
    extends AdditionalAlterQuery {
        public AllCasesAdditionalAlterQuery(String query) {
            super(query);
        }

        @Override
        boolean shouldBeApplied(RowLevelSecurity rowLevelSecurity) {
            return true;
        }
    }

    public static class NonRLSOnlyAdditionalAlterQuery
    extends AdditionalAlterQuery {
        public NonRLSOnlyAdditionalAlterQuery(String query) {
            super(query);
        }

        @Override
        boolean shouldBeApplied(RowLevelSecurity rowLevelSecurity) {
            return !rowLevelSecurity.isRowLevelSecurityEnabled();
        }
    }

    public static class RLSOnlyAdditionalAlterQuery
    extends AdditionalAlterQuery {
        public RLSOnlyAdditionalAlterQuery(String query) {
            super(query);
        }

        @Override
        boolean shouldBeApplied(RowLevelSecurity rowLevelSecurity) {
            return rowLevelSecurity.isRowLevelSecurityEnabled();
        }
    }

    public static abstract class AdditionalAlterQuery {
        private String query;

        public AdditionalAlterQuery(String query) {
            this.query = query;
        }

        abstract boolean shouldBeApplied(RowLevelSecurity var1);

        public String getQuery() {
            return this.query;
        }
    }
}

