/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Enumerated;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordPolicyStateOperation
implements Serializable {
    public static final int OP_TYPE_GET_PW_POLICY_DN = 0;
    public static final int OP_TYPE_GET_ACCOUNT_DISABLED_STATE = 1;
    public static final int OP_TYPE_SET_ACCOUNT_DISABLED_STATE = 2;
    public static final int OP_TYPE_CLEAR_ACCOUNT_DISABLED_STATE = 3;
    public static final int OP_TYPE_GET_ACCOUNT_EXPIRATION_TIME = 4;
    public static final int OP_TYPE_SET_ACCOUNT_EXPIRATION_TIME = 5;
    public static final int OP_TYPE_CLEAR_ACCOUNT_EXPIRATION_TIME = 6;
    public static final int OP_TYPE_GET_SECONDS_UNTIL_ACCOUNT_EXPIRATION = 7;
    public static final int OP_TYPE_GET_PW_CHANGED_TIME = 8;
    public static final int OP_TYPE_SET_PW_CHANGED_TIME = 9;
    public static final int OP_TYPE_CLEAR_PW_CHANGED_TIME = 10;
    public static final int OP_TYPE_GET_PW_EXPIRATION_WARNED_TIME = 11;
    public static final int OP_TYPE_SET_PW_EXPIRATION_WARNED_TIME = 12;
    public static final int OP_TYPE_CLEAR_PW_EXPIRATION_WARNED_TIME = 13;
    public static final int OP_TYPE_GET_SECONDS_UNTIL_PW_EXPIRATION = 14;
    public static final int OP_TYPE_GET_SECONDS_UNTIL_PW_EXPIRATION_WARNING = 15;
    public static final int OP_TYPE_GET_AUTH_FAILURE_TIMES = 16;
    public static final int OP_TYPE_ADD_AUTH_FAILURE_TIME = 17;
    public static final int OP_TYPE_SET_AUTH_FAILURE_TIMES = 18;
    public static final int OP_TYPE_CLEAR_AUTH_FAILURE_TIMES = 19;
    public static final int OP_TYPE_GET_SECONDS_UNTIL_AUTH_FAILURE_UNLOCK = 20;
    public static final int OP_TYPE_GET_REMAINING_AUTH_FAILURE_COUNT = 21;
    public static final int OP_TYPE_GET_LAST_LOGIN_TIME = 22;
    public static final int OP_TYPE_SET_LAST_LOGIN_TIME = 23;
    public static final int OP_TYPE_CLEAR_LAST_LOGIN_TIME = 24;
    public static final int OP_TYPE_GET_SECONDS_UNTIL_IDLE_LOCKOUT = 25;
    public static final int OP_TYPE_GET_PW_RESET_STATE = 26;
    public static final int OP_TYPE_SET_PW_RESET_STATE = 27;
    public static final int OP_TYPE_CLEAR_PW_RESET_STATE = 28;
    public static final int OP_TYPE_GET_SECONDS_UNTIL_PW_RESET_LOCKOUT = 29;
    public static final int OP_TYPE_GET_GRACE_LOGIN_USE_TIMES = 30;
    public static final int OP_TYPE_ADD_GRACE_LOGIN_USE_TIME = 31;
    public static final int OP_TYPE_SET_GRACE_LOGIN_USE_TIMES = 32;
    public static final int OP_TYPE_CLEAR_GRACE_LOGIN_USE_TIMES = 33;
    public static final int OP_TYPE_GET_REMAINING_GRACE_LOGIN_COUNT = 34;
    public static final int OP_TYPE_GET_PW_CHANGED_BY_REQUIRED_TIME = 35;
    public static final int OP_TYPE_SET_PW_CHANGED_BY_REQUIRED_TIME = 36;
    public static final int OP_TYPE_CLEAR_PW_CHANGED_BY_REQUIRED_TIME = 37;
    public static final int OP_TYPE_GET_SECONDS_UNTIL_REQUIRED_CHANGE_TIME = 38;
    @Deprecated
    public static final int OP_TYPE_GET_PW_HISTORY = 39;
    public static final int OP_TYPE_CLEAR_PW_HISTORY = 40;
    public static final int OP_TYPE_HAS_RETIRED_PASSWORD = 41;
    public static final int OP_TYPE_GET_PASSWORD_RETIRED_TIME = 42;
    public static final int OP_TYPE_GET_RETIRED_PASSWORD_EXPIRATION_TIME = 43;
    public static final int OP_TYPE_PURGE_RETIRED_PASSWORD = 44;
    public static final int OP_TYPE_GET_ACCOUNT_ACTIVATION_TIME = 45;
    public static final int OP_TYPE_SET_ACCOUNT_ACTIVATION_TIME = 46;
    public static final int OP_TYPE_CLEAR_ACCOUNT_ACTIVATION_TIME = 47;
    public static final int OP_TYPE_GET_SECONDS_UNTIL_ACCOUNT_ACTIVATION = 48;
    public static final int OP_TYPE_GET_LAST_LOGIN_IP_ADDRESS = 49;
    public static final int OP_TYPE_SET_LAST_LOGIN_IP_ADDRESS = 50;
    public static final int OP_TYPE_CLEAR_LAST_LOGIN_IP_ADDRESS = 51;
    public static final int OP_TYPE_GET_ACCOUNT_USABILITY_NOTICES = 52;
    public static final int OP_TYPE_GET_ACCOUNT_USABILITY_WARNINGS = 53;
    public static final int OP_TYPE_GET_ACCOUNT_USABILITY_ERRORS = 54;
    public static final int OP_TYPE_GET_ACCOUNT_IS_USABLE = 55;
    public static final int OP_TYPE_GET_ACCOUNT_IS_NOT_YET_ACTIVE = 56;
    public static final int OP_TYPE_GET_ACCOUNT_IS_EXPIRED = 57;
    public static final int OP_TYPE_GET_PW_EXPIRATION_TIME = 58;
    public static final int OP_TYPE_GET_ACCOUNT_IS_FAILURE_LOCKED = 59;
    public static final int OP_TYPE_SET_ACCOUNT_IS_FAILURE_LOCKED = 60;
    public static final int OP_TYPE_GET_FAILURE_LOCKOUT_TIME = 61;
    public static final int OP_TYPE_GET_ACCOUNT_IS_IDLE_LOCKED = 62;
    public static final int OP_TYPE_GET_IDLE_LOCKOUT_TIME = 63;
    public static final int OP_TYPE_GET_ACCOUNT_IS_RESET_LOCKED = 64;
    public static final int OP_TYPE_GET_RESET_LOCKOUT_TIME = 65;
    public static final int OP_TYPE_GET_PW_HISTORY_COUNT = 66;
    public static final int OP_TYPE_GET_PW_IS_EXPIRED = 67;
    public static final int OP_TYPE_GET_AVAILABLE_SASL_MECHANISMS = 68;
    public static final int OP_TYPE_GET_AVAILABLE_OTP_DELIVERY_MECHANISMS = 69;
    public static final int OP_TYPE_HAS_TOTP_SHARED_SECRET = 70;
    public static final int OP_TYPE_GET_REGISTERED_YUBIKEY_PUBLIC_IDS = 71;
    public static final int OP_TYPE_ADD_REGISTERED_YUBIKEY_PUBLIC_ID = 72;
    public static final int OP_TYPE_REMOVE_REGISTERED_YUBIKEY_PUBLIC_ID = 73;
    public static final int OP_TYPE_SET_REGISTERED_YUBIKEY_PUBLIC_IDS = 74;
    public static final int OP_TYPE_CLEAR_REGISTERED_YUBIKEY_PUBLIC_IDS = 75;
    public static final int OP_TYPE_ADD_TOTP_SHARED_SECRET = 76;
    public static final int OP_TYPE_REMOVE_TOTP_SHARED_SECRET = 77;
    public static final int OP_TYPE_SET_TOTP_SHARED_SECRETS = 78;
    public static final int OP_TYPE_CLEAR_TOTP_SHARED_SECRETS = 79;
    public static final int OP_TYPE_HAS_REGISTERED_YUBIKEY_PUBLIC_ID = 80;
    public static final int OP_TYPE_HAS_STATIC_PASSWORD = 81;
    public static final int OP_TYPE_GET_LAST_BIND_PASSWORD_VALIDATION_TIME = 82;
    public static final int OP_TYPE_GET_SECONDS_SINCE_LAST_BIND_PASSWORD_VALIDATION = 83;
    public static final int OP_TYPE_SET_LAST_BIND_PASSWORD_VALIDATION_TIME = 84;
    public static final int OP_TYPE_CLEAR_LAST_BIND_PASSWORD_VALIDATION_TIME = 85;
    public static final int OP_TYPE_GET_ACCOUNT_IS_VALIDATION_LOCKED = 86;
    public static final int OP_TYPE_SET_ACCOUNT_IS_VALIDATION_LOCKED = 87;
    public static final int OP_TYPE_GET_RECENT_LOGIN_HISTORY = 88;
    public static final int OP_TYPE_CLEAR_RECENT_LOGIN_HISTORY = 89;
    @NotNull
    private static final ASN1OctetString[] NO_VALUES = new ASN1OctetString[0];
    private static final long serialVersionUID = -7711496660183073026L;
    @NotNull
    private final ASN1OctetString[] values;
    private final int opType;

    public PasswordPolicyStateOperation(int opType) {
        this(opType, NO_VALUES);
    }

    public PasswordPolicyStateOperation(int opType, @Nullable ASN1OctetString[] values) {
        this.opType = opType;
        this.values = values == null ? NO_VALUES : values;
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordPolicyDNOperation() {
        return new PasswordPolicyStateOperation(0);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountDisabledStateOperation() {
        return new PasswordPolicyStateOperation(1);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetAccountDisabledStateOperation(boolean isDisabled) {
        ASN1OctetString[] values = new ASN1OctetString[]{new ASN1OctetString(String.valueOf(isDisabled))};
        return new PasswordPolicyStateOperation(2, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearAccountDisabledStateOperation() {
        return new PasswordPolicyStateOperation(3);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountActivationTimeOperation() {
        return new PasswordPolicyStateOperation(45);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetAccountActivationTimeOperation(@Nullable Date expirationTime) {
        return new PasswordPolicyStateOperation(46, PasswordPolicyStateOperation.createValues(expirationTime));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearAccountActivationTimeOperation() {
        return new PasswordPolicyStateOperation(47);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsUntilAccountActivationOperation() {
        return new PasswordPolicyStateOperation(48);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountExpirationTimeOperation() {
        return new PasswordPolicyStateOperation(4);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetAccountExpirationTimeOperation(@Nullable Date expirationTime) {
        return new PasswordPolicyStateOperation(5, PasswordPolicyStateOperation.createValues(expirationTime));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearAccountExpirationTimeOperation() {
        return new PasswordPolicyStateOperation(6);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsUntilAccountExpirationOperation() {
        return new PasswordPolicyStateOperation(7);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordChangedTimeOperation() {
        return new PasswordPolicyStateOperation(8);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetPasswordChangedTimeOperation(@Nullable Date passwordChangedTime) {
        return new PasswordPolicyStateOperation(9, PasswordPolicyStateOperation.createValues(passwordChangedTime));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearPasswordChangedTimeOperation() {
        return new PasswordPolicyStateOperation(10);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordExpirationWarnedTimeOperation() {
        return new PasswordPolicyStateOperation(11);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetPasswordExpirationWarnedTimeOperation(@Nullable Date passwordExpirationWarnedTime) {
        return new PasswordPolicyStateOperation(12, PasswordPolicyStateOperation.createValues(passwordExpirationWarnedTime));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearPasswordExpirationWarnedTimeOperation() {
        return new PasswordPolicyStateOperation(13);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsUntilPasswordExpirationOperation() {
        return new PasswordPolicyStateOperation(14);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsUntilPasswordExpirationWarningOperation() {
        return new PasswordPolicyStateOperation(15);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAuthenticationFailureTimesOperation() {
        return new PasswordPolicyStateOperation(16);
    }

    @NotNull
    public static PasswordPolicyStateOperation createAddAuthenticationFailureTimeOperation() {
        return PasswordPolicyStateOperation.createAddAuthenticationFailureTimeOperation(null);
    }

    @NotNull
    public static PasswordPolicyStateOperation createAddAuthenticationFailureTimeOperation(@Nullable Date[] authFailureTimes) {
        return new PasswordPolicyStateOperation(17, PasswordPolicyStateOperation.createValues(authFailureTimes));
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetAuthenticationFailureTimesOperation(@Nullable Date[] authFailureTimes) {
        return new PasswordPolicyStateOperation(18, PasswordPolicyStateOperation.createValues(authFailureTimes));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearAuthenticationFailureTimesOperation() {
        return new PasswordPolicyStateOperation(19);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsUntilAuthenticationFailureUnlockOperation() {
        return new PasswordPolicyStateOperation(20);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetRemainingAuthenticationFailureCountOperation() {
        return new PasswordPolicyStateOperation(21);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetLastLoginTimeOperation() {
        return new PasswordPolicyStateOperation(22);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetLastLoginTimeOperation(@Nullable Date lastLoginTime) {
        return new PasswordPolicyStateOperation(23, PasswordPolicyStateOperation.createValues(lastLoginTime));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearLastLoginTimeOperation() {
        return new PasswordPolicyStateOperation(24);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetLastLoginIPAddressOperation() {
        return new PasswordPolicyStateOperation(49);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetLastLoginIPAddressOperation(@NotNull String lastLoginIPAddress) {
        ASN1OctetString[] values = new ASN1OctetString[]{new ASN1OctetString(lastLoginIPAddress)};
        return new PasswordPolicyStateOperation(50, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearLastLoginIPAddressOperation() {
        return new PasswordPolicyStateOperation(51);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsUntilIdleLockoutOperation() {
        return new PasswordPolicyStateOperation(25);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordResetStateOperation() {
        return new PasswordPolicyStateOperation(26);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetPasswordResetStateOperation(boolean isReset) {
        ASN1OctetString[] values = new ASN1OctetString[]{new ASN1OctetString(String.valueOf(isReset))};
        return new PasswordPolicyStateOperation(27, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearPasswordResetStateOperation() {
        return new PasswordPolicyStateOperation(28);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsUntilPasswordResetLockoutOperation() {
        return new PasswordPolicyStateOperation(29);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetGraceLoginUseTimesOperation() {
        return new PasswordPolicyStateOperation(30);
    }

    @NotNull
    public static PasswordPolicyStateOperation createAddGraceLoginUseTimeOperation() {
        return PasswordPolicyStateOperation.createAddGraceLoginUseTimeOperation(null);
    }

    @NotNull
    public static PasswordPolicyStateOperation createAddGraceLoginUseTimeOperation(@Nullable Date[] graceLoginUseTimes) {
        return new PasswordPolicyStateOperation(31, PasswordPolicyStateOperation.createValues(graceLoginUseTimes));
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetGraceLoginUseTimesOperation(@Nullable Date[] graceLoginUseTimes) {
        return new PasswordPolicyStateOperation(32, PasswordPolicyStateOperation.createValues(graceLoginUseTimes));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearGraceLoginUseTimesOperation() {
        return new PasswordPolicyStateOperation(33);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetRemainingGraceLoginCountOperation() {
        return new PasswordPolicyStateOperation(34);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordChangedByRequiredTimeOperation() {
        return new PasswordPolicyStateOperation(35);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetPasswordChangedByRequiredTimeOperation() {
        return PasswordPolicyStateOperation.createSetPasswordChangedByRequiredTimeOperation(null);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetPasswordChangedByRequiredTimeOperation(@Nullable Date requiredTime) {
        return new PasswordPolicyStateOperation(36, PasswordPolicyStateOperation.createValues(requiredTime));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearPasswordChangedByRequiredTimeOperation() {
        return new PasswordPolicyStateOperation(37);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsUntilRequiredChangeTimeOperation() {
        return new PasswordPolicyStateOperation(38);
    }

    @Deprecated
    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordHistoryOperation() {
        return new PasswordPolicyStateOperation(39);
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearPasswordHistoryOperation() {
        return new PasswordPolicyStateOperation(40);
    }

    @NotNull
    public static PasswordPolicyStateOperation createHasRetiredPasswordOperation() {
        return new PasswordPolicyStateOperation(41);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordRetiredTimeOperation() {
        return new PasswordPolicyStateOperation(42);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetRetiredPasswordExpirationTimeOperation() {
        return new PasswordPolicyStateOperation(43);
    }

    @NotNull
    public static PasswordPolicyStateOperation createPurgeRetiredPasswordOperation() {
        return new PasswordPolicyStateOperation(44);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountUsabilityNoticesOperation() {
        return new PasswordPolicyStateOperation(52);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountUsabilityWarningsOperation() {
        return new PasswordPolicyStateOperation(53);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountUsabilityErrorsOperation() {
        return new PasswordPolicyStateOperation(54);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountIsUsableOperation() {
        return new PasswordPolicyStateOperation(55);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountIsNotYetActiveOperation() {
        return new PasswordPolicyStateOperation(56);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountIsExpiredOperation() {
        return new PasswordPolicyStateOperation(57);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordExpirationTimeOperation() {
        return new PasswordPolicyStateOperation(58);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountIsFailureLockedOperation() {
        return new PasswordPolicyStateOperation(59);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetAccountIsFailureLockedOperation(boolean isFailureLocked) {
        ASN1OctetString[] values = new ASN1OctetString[]{new ASN1OctetString(String.valueOf(isFailureLocked))};
        return new PasswordPolicyStateOperation(60, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetFailureLockoutTimeOperation() {
        return new PasswordPolicyStateOperation(61);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountIsIdleLockedOperation() {
        return new PasswordPolicyStateOperation(62);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetIdleLockoutTimeOperation() {
        return new PasswordPolicyStateOperation(63);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountIsResetLockedOperation() {
        return new PasswordPolicyStateOperation(64);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetResetLockoutTimeOperation() {
        return new PasswordPolicyStateOperation(65);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordHistoryCountOperation() {
        return new PasswordPolicyStateOperation(66);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetPasswordIsExpiredOperation() {
        return new PasswordPolicyStateOperation(67);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAvailableSASLMechanismsOperation() {
        return new PasswordPolicyStateOperation(68);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAvailableOTPDeliveryMechanismsOperation() {
        return new PasswordPolicyStateOperation(69);
    }

    @Deprecated
    @NotNull
    public static PasswordPolicyStateOperation createHasTOTPSharedSecret() {
        return new PasswordPolicyStateOperation(70);
    }

    @NotNull
    public static PasswordPolicyStateOperation createHasTOTPSharedSecretOperation() {
        return new PasswordPolicyStateOperation(70);
    }

    @NotNull
    public static PasswordPolicyStateOperation createAddTOTPSharedSecretOperation(String ... totpSharedSecrets) {
        ASN1OctetString[] values = new ASN1OctetString[totpSharedSecrets.length];
        for (int i = 0; i < totpSharedSecrets.length; ++i) {
            values[i] = new ASN1OctetString(totpSharedSecrets[i]);
        }
        return new PasswordPolicyStateOperation(76, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createRemoveTOTPSharedSecretOperation(String ... totpSharedSecrets) {
        ASN1OctetString[] values = new ASN1OctetString[totpSharedSecrets.length];
        for (int i = 0; i < totpSharedSecrets.length; ++i) {
            values[i] = new ASN1OctetString(totpSharedSecrets[i]);
        }
        return new PasswordPolicyStateOperation(77, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetTOTPSharedSecretsOperation(String ... totpSharedSecrets) {
        ASN1OctetString[] values = new ASN1OctetString[totpSharedSecrets.length];
        for (int i = 0; i < totpSharedSecrets.length; ++i) {
            values[i] = new ASN1OctetString(totpSharedSecrets[i]);
        }
        return new PasswordPolicyStateOperation(78, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearTOTPSharedSecretsOperation() {
        return new PasswordPolicyStateOperation(79);
    }

    @NotNull
    public static PasswordPolicyStateOperation createHasYubiKeyPublicIDOperation() {
        return new PasswordPolicyStateOperation(80);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetRegisteredYubiKeyPublicIDsOperation() {
        return new PasswordPolicyStateOperation(71);
    }

    @NotNull
    public static PasswordPolicyStateOperation createAddRegisteredYubiKeyPublicIDOperation(String ... publicIDs) {
        ASN1OctetString[] values = new ASN1OctetString[publicIDs.length];
        for (int i = 0; i < publicIDs.length; ++i) {
            values[i] = new ASN1OctetString(publicIDs[i]);
        }
        return new PasswordPolicyStateOperation(72, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createRemoveRegisteredYubiKeyPublicIDOperation(String ... publicIDs) {
        ASN1OctetString[] values = new ASN1OctetString[publicIDs.length];
        for (int i = 0; i < publicIDs.length; ++i) {
            values[i] = new ASN1OctetString(publicIDs[i]);
        }
        return new PasswordPolicyStateOperation(73, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetRegisteredYubiKeyPublicIDsOperation(String ... publicIDs) {
        ASN1OctetString[] values = new ASN1OctetString[publicIDs.length];
        for (int i = 0; i < publicIDs.length; ++i) {
            values[i] = new ASN1OctetString(publicIDs[i]);
        }
        return new PasswordPolicyStateOperation(74, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearRegisteredYubiKeyPublicIDsOperation() {
        return new PasswordPolicyStateOperation(75);
    }

    @NotNull
    public static PasswordPolicyStateOperation createHasStaticPasswordOperation() {
        return new PasswordPolicyStateOperation(81);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetLastBindPasswordValidationTimeOperation() {
        return new PasswordPolicyStateOperation(82);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetSecondsSinceLastBindPasswordValidationOperation() {
        return new PasswordPolicyStateOperation(83);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetLastBindPasswordValidationTimeOperation(@Nullable Date validationTime) {
        return new PasswordPolicyStateOperation(84, PasswordPolicyStateOperation.createValues(validationTime));
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearLastBindPasswordValidationTimeOperation() {
        return new PasswordPolicyStateOperation(85);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetAccountIsValidationLockedOperation() {
        return new PasswordPolicyStateOperation(86);
    }

    @NotNull
    public static PasswordPolicyStateOperation createSetAccountIsValidationLockedOperation(boolean isValidationLocked) {
        ASN1OctetString[] values = new ASN1OctetString[]{new ASN1OctetString(String.valueOf(isValidationLocked))};
        return new PasswordPolicyStateOperation(87, values);
    }

    @NotNull
    public static PasswordPolicyStateOperation createGetRecentLoginHistoryOperation() {
        return new PasswordPolicyStateOperation(88);
    }

    @NotNull
    public static PasswordPolicyStateOperation createClearRecentLoginHistoryOperation() {
        return new PasswordPolicyStateOperation(89);
    }

    public int getOperationType() {
        return this.opType;
    }

    @NotNull
    public ASN1OctetString[] getRawValues() {
        return this.values;
    }

    @Nullable
    public String getStringValue() {
        if (this.values.length == 0) {
            return null;
        }
        return this.values[0].stringValue();
    }

    @NotNull
    public String[] getStringValues() {
        String[] stringValues = new String[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            stringValues[i] = this.values[i].stringValue();
        }
        return stringValues;
    }

    public boolean getBooleanValue() throws IllegalStateException {
        if (this.values.length != 1) {
            throw new IllegalStateException(ExtOpMessages.ERR_PWP_STATE_INVALID_BOOLEAN_VALUE_COUNT.get(this.values.length));
        }
        String valueString = StaticUtils.toLowerCase(this.values[0].stringValue());
        if (valueString.equals("true")) {
            return true;
        }
        if (valueString.equals("false")) {
            return false;
        }
        throw new IllegalStateException(ExtOpMessages.ERR_PWP_STATE_VALUE_NOT_BOOLEAN.get(this.values[0].stringValue()));
    }

    public int getIntValue() throws IllegalStateException, NumberFormatException {
        if (this.values.length == 0) {
            throw new IllegalStateException(ExtOpMessages.ERR_PWP_STATE_NO_VALUES.get());
        }
        return Integer.parseInt(this.values[0].stringValue());
    }

    @Nullable
    public Date getGeneralizedTimeValue() throws ParseException {
        if (this.values.length == 0) {
            return null;
        }
        return StaticUtils.decodeGeneralizedTime(this.values[0].stringValue());
    }

    @NotNull
    public Date[] getGeneralizedTimeValues() throws ParseException {
        Date[] dateValues = new Date[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            dateValues[i] = StaticUtils.decodeGeneralizedTime(this.values[i].stringValue());
        }
        return dateValues;
    }

    @NotNull
    private static ASN1OctetString[] createValues(Date ... dates) {
        if (dates == null || dates.length == 0) {
            return NO_VALUES;
        }
        ArrayList<ASN1OctetString> valueList = new ArrayList<ASN1OctetString>(dates.length);
        for (Date d : dates) {
            if (d == null) continue;
            valueList.add(new ASN1OctetString(StaticUtils.encodeGeneralizedTime(d)));
        }
        return valueList.toArray(NO_VALUES);
    }

    @NotNull
    public ASN1Element encode() {
        ASN1Element[] elements = this.values.length > 0 ? new ASN1Element[]{new ASN1Enumerated(this.opType), new ASN1Sequence(this.values)} : new ASN1Element[]{new ASN1Enumerated(this.opType)};
        return new ASN1Sequence(elements);
    }

    @NotNull
    public static PasswordPolicyStateOperation decode(@NotNull ASN1Element element) throws LDAPException {
        ASN1OctetString[] values;
        int opType;
        ASN1Element[] elements;
        try {
            elements = ASN1Sequence.decodeAsSequence(element).elements();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_ELEMENT_NOT_SEQUENCE.get(e), e);
        }
        if (elements.length < 1 || elements.length > 2) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_INVALID_ELEMENT_COUNT.get(elements.length));
        }
        try {
            opType = ASN1Enumerated.decodeAsEnumerated(elements[0]).intValue();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_OP_TYPE_NOT_INTEGER.get(e), e);
        }
        if (elements.length == 2) {
            try {
                ASN1Element[] valueElements = ASN1Sequence.decodeAsSequence(elements[1]).elements();
                values = new ASN1OctetString[valueElements.length];
                for (int i = 0; i < valueElements.length; ++i) {
                    values[i] = ASN1OctetString.decodeAsOctetString(valueElements[i]);
                }
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_CANNOT_DECODE_VALUES.get(e), e);
            }
        } else {
            values = NO_VALUES;
        }
        return new PasswordPolicyStateOperation(opType, values);
    }

    @NotNull
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PasswordPolicyStateOperation(opType=");
        buffer.append(this.opType);
        if (this.values.length > 0) {
            buffer.append(", values={");
            for (int i = 0; i < this.values.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append('\'');
                buffer.append(this.values[i].stringValue());
                buffer.append('\'');
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

