/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.querybuilder.term;

import com.datastax.oss.driver.api.querybuilder.term.Term;
import com.datastax.oss.driver.internal.querybuilder.CqlHelper;
import edu.umd.cs.findbugs.annotations.NonNull;
import net.jcip.annotations.Immutable;

@Immutable
public class TupleTerm
implements Term {
    private final Iterable<? extends Term> components;

    public TupleTerm(@NonNull Iterable<? extends Term> components) {
        this.components = components;
    }

    @Override
    public void appendTo(@NonNull StringBuilder builder) {
        CqlHelper.append(this.components, builder, "(", ",", ")");
    }

    @Override
    public boolean isIdempotent() {
        for (Term term : this.components) {
            if (term.isIdempotent()) continue;
            return false;
        }
        return true;
    }

    @NonNull
    public Iterable<? extends Term> getComponents() {
        return this.components;
    }
}

