/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.context;

import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.shared.common.error.ShutdownException;
import org.apache.derby.shared.common.error.StandardException;

final class SystemContext
extends ContextImpl {
    SystemContext(ContextManager contextManager) {
        super(contextManager, "SystemContext");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanupOnError(Throwable throwable) {
        boolean bl = false;
        if (throwable instanceof StandardException) {
            StandardException standardException = (StandardException)throwable;
            int n = standardException.getSeverity();
            if (n < 40000) {
                return;
            }
            this.popMe();
            if (n >= 50000) {
                bl = true;
            }
        } else if (throwable instanceof ShutdownException || throwable instanceof ThreadDeath) {
            // empty if block
        }
        if (!bl) {
            this.getContextManager().owningCsf.removeContext(this.getContextManager());
            return;
        }
        try {
            System.err.println("Shutting down due to severe error.");
            Monitor.getStream().printlnWithHeader("Shutting down due to severe error." + throwable.getMessage());
        }
        finally {
            SystemContext.getMonitor().shutdown();
        }
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }
}

