/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler.render;

import com.github.benmanes.caffeine.cache.Cache;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.protocol.jms.sampler.render.FileKey;
import org.apache.jmeter.protocol.jms.sampler.render.MessageRenderer;
import org.apache.jorphan.io.TextFile;

class TextMessageRenderer
implements MessageRenderer<String> {
    TextMessageRenderer() {
    }

    @Override
    public String getValueFromText(String text) {
        return text;
    }

    @Override
    public String getValueFromFile(String filename, String encoding, boolean hasVariable, Cache<Object, Object> cache) {
        String text = (String)cache.get((Object)new FileKey(filename, encoding), key -> this.getContent((FileKey)key));
        if (hasVariable) {
            text = new CompoundVariable(text).execute();
        }
        return text;
    }

    String getContent(FileKey key) {
        return new TextFile(key.getFilename(), key.getEncoding()).getText();
    }
}

