/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.packages.command;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.karaf.packages.core.PackageService;
import org.apache.karaf.packages.core.PackageVersion;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.table.Col;
import org.apache.karaf.shell.table.ShellTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

@Command(scope="package", name="exports", description="Lists exported packages and the bundles that export them")
public class Exports
extends OsgiCommandSupport {
    private PackageService packageService;
    @Option(name="-d", description="Only show packages that are exported by more than one bundle", required=false, multiValued=false)
    private boolean onlyDuplicates;
    @Option(name="--no-format", description="Disable table rendered output", required=false, multiValued=false)
    boolean noFormat;

    public Exports(PackageService packageService) {
        this.packageService = packageService;
    }

    protected Object doExecute() throws Exception {
        if (this.onlyDuplicates) {
            this.checkDuplicateExports();
        } else {
            this.showExports();
        }
        return null;
    }

    private void showExports() {
        SortedMap exports = this.packageService.getExports();
        ShellTable table = new ShellTable();
        table.column(new Col("Package Name"));
        table.column(new Col("Version"));
        table.column(new Col("ID"));
        table.column(new Col("Bundle Name"));
        for (String key : exports.keySet()) {
            PackageVersion pVer = (PackageVersion)exports.get(key);
            for (Bundle bundle : pVer.getBundles()) {
                table.addRow().addContent(new Object[]{pVer.getPackageName(), pVer.getVersion().toString(), bundle.getBundleId(), bundle.getSymbolicName()});
            }
        }
        table.print(System.out, !this.noFormat);
    }

    private void checkDuplicateExports() {
        Bundle[] bundles = this.bundleContext.getBundles();
        SortedMap<String, PackageVersion> packageVersionMap = this.getDuplicatePackages(bundles);
        ShellTable table = new ShellTable();
        table.column(new Col("Package Name"));
        table.column(new Col("Version"));
        table.column(new Col("Exporting bundles (ID)"));
        for (String key : packageVersionMap.keySet()) {
            PackageVersion pVer = (PackageVersion)packageVersionMap.get(key);
            if (pVer.getBundles().size() <= 1) continue;
            String pBundles = this.getBundlesSt(pVer.getBundles());
            table.addRow().addContent(new Object[]{pVer.getPackageName(), pVer.getVersion().toString(), pBundles});
        }
        table.print(System.out, !this.noFormat);
    }

    private String getBundlesSt(Set<Bundle> bundles) {
        StringBuilder st = new StringBuilder();
        for (Bundle bundle : bundles) {
            st.append(bundle.getBundleId() + " ");
        }
        return st.toString();
    }

    private SortedMap<String, PackageVersion> getDuplicatePackages(Bundle[] bundles) {
        TreeMap<String, PackageVersion> packageVersionMap = new TreeMap<String, PackageVersion>();
        for (Bundle bundle : bundles) {
            BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
            if (rev == null) continue;
            List caps = rev.getDeclaredCapabilities("osgi.wiring.package");
            for (BundleCapability cap : caps) {
                Map attr = cap.getAttributes();
                String packageName = (String)attr.get("osgi.wiring.package");
                Version version = (Version)attr.get("version");
                String key = packageName + ":" + version.toString();
                PackageVersion pVer = (PackageVersion)packageVersionMap.get(key);
                if (pVer == null) {
                    pVer = new PackageVersion(packageName, version);
                    packageVersionMap.put(key, pVer);
                }
                pVer.addBundle(bundle);
            }
        }
        return packageVersionMap;
    }
}

