/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.channel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.common.channel.ChannelPipedInputStream;
import org.apache.sshd.common.channel.ChannelPipedOutputStream;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.util.LoggingFilterOutputStream;
import org.apache.sshd.server.channel.ChannelDataReceiver;
import org.apache.sshd.server.channel.ChannelSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataReceiver
implements ChannelDataReceiver {
    private InputStream in;
    private OutputStream out;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public PipeDataReceiver(Window localWindow) {
        ChannelPipedInputStream in = new ChannelPipedInputStream(localWindow);
        this.in = in;
        this.out = new ChannelPipedOutputStream(in);
        if (this.log != null && this.log.isTraceEnabled()) {
            this.out = new LoggingFilterOutputStream(this.out, "IN: ", this.log);
        }
    }

    public InputStream getIn() {
        return this.in;
    }

    public void close() throws IOException {
        this.out.close();
    }

    public int data(ChannelSession channel, byte[] buf, int start, int len) throws IOException {
        this.out.write(buf, start, len);
        return 0;
    }
}

