/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.support.ansi.SimpleAnsi;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="classes", description="Displays a list of classes/resources contained in the bundle")
@Service
public class Classes
extends BundlesCommand {
    @Option(name="-a", aliases={"--display-all-files"}, description="List all classes and files in the bundle", required=false, multiValued=false)
    boolean displayAllFiles;

    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            List<String> exports = this.getExports(bundle);
            Collection resources = this.displayAllFiles ? wiring.listResources("/", null, 1) : wiring.listResources("/", "*class", 1);
            Collection localResources = this.displayAllFiles ? wiring.listResources("/", null, 3) : wiring.listResources("/", "/*.class", 3);
            for (String resource : resources) {
                StringBuilder stringBuilder = new StringBuilder();
                boolean localResource = localResources.contains(resource);
                if (localResource) {
                    stringBuilder.append(SimpleAnsi.INTENSITY_BOLD);
                }
                if (this.ids == null || this.ids.size() != 1) {
                    stringBuilder.append(bundle.getBundleId()).append(" | ");
                }
                stringBuilder.append(resource).append(" | ");
                stringBuilder.append("exported: ").append(this.isExported(resource, exports));
                if (localResource) {
                    stringBuilder.append(SimpleAnsi.INTENSITY_NORMAL);
                }
                System.out.println(stringBuilder.toString());
            }
        } else {
            System.out.println("Bundle " + bundle.getBundleId() + " is not resolved.");
        }
    }

    private boolean isExported(String className, List<String> exports) {
        String packageName;
        boolean exported = false;
        int lastSlashIdx = className.lastIndexOf("/");
        if (lastSlashIdx > -1 && exports.contains(packageName = className.substring(0, lastSlashIdx).replaceAll("/", "."))) {
            exported = true;
        }
        return exported;
    }

    private List<String> getExports(Bundle bundle) {
        ArrayList<String> exports = new ArrayList<String>();
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        List caps = rev.getDeclaredCapabilities("osgi.wiring.package");
        for (BundleCapability cap : caps) {
            Map attr = cap.getAttributes();
            String packageName = (String)attr.get("osgi.wiring.package");
            exports.add(packageName);
        }
        return exports;
    }
}

