/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.unmodifiable.Lists;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.osgi.util.promise.PromiseFactory;

public class ExecutorGroup {
    private final ThreadPoolExecutor executor;
    private final ScheduledThreadPoolExecutor scheduledExecutor;
    private final ScheduledThreadPoolExecutor promiseScheduledExecutor;
    private final PromiseFactory promiseFactory;

    public ExecutorGroup() {
        this(2, Integer.getInteger("bnd.executor.maximumPoolSize", 256));
    }

    public ExecutorGroup(int corePoolSize, int maximumPoolSize) {
        ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
        RejectedExecution rejectedExecutionHandler = new RejectedExecution();
        this.executor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ExecutorThreadFactory(defaultThreadFactory, "Bnd-Executor,"), rejectedExecutionHandler);
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(corePoolSize, new ExecutorThreadFactory(defaultThreadFactory, "Bnd-ScheduledExecutor,"), rejectedExecutionHandler);
        this.promiseScheduledExecutor = new ScheduledThreadPoolExecutor(corePoolSize, new ExecutorThreadFactory(defaultThreadFactory, "Bnd-PromiseScheduledExecutor,"), rejectedExecutionHandler);
        this.promiseFactory = new PromiseFactory((Executor)this.executor, (ScheduledExecutorService)this.promiseScheduledExecutor);
        List<ThreadPoolExecutor> executors = Lists.of(this.scheduledExecutor, this.promiseScheduledExecutor, this.executor);
        AtomicBoolean shutdownHookInstalled = new AtomicBoolean();
        Function<ThreadPoolExecutor, ThreadFactory> shutdownHookInstaller = threadPoolExecutor -> {
            ThreadFactory threadFactory = threadPoolExecutor.getThreadFactory();
            return r -> {
                threadPoolExecutor.setThreadFactory(threadFactory);
                if (shutdownHookInstalled.compareAndSet(false, true)) {
                    Thread shutdownThread = new Thread(() -> executors.forEach(executor -> {
                        executor.shutdown();
                        try {
                            executor.awaitTermination(20L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }), "Bnd-ExecutorShutdownHook");
                    try {
                        Runtime.getRuntime().addShutdownHook(shutdownThread);
                    }
                    catch (IllegalStateException e) {
                        executors.forEach(ThreadPoolExecutor::shutdown);
                    }
                }
                return threadFactory.newThread(r);
            };
        };
        executors.forEach(executor -> {
            executor.setThreadFactory((ThreadFactory)shutdownHookInstaller.apply((ThreadPoolExecutor)executor));
            if (executor instanceof ScheduledThreadPoolExecutor) {
                ScheduledThreadPoolExecutor scheduledExecutor = (ScheduledThreadPoolExecutor)executor;
                scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
                scheduledExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            }
        });
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }

    public PromiseFactory getPromiseFactory() {
        return this.promiseFactory;
    }

    static final class RejectedExecution
    implements RejectedExecutionHandler {
        RejectedExecution() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                return;
            }
            try {
                runnable.run();
            }
            catch (Throwable t) {
                try {
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    static final class ExecutorThreadFactory
    implements ThreadFactory {
        private final ThreadFactory delegate;
        private final String prefix;

        ExecutorThreadFactory(ThreadFactory delegate, String prefix) {
            this.delegate = delegate;
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.delegate.newThread(r);
            t.setName(this.prefix.concat(t.getName()));
            t.setDaemon(true);
            return t;
        }
    }
}

