/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jline.builtins.Commands;
import org.jline.builtins.Options;
import org.jline.keymap.BindingReader;
import org.jline.keymap.KeyMap;
import org.jline.reader.ConfigurationPath;
import org.jline.reader.Editor;
import org.jline.terminal.Attributes;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.jline.utils.AttributedStyle;
import org.jline.utils.Display;
import org.jline.utils.InfoCmp;
import org.mozilla.universalchardet.UniversalDetector;

public class Nano
implements Editor {
    protected final Terminal terminal;
    protected final Display display;
    protected final BindingReader bindingReader;
    protected final Size size;
    protected final Path root;
    protected final int vsusp;
    protected KeyMap<Operation> keys;
    public String title = "JLine Nano 3.0.0";
    public boolean printLineNumbers = false;
    public boolean wrapping = false;
    public boolean smoothScrolling = true;
    public boolean mouseSupport = false;
    public boolean oneMoreLine = true;
    public boolean constantCursor = false;
    public boolean quickBlank = false;
    public int tabs = 4;
    public String brackets = "\"\u2019)>]}";
    public String matchBrackets = "(<[{)>]}";
    public String punct = "!.?";
    public String quoteStr = "^([ \\t]*[#:>\\|}])+";
    private boolean restricted = false;
    private String syntaxName;
    private boolean writeBackup = false;
    private boolean atBlanks = false;
    private boolean view = false;
    private boolean cut2end = false;
    private boolean tempFile = false;
    private String historyLog = null;
    private boolean tabsToSpaces = false;
    private boolean autoIndent = false;
    protected final List<Buffer> buffers = new ArrayList<Buffer>();
    protected int bufferIndex;
    protected Buffer buffer;
    protected String message;
    protected String errorMessage = null;
    protected int nbBindings = 0;
    protected LinkedHashMap<String, String> shortcuts;
    protected String editMessage;
    protected final StringBuilder editBuffer = new StringBuilder();
    protected boolean searchCaseSensitive;
    protected boolean searchRegexp;
    protected boolean searchBackwards;
    protected String searchTerm;
    protected int matchedLength = -1;
    protected PatternHistory patternHistory = new PatternHistory(null);
    protected WriteMode writeMode = WriteMode.WRITE;
    protected List<String> cutbuffer = new ArrayList<String>();
    protected boolean mark = false;
    protected boolean highlight = true;
    private List<Path> syntaxFiles = new ArrayList<Path>();
    private boolean searchToReplace = false;
    protected boolean readNewBuffer = true;

    public static String[] usage() {
        String[] usage = new String[]{"nano -  edit files", "Usage: nano [OPTIONS] [FILES]", "  -? --help                    Show help", "  -B --backup                  When saving a file, back up the previous version of it, using the current filename", "                               suffixed with a tilde (~).", "  -I --ignorercfiles           Don't look at the system's nanorc nor at the user's nanorc.", "  -Q --quotestr=regex          Set the regular expression for matching the quoting part of a line.", "  -T --tabsize=number          Set the size (width) of a tab to number columns.", "  -U --quickblank              Do quick status-bar blanking: status-bar messages will disappear after 1 keystroke.", "  -c --constantshow            Constantly show the cursor position on the status bar.", "  -e --emptyline               Do not use the line below the title bar, leaving it entirely blank.", "  -j --jumpyscrolling          Scroll the buffer contents per half-screen instead of per line.", "  -l --linenumbers             Display line numbers to the left of the text area.", "  -m --mouse                   Enable mouse support, if available for your system.", "  -$ --softwrap                Enable 'soft wrapping'. ", "  -a --atblanks                Wrap lines at whitespace instead of always at the edge of the screen.", "  -R --restricted              Restricted mode: don't allow suspending; don't allow a file to be appended to,", "                               prepended to, or saved under a different name if it already has one;", "                               and don't use backup files.", "  -Y --syntax=name             The name of the syntax highlighting to use.", "  -z --suspend                 Enable the ability to suspend nano using the system's suspend keystroke (usually ^Z).", "  -v --view                    Don't allow the contents of the file to be altered: read-only mode.", "  -k --cutfromcursor           Make the 'Cut Text' command cut from the current cursor position to the end of the line", "  -t --tempfile                Save a changed buffer without prompting (when exiting with ^X).", "  -H --historylog=name         Log search strings to file, so they can be retrieved in later sessions", "  -E --tabstospaces            Convert typed tabs to spaces.", "  -i --autoindent              Indent new lines to the previous line's indentation."};
        return usage;
    }

    public Nano(Terminal terminal, File root) {
        this(terminal, root.toPath());
    }

    public Nano(Terminal terminal, Path root) {
        this(terminal, root, null);
    }

    public Nano(Terminal terminal, Path root, Options opts) {
        this(terminal, root, opts, null);
    }

    public Nano(Terminal terminal, Path root, Options opts, ConfigurationPath configPath) {
        boolean ignorercfiles;
        this.terminal = terminal;
        this.root = root;
        this.display = new Display(terminal, true);
        this.bindingReader = new BindingReader(terminal.reader());
        this.size = new Size();
        Attributes attrs = terminal.getAttributes();
        this.vsusp = attrs.getControlChar(Attributes.ControlChar.VSUSP);
        if (this.vsusp > 0) {
            attrs.setControlChar(Attributes.ControlChar.VSUSP, 0);
            terminal.setAttributes(attrs);
        }
        Path nanorc = configPath != null ? configPath.getConfig("jnanorc") : null;
        boolean bl = ignorercfiles = opts != null && opts.isSet("ignorercfiles");
        if (nanorc != null && !ignorercfiles) {
            try {
                this.parseConfig(nanorc);
            }
            catch (IOException e) {
                this.errorMessage = "Encountered error while reading config file: " + nanorc;
            }
        } else if (new File("/usr/share/nano").exists() && !ignorercfiles) {
            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:/usr/share/nano/*.nanorc");
            try {
                Files.find(Paths.get("/usr/share/nano", new String[0]), Integer.MAX_VALUE, (path, f) -> pathMatcher.matches((Path)path), new FileVisitOption[0]).forEach(p -> this.syntaxFiles.add((Path)p));
            }
            catch (IOException e) {
                this.errorMessage = "Encountered error while reading nanorc files";
            }
        }
        if (opts != null) {
            this.restricted = opts.isSet("restricted");
            String string = this.syntaxName = opts.isSet("syntax") ? opts.get("syntax") : null;
            if (opts.isSet("backup")) {
                this.writeBackup = true;
            }
            if (opts.isSet("quotestr")) {
                this.quoteStr = opts.get("quotestr");
            }
            if (opts.isSet("tabsize")) {
                this.tabs = opts.getNumber("tabsize");
            }
            if (opts.isSet("quickblank")) {
                this.quickBlank = true;
            }
            if (opts.isSet("constantshow")) {
                this.constantCursor = true;
            }
            if (opts.isSet("emptyline")) {
                this.oneMoreLine = false;
            }
            if (opts.isSet("jumpyscrolling")) {
                this.smoothScrolling = false;
            }
            if (opts.isSet("linenumbers")) {
                this.printLineNumbers = true;
            }
            if (opts.isSet("mouse")) {
                this.mouseSupport = true;
            }
            if (opts.isSet("softwrap")) {
                this.wrapping = true;
            }
            if (opts.isSet("atblanks")) {
                this.atBlanks = true;
            }
            if (opts.isSet("suspend")) {
                this.enableSuspension();
            }
            if (opts.isSet("view")) {
                this.view = true;
            }
            if (opts.isSet("cutfromcursor")) {
                this.cut2end = true;
            }
            if (opts.isSet("tempfile")) {
                this.tempFile = true;
            }
            if (opts.isSet("historylog")) {
                this.historyLog = opts.get("historyLog");
            }
            if (opts.isSet("tabstospaces")) {
                this.tabsToSpaces = true;
            }
            if (opts.isSet("autoindent")) {
                this.autoIndent = true;
            }
        }
        this.bindKeys();
        if (configPath != null && this.historyLog != null) {
            try {
                this.patternHistory = new PatternHistory(configPath.getUserConfig(this.historyLog, true));
            }
            catch (IOException e) {
                this.errorMessage = "Encountered error while reading pattern-history file: " + this.historyLog;
            }
        }
    }

    private void parseConfig(Path file) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file.toFile()));
        String line = reader.readLine();
        while (line != null) {
            if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                String option;
                List<String> parts = Parser.split(line);
                if (parts.get(0).equals("include")) {
                    if (parts.get(1).contains("*") || parts.get(1).contains("?")) {
                        PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + parts.get(1));
                        Files.find(Paths.get(new File(parts.get(1)).getParent(), new String[0]), Integer.MAX_VALUE, (path, f) -> pathMatcher.matches((Path)path), new FileVisitOption[0]).forEach(p -> this.syntaxFiles.add((Path)p));
                    } else {
                        this.syntaxFiles.add(Paths.get(parts.get(1), new String[0]));
                    }
                } else if (parts.size() == 2 && (parts.get(0).equals("set") || parts.get(0).equals("unset"))) {
                    option = parts.get(1);
                    boolean val = parts.get(0).equals("set");
                    if (option.equals("linenumbers")) {
                        this.printLineNumbers = val;
                    } else if (option.equals("jumpyscrolling")) {
                        this.smoothScrolling = !val;
                    } else if (option.equals("smooth")) {
                        this.smoothScrolling = val;
                    } else if (option.equals("softwrap")) {
                        this.wrapping = val;
                    } else if (option.equals("mouse")) {
                        this.mouseSupport = val;
                    } else if (option.equals("emptyline")) {
                        this.oneMoreLine = val;
                    } else if (option.equals("morespace")) {
                        this.oneMoreLine = !val;
                    } else if (option.equals("constantshow")) {
                        this.constantCursor = val;
                    } else if (option.equals("quickblank")) {
                        this.quickBlank = val;
                    } else if (option.equals("atblanks")) {
                        this.atBlanks = val;
                    } else if (option.equals("suspend")) {
                        this.enableSuspension();
                    } else if (option.equals("view")) {
                        this.view = val;
                    } else if (option.equals("cutfromcursor")) {
                        this.cut2end = val;
                    } else if (option.equals("tempfile")) {
                        this.tempFile = val;
                    } else if (option.equals("tabstospaces")) {
                        this.tabsToSpaces = val;
                    } else if (option.equals("autoindent")) {
                        this.autoIndent = val;
                    } else {
                        this.errorMessage = "Nano config: Unknown or unsupported configuration option " + option;
                    }
                } else if (parts.size() == 3 && parts.get(0).equals("set")) {
                    option = parts.get(1);
                    String val = parts.get(2);
                    if (option.equals("quotestr")) {
                        this.quoteStr = val;
                    } else if (option.equals("punct")) {
                        this.punct = val;
                    } else if (option.equals("matchbrackets")) {
                        this.matchBrackets = val;
                    } else if (option.equals("brackets")) {
                        this.brackets = val;
                    } else if (option.equals("historylog")) {
                        this.historyLog = val;
                    } else {
                        this.errorMessage = "Nano config: Unknown or unsupported configuration option " + option;
                    }
                } else {
                    this.errorMessage = parts.get(0).equals("bind") || parts.get(0).equals("unbind") ? "Nano config: Key bindings can not be changed!" : "Nano config: Bad configuration '" + line + "'";
                }
            }
            line = reader.readLine();
        }
        reader.close();
    }

    public void setRestricted(boolean restricted) {
        this.restricted = restricted;
    }

    public void open(String ... files) throws IOException {
        this.open(Arrays.asList(files));
    }

    public void open(List<String> files) throws IOException {
        for (String file : files) {
            String string = file = file.startsWith("~") ? file.replace("~", System.getProperty("user.home")) : file;
            if (file.contains("*") || file.contains("?")) {
                for (Path p : Commands.findFiles(this.root, file)) {
                    this.buffers.add(new Buffer(p.toString()));
                }
                continue;
            }
            this.buffers.add(new Buffer(file));
        }
    }

    /*
     * Exception decompiling
     */
    public void run() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private int editInputBuffer(Operation operation, int curPos) {
        switch (operation) {
            case INSERT: {
                this.editBuffer.insert(curPos++, this.bindingReader.getLastBinding());
                break;
            }
            case BACKSPACE: {
                if (curPos <= 0) break;
                this.editBuffer.deleteCharAt(--curPos);
                break;
            }
            case LEFT: {
                if (curPos <= 0) break;
                --curPos;
                break;
            }
            case RIGHT: {
                if (curPos >= this.editBuffer.length()) break;
                ++curPos;
            }
        }
        return curPos;
    }

    boolean write() throws IOException {
        KeyMap writeKeyMap = new KeyMap();
        if (!this.restricted) {
            char i;
            writeKeyMap.setUnicode((Object)Operation.INSERT);
            for (i = ' '; i < '\u0100'; i = (char)(i + '\u0001')) {
                writeKeyMap.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
            }
            for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
                writeKeyMap.bind((Object)Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt((char)i));
            }
            writeKeyMap.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.del());
            writeKeyMap.bind((Object)Operation.APPEND_MODE, (CharSequence)KeyMap.alt((char)'a'));
            writeKeyMap.bind((Object)Operation.PREPEND_MODE, (CharSequence)KeyMap.alt((char)'p'));
            writeKeyMap.bind((Object)Operation.BACKUP, (CharSequence)KeyMap.alt((char)'b'));
            writeKeyMap.bind((Object)Operation.TO_FILES, (CharSequence)KeyMap.ctrl((char)'T'));
        }
        writeKeyMap.bind((Object)Operation.MAC_FORMAT, (CharSequence)KeyMap.alt((char)'m'));
        writeKeyMap.bind((Object)Operation.DOS_FORMAT, (CharSequence)KeyMap.alt((char)'d'));
        writeKeyMap.bind((Object)Operation.ACCEPT, (CharSequence)"\r");
        writeKeyMap.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.ctrl((char)'C'));
        writeKeyMap.bind((Object)Operation.HELP, new CharSequence[]{KeyMap.ctrl((char)'G'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f1)});
        writeKeyMap.bind((Object)Operation.MOUSE_EVENT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_mouse));
        writeKeyMap.bind((Object)Operation.TOGGLE_SUSPENSION, (CharSequence)KeyMap.alt((char)'z'));
        writeKeyMap.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
        writeKeyMap.bind((Object)Operation.LEFT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
        this.editMessage = this.getWriteMessage();
        this.editBuffer.setLength(0);
        this.editBuffer.append(this.buffer.file == null ? "" : this.buffer.file);
        int curPos = this.editBuffer.length();
        this.shortcuts = this.writeShortcuts();
        this.display(curPos);
        while (true) {
            Operation op = this.readOperation((KeyMap<Operation>)writeKeyMap);
            switch (op) {
                case CANCEL: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return false;
                }
                case ACCEPT: {
                    this.editMessage = null;
                    if (this.save(this.editBuffer.toString())) {
                        this.shortcuts = this.standardShortcuts();
                        return true;
                    }
                    return false;
                }
                case HELP: {
                    this.help("nano-write-help.txt");
                    break;
                }
                case MAC_FORMAT: {
                    this.buffer.format = this.buffer.format == WriteFormat.MAC ? WriteFormat.UNIX : WriteFormat.MAC;
                    break;
                }
                case DOS_FORMAT: {
                    this.buffer.format = this.buffer.format == WriteFormat.DOS ? WriteFormat.UNIX : WriteFormat.DOS;
                    break;
                }
                case APPEND_MODE: {
                    this.writeMode = this.writeMode == WriteMode.APPEND ? WriteMode.WRITE : WriteMode.APPEND;
                    break;
                }
                case PREPEND_MODE: {
                    this.writeMode = this.writeMode == WriteMode.PREPEND ? WriteMode.WRITE : WriteMode.PREPEND;
                    break;
                }
                case BACKUP: {
                    this.writeBackup = !this.writeBackup;
                    break;
                }
                case MOUSE_EVENT: {
                    this.mouseEvent();
                    break;
                }
                case TOGGLE_SUSPENSION: {
                    this.toggleSuspension();
                    break;
                }
                default: {
                    curPos = this.editInputBuffer(op, curPos);
                }
            }
            this.editMessage = this.getWriteMessage();
            this.display(curPos);
        }
    }

    private Operation readOperation(KeyMap<Operation> keymap) {
        Operation op;
        while ((op = (Operation)((Object)this.bindingReader.readBinding(keymap))) == Operation.DO_LOWER_CASE) {
            this.bindingReader.runMacro(this.bindingReader.getLastBinding().toLowerCase());
        }
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean save(String name) throws IOException {
        boolean isSame;
        Path orgPath = this.buffer.file != null ? this.root.resolve(this.buffer.file) : null;
        Path newPath = this.root.resolve(name);
        boolean bl = isSame = orgPath != null && Files.exists(orgPath, new LinkOption[0]) && Files.exists(newPath, new LinkOption[0]) && Files.isSameFile(orgPath, newPath);
        if (!isSame && Files.exists(Paths.get(name, new String[0]), new LinkOption[0]) && this.writeMode == WriteMode.WRITE) {
            Operation op = this.getYNC("File exists, OVERWRITE ? ");
            if (op != Operation.YES) {
                return false;
            }
        } else if (!Files.exists(newPath, new LinkOption[0])) {
            newPath.toFile().createNewFile();
        }
        Path t = Files.createTempFile("jline-", ".temp", new FileAttribute[0]);
        try {
            boolean bl2;
            block25: {
                OutputStream os = Files.newOutputStream(t, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                try {
                    if (this.writeMode == WriteMode.APPEND && Files.isReadable(newPath)) {
                        Files.copy(newPath, os);
                    }
                    OutputStreamWriter w = new OutputStreamWriter(os, this.buffer.charset);
                    block15: for (int i = 0; i < this.buffer.lines.size(); ++i) {
                        w.write(this.buffer.lines.get(i));
                        switch (this.buffer.format) {
                            case UNIX: {
                                w.write("\n");
                                continue block15;
                            }
                            case DOS: {
                                w.write("\r\n");
                                continue block15;
                            }
                            case MAC: {
                                w.write("\r");
                            }
                        }
                    }
                    ((Writer)w).flush();
                    if (this.writeMode == WriteMode.PREPEND && Files.isReadable(newPath)) {
                        Files.copy(newPath, os);
                    }
                    if (this.writeBackup) {
                        Files.move(newPath, newPath.resolveSibling(newPath.getFileName().toString() + "~"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    Files.move(t, newPath, StandardCopyOption.REPLACE_EXISTING);
                    if (this.writeMode == WriteMode.WRITE) {
                        this.buffer.file = name;
                        this.buffer.dirty = false;
                    }
                    this.setMessage("Wrote " + this.buffer.lines.size() + " lines");
                    bl2 = true;
                    if (os == null) break block25;
                }
                catch (Throwable throwable) {
                    try {
                        if (os != null) {
                            try {
                                os.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        this.setMessage("Error writing " + name + ": " + e.toString());
                        boolean bl3 = false;
                        return bl3;
                    }
                }
                os.close();
            }
            return bl2;
        }
        finally {
            Files.deleteIfExists(t);
            this.writeMode = WriteMode.WRITE;
        }
    }

    private Operation getYNC(String message) {
        return this.getYNC(message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Operation getYNC(String message, boolean andAll) {
        String oldEditMessage = this.editMessage;
        String oldEditBuffer = this.editBuffer.toString();
        LinkedHashMap<String, String> oldShortcuts = this.shortcuts;
        try {
            this.editMessage = message;
            this.editBuffer.setLength(0);
            KeyMap yncKeyMap = new KeyMap();
            yncKeyMap.bind((Object)Operation.YES, new CharSequence[]{"y", "Y"});
            if (andAll) {
                yncKeyMap.bind((Object)Operation.ALL, new CharSequence[]{"a", "A"});
            }
            yncKeyMap.bind((Object)Operation.NO, new CharSequence[]{"n", "N"});
            yncKeyMap.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.ctrl((char)'C'));
            this.shortcuts = new LinkedHashMap();
            this.shortcuts.put(" Y", "Yes");
            if (andAll) {
                this.shortcuts.put(" A", "All");
            }
            this.shortcuts.put(" N", "No");
            this.shortcuts.put("^C", "Cancel");
            this.display();
            Operation operation = this.readOperation((KeyMap<Operation>)yncKeyMap);
            return operation;
        }
        finally {
            this.editMessage = oldEditMessage;
            this.editBuffer.append(oldEditBuffer);
            this.shortcuts = oldShortcuts;
        }
    }

    private String getWriteMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("File Name to ");
        switch (this.writeMode) {
            case WRITE: {
                sb.append("Write");
                break;
            }
            case APPEND: {
                sb.append("Append");
                break;
            }
            case PREPEND: {
                sb.append("Prepend");
            }
        }
        switch (this.buffer.format) {
            case UNIX: {
                break;
            }
            case DOS: {
                sb.append(" [DOS Format]");
                break;
            }
            case MAC: {
                sb.append(" [Mac Format]");
            }
        }
        if (this.writeBackup) {
            sb.append(" [Backup]");
        }
        sb.append(": ");
        return sb.toString();
    }

    void read() {
        char i;
        KeyMap readKeyMap = new KeyMap();
        readKeyMap.setUnicode((Object)Operation.INSERT);
        for (i = ' '; i < '\u0100'; i = (char)(i + '\u0001')) {
            readKeyMap.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            readKeyMap.bind((Object)Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt((char)i));
        }
        readKeyMap.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.del());
        readKeyMap.bind((Object)Operation.NEW_BUFFER, (CharSequence)KeyMap.alt((char)'f'));
        readKeyMap.bind((Object)Operation.TO_FILES, (CharSequence)KeyMap.ctrl((char)'T'));
        readKeyMap.bind((Object)Operation.EXECUTE, (CharSequence)KeyMap.ctrl((char)'X'));
        readKeyMap.bind((Object)Operation.ACCEPT, (CharSequence)"\r");
        readKeyMap.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.ctrl((char)'C'));
        readKeyMap.bind((Object)Operation.HELP, new CharSequence[]{KeyMap.ctrl((char)'G'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f1)});
        readKeyMap.bind((Object)Operation.MOUSE_EVENT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_mouse));
        readKeyMap.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
        readKeyMap.bind((Object)Operation.LEFT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
        this.editMessage = this.getReadMessage();
        this.editBuffer.setLength(0);
        int curPos = this.editBuffer.length();
        this.shortcuts = this.readShortcuts();
        this.display(curPos);
        while (true) {
            Operation op = this.readOperation((KeyMap<Operation>)readKeyMap);
            switch (op) {
                case CANCEL: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case ACCEPT: {
                    Path p;
                    this.editMessage = null;
                    String file = this.editBuffer.toString();
                    boolean empty = file.isEmpty();
                    Path path = p = empty ? null : this.root.resolve(file);
                    if (!(this.readNewBuffer || empty || Files.exists(p, new LinkOption[0]))) {
                        this.setMessage("\"" + file + "\" not found");
                    } else if (!empty && Files.isDirectory(p, new LinkOption[0])) {
                        this.setMessage("\"" + file + "\" is a directory");
                    } else if (!empty && !Files.isRegularFile(p, new LinkOption[0])) {
                        this.setMessage("\"" + file + "\" is not a regular file");
                    } else {
                        Buffer buf = new Buffer(empty ? null : file);
                        try {
                            buf.open();
                            if (this.readNewBuffer) {
                                this.buffers.add(++this.bufferIndex, buf);
                                this.buffer = buf;
                            } else {
                                this.buffer.insert(String.join((CharSequence)"\n", buf.lines));
                            }
                            this.setMessage(null);
                        }
                        catch (IOException e) {
                            this.setMessage("Error reading " + file + ": " + e.getMessage());
                        }
                    }
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case HELP: {
                    this.help("nano-read-help.txt");
                    break;
                }
                case NEW_BUFFER: {
                    this.readNewBuffer = !this.readNewBuffer;
                    break;
                }
                case MOUSE_EVENT: {
                    this.mouseEvent();
                    break;
                }
                default: {
                    curPos = this.editInputBuffer(op, curPos);
                }
            }
            this.editMessage = this.getReadMessage();
            this.display(curPos);
        }
    }

    private String getReadMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("File to insert");
        if (this.readNewBuffer) {
            sb.append(" into new buffer");
        }
        sb.append(" [from ./]: ");
        return sb.toString();
    }

    void gotoLine() throws IOException {
        KeyMap readKeyMap = new KeyMap();
        readKeyMap.setUnicode((Object)Operation.INSERT);
        for (char i = ' '; i < '\u0100'; i = (char)(i + '\u0001')) {
            readKeyMap.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
        }
        readKeyMap.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.del());
        readKeyMap.bind((Object)Operation.ACCEPT, (CharSequence)"\r");
        readKeyMap.bind((Object)Operation.HELP, new CharSequence[]{KeyMap.ctrl((char)'G'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f1)});
        readKeyMap.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.ctrl((char)'C'));
        readKeyMap.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
        readKeyMap.bind((Object)Operation.LEFT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
        readKeyMap.bind((Object)Operation.FIRST_LINE, (CharSequence)KeyMap.ctrl((char)'Y'));
        readKeyMap.bind((Object)Operation.LAST_LINE, (CharSequence)KeyMap.ctrl((char)'V'));
        readKeyMap.bind((Object)Operation.SEARCH, (CharSequence)KeyMap.ctrl((char)'T'));
        this.editMessage = "Enter line number, column number: ";
        this.editBuffer.setLength(0);
        int curPos = this.editBuffer.length();
        this.shortcuts = this.gotoShortcuts();
        this.display(curPos);
        while (true) {
            Operation op = this.readOperation((KeyMap<Operation>)readKeyMap);
            switch (op) {
                case CANCEL: {
                    this.editMessage = null;
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case FIRST_LINE: {
                    this.editMessage = null;
                    this.buffer.firstLine();
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case LAST_LINE: {
                    this.editMessage = null;
                    this.buffer.lastLine();
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case SEARCH: {
                    this.searchToReplace = false;
                    this.searchAndReplace();
                    return;
                }
                case ACCEPT: {
                    this.editMessage = null;
                    String[] pos = this.editBuffer.toString().split(",", 2);
                    int[] args = new int[]{0, 0};
                    try {
                        for (int i = 0; i < pos.length; ++i) {
                            if (pos[i].trim().length() <= 0) continue;
                            args[i] = Integer.parseInt(pos[i]) - 1;
                            if (args[i] >= 0) continue;
                            throw new NumberFormatException();
                        }
                        this.buffer.gotoLine(args[1], args[0]);
                    }
                    catch (NumberFormatException ex) {
                        this.setMessage("Invalid line or column number");
                    }
                    catch (Exception ex) {
                        this.setMessage("Internal error: " + ex.getMessage());
                    }
                    this.shortcuts = this.standardShortcuts();
                    return;
                }
                case HELP: {
                    this.help("nano-goto-help.txt");
                    break;
                }
                default: {
                    curPos = this.editInputBuffer(op, curPos);
                }
            }
            this.display(curPos);
        }
    }

    private LinkedHashMap<String, String> gotoShortcuts() {
        LinkedHashMap<String, String> shortcuts = new LinkedHashMap<String, String>();
        shortcuts.put("^G", "Get Help");
        shortcuts.put("^Y", "First Line");
        shortcuts.put("^T", "Go To Text");
        shortcuts.put("^C", "Cancel");
        shortcuts.put("^V", "Last Line");
        return shortcuts;
    }

    private LinkedHashMap<String, String> readShortcuts() {
        LinkedHashMap<String, String> shortcuts = new LinkedHashMap<String, String>();
        shortcuts.put("^G", "Get Help");
        shortcuts.put("^T", "To Files");
        shortcuts.put("M-F", "New Buffer");
        shortcuts.put("^C", "Cancel");
        shortcuts.put("^X", "Execute Command");
        return shortcuts;
    }

    private LinkedHashMap<String, String> writeShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^G", "Get Help");
        s.put("M-M", "Mac Format");
        s.put("^C", "Cancel");
        s.put("M-D", "DOS Format");
        if (!this.restricted) {
            s.put("^T", "To Files");
            s.put("M-P", "Prepend");
            s.put("M-A", "Append");
            s.put("M-B", "Backup File");
        }
        return s;
    }

    private LinkedHashMap<String, String> helpShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^L", "Refresh");
        s.put("^Y", "Prev Page");
        s.put("^P", "Prev Line");
        s.put("M-\\", "First Line");
        s.put("^X", "Exit");
        s.put("^V", "Next Page");
        s.put("^N", "Next Line");
        s.put("M-/", "Last Line");
        return s;
    }

    private LinkedHashMap<String, String> searchShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^G", "Get Help");
        s.put("^Y", "First Line");
        if (this.searchToReplace) {
            s.put("^R", "No Replace");
        } else {
            s.put("^R", "Replace");
            s.put("^W", "Beg of Par");
        }
        s.put("M-C", "Case Sens");
        s.put("M-R", "Regexp");
        s.put("^C", "Cancel");
        s.put("^V", "Last Line");
        s.put("^T", "Go To Line");
        if (!this.searchToReplace) {
            s.put("^O", "End of Par");
        }
        s.put("M-B", "Backwards");
        s.put("^P", "PrevHstory");
        return s;
    }

    private LinkedHashMap<String, String> replaceShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^G", "Get Help");
        s.put("^Y", "First Line");
        s.put("^P", "PrevHstory");
        s.put("^C", "Cancel");
        s.put("^V", "Last Line");
        s.put("^N", "NextHstory");
        return s;
    }

    private LinkedHashMap<String, String> standardShortcuts() {
        LinkedHashMap<String, String> s = new LinkedHashMap<String, String>();
        s.put("^G", "Get Help");
        if (!this.view) {
            s.put("^O", "WriteOut");
        }
        s.put("^R", "Read File");
        s.put("^Y", "Prev Page");
        if (!this.view) {
            s.put("^K", "Cut Text");
        }
        s.put("^C", "Cur Pos");
        s.put("^X", "Exit");
        if (!this.view) {
            s.put("^J", "Justify");
        }
        s.put("^W", "Where Is");
        s.put("^V", "Next Page");
        if (!this.view) {
            s.put("^U", "UnCut Text");
        }
        s.put("^T", "To Spell");
        return s;
    }

    void help(String help) {
        Buffer org = this.buffer;
        Buffer newBuf = new Buffer(null);
        try (InputStream is = this.getClass().getResourceAsStream(help);){
            newBuf.open(is);
        }
        catch (IOException e) {
            this.setMessage("Unable to read help");
            return;
        }
        LinkedHashMap<String, String> oldShortcuts = this.shortcuts;
        this.shortcuts = this.helpShortcuts();
        boolean oldWrapping = this.wrapping;
        boolean oldPrintLineNumbers = this.printLineNumbers;
        boolean oldConstantCursor = this.constantCursor;
        boolean oldAtBlanks = this.atBlanks;
        boolean oldHighlight = this.highlight;
        String oldEditMessage = this.editMessage;
        this.editMessage = "";
        this.wrapping = true;
        this.atBlanks = true;
        this.printLineNumbers = false;
        this.constantCursor = false;
        this.highlight = false;
        this.buffer = newBuf;
        if (!oldWrapping) {
            this.buffer.computeAllOffsets();
        }
        try {
            this.message = null;
            this.terminal.puts(InfoCmp.Capability.cursor_invisible, new Object[0]);
            this.display();
            while (true) {
                switch (this.readOperation(this.keys)) {
                    case QUIT: {
                        return;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        break;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        break;
                    }
                    case PREV_PAGE: {
                        this.buffer.prevPage();
                        break;
                    }
                    case NEXT_PAGE: {
                        this.buffer.nextPage();
                        break;
                    }
                    case UP: {
                        this.buffer.scrollUp(1);
                        break;
                    }
                    case DOWN: {
                        this.buffer.scrollDown(1);
                        break;
                    }
                    case CLEAR_SCREEN: {
                        this.clearScreen();
                        break;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                        break;
                    }
                    case TOGGLE_SUSPENSION: {
                        this.toggleSuspension();
                    }
                }
                this.display();
            }
        }
        finally {
            this.buffer = org;
            this.wrapping = oldWrapping;
            this.printLineNumbers = oldPrintLineNumbers;
            this.constantCursor = oldConstantCursor;
            this.shortcuts = oldShortcuts;
            this.atBlanks = oldAtBlanks;
            this.highlight = oldHighlight;
            this.editMessage = oldEditMessage;
            this.terminal.puts(InfoCmp.Capability.cursor_visible, new Object[0]);
            if (!oldWrapping) {
                this.buffer.computeAllOffsets();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchAndReplace() {
        try {
            this.search();
            if (!this.searchToReplace) {
                return;
            }
            String replaceTerm = this.replace();
            int replaced = 0;
            boolean all = false;
            boolean found = true;
            ArrayList<Integer> matches = new ArrayList<Integer>();
            Operation op = Operation.NO;
            block11: while (found) {
                found = this.buffer.nextSearch();
                if (found) {
                    int col;
                    int[] re = this.buffer.highlightStart();
                    int match = re[0] * 10000 + (col = this.searchBackwards ? this.buffer.length(this.buffer.getLine(re[0])) - re[1] : re[1]);
                    if (matches.contains(match)) {
                        found = false;
                        break;
                    }
                    matches.add(match);
                    if (!all) {
                        op = this.getYNC("Replace this instance? ", true);
                    }
                } else {
                    op = Operation.NO;
                }
                switch (op) {
                    case ALL: {
                        all = true;
                        this.buffer.replaceFromCursor(this.matchedLength, replaceTerm);
                        ++replaced;
                        continue block11;
                    }
                    case YES: {
                        this.buffer.replaceFromCursor(this.matchedLength, replaceTerm);
                        ++replaced;
                        continue block11;
                    }
                    case NO: {
                        continue block11;
                    }
                    case CANCEL: {
                        found = false;
                        continue block11;
                    }
                }
            }
            this.message = "Replaced " + replaced + " occurrences";
        }
        catch (Exception e) {
            return;
        }
        finally {
            this.searchToReplace = false;
            this.matchedLength = -1;
            this.shortcuts = this.standardShortcuts();
            this.editMessage = null;
        }
    }

    void search() throws IOException {
        char i;
        KeyMap searchKeyMap = new KeyMap();
        searchKeyMap.setUnicode((Object)Operation.INSERT);
        for (i = ' '; i < '\u0100'; i = (char)(i + '\u0001')) {
            searchKeyMap.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            searchKeyMap.bind((Object)Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt((char)i));
        }
        searchKeyMap.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.del());
        searchKeyMap.bind((Object)Operation.CASE_SENSITIVE, (CharSequence)KeyMap.alt((char)'c'));
        searchKeyMap.bind((Object)Operation.BACKWARDS, (CharSequence)KeyMap.alt((char)'b'));
        searchKeyMap.bind((Object)Operation.REGEXP, (CharSequence)KeyMap.alt((char)'r'));
        searchKeyMap.bind((Object)Operation.ACCEPT, (CharSequence)"\r");
        searchKeyMap.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.ctrl((char)'C'));
        searchKeyMap.bind((Object)Operation.HELP, new CharSequence[]{KeyMap.ctrl((char)'G'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f1)});
        searchKeyMap.bind((Object)Operation.FIRST_LINE, (CharSequence)KeyMap.ctrl((char)'Y'));
        searchKeyMap.bind((Object)Operation.LAST_LINE, (CharSequence)KeyMap.ctrl((char)'V'));
        searchKeyMap.bind((Object)Operation.MOUSE_EVENT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_mouse));
        searchKeyMap.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
        searchKeyMap.bind((Object)Operation.LEFT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
        searchKeyMap.bind((Object)Operation.UP, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up));
        searchKeyMap.bind((Object)Operation.DOWN, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down));
        searchKeyMap.bind((Object)Operation.TOGGLE_REPLACE, (CharSequence)KeyMap.ctrl((char)'R'));
        this.editMessage = this.getSearchMessage();
        this.editBuffer.setLength(0);
        String currentBuffer = this.editBuffer.toString();
        int curPos = this.editBuffer.length();
        this.shortcuts = this.searchShortcuts();
        this.display(curPos);
        try {
            while (true) {
                Operation op = this.readOperation((KeyMap<Operation>)searchKeyMap);
                switch (op) {
                    case UP: {
                        this.editBuffer.setLength(0);
                        this.editBuffer.append(this.patternHistory.up(currentBuffer));
                        curPos = this.editBuffer.length();
                        break;
                    }
                    case DOWN: {
                        this.editBuffer.setLength(0);
                        this.editBuffer.append(this.patternHistory.down(currentBuffer));
                        curPos = this.editBuffer.length();
                        break;
                    }
                    case CASE_SENSITIVE: {
                        this.searchCaseSensitive = !this.searchCaseSensitive;
                        break;
                    }
                    case BACKWARDS: {
                        this.searchBackwards = !this.searchBackwards;
                        break;
                    }
                    case REGEXP: {
                        this.searchRegexp = !this.searchRegexp;
                        break;
                    }
                    case CANCEL: {
                        throw new IllegalArgumentException();
                    }
                    case ACCEPT: {
                        if (this.editBuffer.length() > 0) {
                            this.searchTerm = this.editBuffer.toString();
                        }
                        if (this.searchTerm == null || this.searchTerm.isEmpty()) {
                            this.setMessage("Cancelled");
                            throw new IllegalArgumentException();
                        }
                        this.patternHistory.add(this.searchTerm);
                        if (!this.searchToReplace) {
                            this.buffer.nextSearch();
                        }
                        return;
                    }
                    case HELP: {
                        if (this.searchToReplace) {
                            this.help("nano-search-replace-help.txt");
                            break;
                        }
                        this.help("nano-search-help.txt");
                        break;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        break;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        break;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                        break;
                    }
                    case TOGGLE_REPLACE: {
                        this.searchToReplace = !this.searchToReplace;
                        this.shortcuts = this.searchShortcuts();
                        break;
                    }
                    default: {
                        curPos = this.editInputBuffer(op, curPos);
                        currentBuffer = this.editBuffer.toString();
                    }
                }
                this.editMessage = this.getSearchMessage();
                this.display(curPos);
            }
        }
        finally {
            this.shortcuts = this.standardShortcuts();
            this.editMessage = null;
        }
    }

    String replace() throws IOException {
        char i;
        KeyMap keyMap = new KeyMap();
        keyMap.setUnicode((Object)Operation.INSERT);
        for (i = ' '; i < '\u0100'; i = (char)(i + '\u0001')) {
            keyMap.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
        }
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            keyMap.bind((Object)Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt((char)i));
        }
        keyMap.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.del());
        keyMap.bind((Object)Operation.ACCEPT, (CharSequence)"\r");
        keyMap.bind((Object)Operation.CANCEL, (CharSequence)KeyMap.ctrl((char)'C'));
        keyMap.bind((Object)Operation.HELP, new CharSequence[]{KeyMap.ctrl((char)'G'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f1)});
        keyMap.bind((Object)Operation.FIRST_LINE, (CharSequence)KeyMap.ctrl((char)'Y'));
        keyMap.bind((Object)Operation.LAST_LINE, (CharSequence)KeyMap.ctrl((char)'V'));
        keyMap.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
        keyMap.bind((Object)Operation.LEFT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
        keyMap.bind((Object)Operation.UP, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up));
        keyMap.bind((Object)Operation.DOWN, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down));
        this.editMessage = "Replace with: ";
        this.editBuffer.setLength(0);
        String currentBuffer = this.editBuffer.toString();
        int curPos = this.editBuffer.length();
        this.shortcuts = this.replaceShortcuts();
        this.display(curPos);
        try {
            while (true) {
                Operation op = this.readOperation((KeyMap<Operation>)keyMap);
                switch (op) {
                    case UP: {
                        this.editBuffer.setLength(0);
                        this.editBuffer.append(this.patternHistory.up(currentBuffer));
                        curPos = this.editBuffer.length();
                        break;
                    }
                    case DOWN: {
                        this.editBuffer.setLength(0);
                        this.editBuffer.append(this.patternHistory.down(currentBuffer));
                        curPos = this.editBuffer.length();
                        break;
                    }
                    case CANCEL: {
                        throw new IllegalArgumentException();
                    }
                    case ACCEPT: {
                        String replaceTerm = "";
                        if (this.editBuffer.length() > 0) {
                            replaceTerm = this.editBuffer.toString();
                        }
                        if (replaceTerm == null) {
                            this.setMessage("Cancelled");
                            throw new IllegalArgumentException();
                        }
                        this.patternHistory.add(replaceTerm);
                        String string = replaceTerm;
                        return string;
                    }
                    case HELP: {
                        this.help("nano-replace-help.txt");
                        break;
                    }
                    case FIRST_LINE: {
                        this.buffer.firstLine();
                        break;
                    }
                    case LAST_LINE: {
                        this.buffer.lastLine();
                        break;
                    }
                    case MOUSE_EVENT: {
                        this.mouseEvent();
                        break;
                    }
                    default: {
                        curPos = this.editInputBuffer(op, curPos);
                        currentBuffer = this.editBuffer.toString();
                    }
                }
                this.display(curPos);
            }
        }
        finally {
            this.shortcuts = this.standardShortcuts();
            this.editMessage = null;
        }
    }

    private String getSearchMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search");
        if (this.searchToReplace) {
            sb.append(" (to replace)");
        }
        if (this.searchCaseSensitive) {
            sb.append(" [Case Sensitive]");
        }
        if (this.searchRegexp) {
            sb.append(" [Regexp]");
        }
        if (this.searchBackwards) {
            sb.append(" [Backwards]");
        }
        if (this.searchTerm != null) {
            sb.append(" [");
            sb.append(this.searchTerm);
            sb.append("]");
        }
        sb.append(": ");
        return sb.toString();
    }

    String computeCurPos() {
        int chari = 0;
        int chart = 0;
        for (int i = 0; i < this.buffer.lines.size(); ++i) {
            int l = this.buffer.lines.get(i).length() + 1;
            if (i < this.buffer.line) {
                chari += l;
            } else if (i == this.buffer.line) {
                chari += this.buffer.offsetInLine + this.buffer.column;
            }
            chart += l;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("line ");
        sb.append(this.buffer.line + 1);
        sb.append("/");
        sb.append(this.buffer.lines.size());
        sb.append(" (");
        sb.append(Math.round(100.0 * (double)this.buffer.line / (double)this.buffer.lines.size()));
        sb.append("%), ");
        sb.append("col ");
        sb.append(this.buffer.offsetInLine + this.buffer.column + 1);
        sb.append("/");
        sb.append(this.buffer.length(this.buffer.lines.get(this.buffer.line)) + 1);
        sb.append(" (");
        if (this.buffer.lines.get(this.buffer.line).length() > 0) {
            sb.append(Math.round(100.0 * (double)(this.buffer.offsetInLine + this.buffer.column) / (double)this.buffer.length(this.buffer.lines.get(this.buffer.line))));
        } else {
            sb.append("100");
        }
        sb.append("%), ");
        sb.append("char ");
        sb.append(chari + 1);
        sb.append("/");
        sb.append(chart);
        sb.append(" (");
        sb.append(Math.round(100.0 * (double)chari / (double)chart));
        sb.append("%)");
        return sb.toString();
    }

    void curPos() {
        this.setMessage(this.computeCurPos());
    }

    void prevBuffer() throws IOException {
        if (this.buffers.size() > 1) {
            this.bufferIndex = (this.bufferIndex + this.buffers.size() - 1) % this.buffers.size();
            this.buffer = this.buffers.get(this.bufferIndex);
            this.setMessage("Switched to " + this.buffer.getTitle());
            this.buffer.open();
            this.display.clear();
        } else {
            this.setMessage("No more open file buffers");
        }
    }

    void nextBuffer() throws IOException {
        if (this.buffers.size() > 1) {
            this.bufferIndex = (this.bufferIndex + 1) % this.buffers.size();
            this.buffer = this.buffers.get(this.bufferIndex);
            this.setMessage("Switched to " + this.buffer.getTitle());
            this.buffer.open();
            this.display.clear();
        } else {
            this.setMessage("No more open file buffers");
        }
    }

    void setMessage(String message) {
        this.message = message;
        this.nbBindings = this.quickBlank ? 2 : 25;
    }

    boolean quit() throws IOException {
        if (this.buffer.dirty) {
            if (this.tempFile) {
                if (!this.write()) {
                    return false;
                }
            } else {
                Operation op = this.getYNC("Save modified buffer (ANSWERING \"No\" WILL DESTROY CHANGES) ? ");
                switch (op) {
                    case CANCEL: {
                        return false;
                    }
                    case NO: {
                        break;
                    }
                    case YES: {
                        if (this.write()) break;
                        return false;
                    }
                }
            }
        }
        this.buffers.remove(this.bufferIndex);
        if (this.bufferIndex == this.buffers.size() && this.bufferIndex > 0) {
            this.bufferIndex = this.buffers.size() - 1;
        }
        if (this.buffers.isEmpty()) {
            this.buffer = null;
            return true;
        }
        this.buffer = this.buffers.get(this.bufferIndex);
        this.buffer.open();
        this.display.clear();
        this.setMessage("Switched to " + this.buffer.getTitle());
        return false;
    }

    void numbers() {
        this.printLineNumbers = !this.printLineNumbers;
        this.resetDisplay();
        this.setMessage("Lines numbering " + (this.printLineNumbers ? "enabled" : "disabled"));
    }

    void smoothScrolling() {
        this.smoothScrolling = !this.smoothScrolling;
        this.setMessage("Smooth scrolling " + (this.smoothScrolling ? "enabled" : "disabled"));
    }

    void mouseSupport() throws IOException {
        this.mouseSupport = !this.mouseSupport;
        this.setMessage("Mouse support " + (this.mouseSupport ? "enabled" : "disabled"));
        this.terminal.trackMouse(this.mouseSupport ? Terminal.MouseTracking.Normal : Terminal.MouseTracking.Off);
    }

    void constantCursor() {
        this.constantCursor = !this.constantCursor;
        this.setMessage("Constant cursor position display " + (this.constantCursor ? "enabled" : "disabled"));
    }

    void oneMoreLine() {
        this.oneMoreLine = !this.oneMoreLine;
        this.setMessage("Use of one more line for editing " + (this.oneMoreLine ? "enabled" : "disabled"));
    }

    void wrap() {
        this.wrapping = !this.wrapping;
        this.buffer.computeAllOffsets();
        this.resetDisplay();
        this.setMessage("Lines wrapping " + (this.wrapping ? "enabled" : "disabled"));
    }

    void clearScreen() {
        this.resetDisplay();
    }

    void mouseEvent() {
        MouseEvent event = this.terminal.readMouseEvent();
        if (event.getModifiers().isEmpty() && event.getType() == MouseEvent.Type.Released && event.getButton() == MouseEvent.Button.Button1) {
            int x = event.getX();
            int y = event.getY();
            int hdr = this.buffer.computeHeader().size();
            int ftr = this.computeFooter().size();
            if (y >= hdr) {
                if (y < this.size.getRows() - ftr) {
                    this.buffer.moveTo(x, y - hdr);
                } else {
                    int cols = (this.shortcuts.size() + 1) / 2;
                    int cw = this.size.getColumns() / cols;
                    int l = y - (this.size.getRows() - ftr) - 1;
                    int si = l * cols + x / cw;
                    String shortcut = null;
                    Iterator<String> it = this.shortcuts.keySet().iterator();
                    while (si-- >= 0 && it.hasNext()) {
                        shortcut = it.next();
                    }
                    if (shortcut != null) {
                        shortcut = shortcut.replaceAll("M-", "\\\\E");
                        String seq = KeyMap.translate((String)shortcut);
                        this.bindingReader.runMacro(seq);
                    }
                }
            }
        } else if (event.getType() == MouseEvent.Type.Wheel) {
            if (event.getButton() == MouseEvent.Button.WheelDown) {
                this.buffer.moveDown(1);
            } else if (event.getButton() == MouseEvent.Button.WheelUp) {
                this.buffer.moveUp(1);
            }
        }
    }

    void enableSuspension() {
        if (!this.restricted && this.vsusp < 0) {
            Attributes attrs = this.terminal.getAttributes();
            attrs.setControlChar(Attributes.ControlChar.VSUSP, this.vsusp);
            this.terminal.setAttributes(attrs);
        }
    }

    void toggleSuspension() {
        if (this.restricted) {
            this.setMessage("This function is disabled in restricted mode");
        } else if (this.vsusp < 0) {
            this.setMessage("This function is disabled");
        } else {
            Attributes attrs = this.terminal.getAttributes();
            int toggle = this.vsusp;
            String message = "enabled";
            if (attrs.getControlChar(Attributes.ControlChar.VSUSP) > 0) {
                toggle = 0;
                message = "disabled";
            }
            attrs.setControlChar(Attributes.ControlChar.VSUSP, toggle);
            this.terminal.setAttributes(attrs);
            this.setMessage("Suspension " + message);
        }
    }

    public String getTitle() {
        return this.title;
    }

    void resetDisplay() {
        this.display.clear();
        this.display.resize(this.size.getRows(), this.size.getColumns());
        for (Buffer buffer : this.buffers) {
            buffer.resetDisplay();
        }
    }

    synchronized void display() {
        this.display(null);
    }

    synchronized void display(Integer editCursor) {
        int cursor;
        if (this.nbBindings > 0 && --this.nbBindings == 0) {
            this.message = null;
        }
        List<AttributedString> header = this.buffer.computeHeader();
        List<AttributedString> footer = this.computeFooter();
        int nbLines = this.size.getRows() - header.size() - footer.size();
        List<AttributedString> newLines = this.buffer.getDisplayedLines(nbLines);
        newLines.addAll(0, header);
        newLines.addAll(footer);
        if (this.editMessage != null) {
            int crsr = editCursor != null ? editCursor.intValue() : this.editBuffer.length();
            cursor = this.editMessage.length() + crsr;
            cursor = this.size.cursorPos(this.size.getRows() - footer.size(), cursor);
        } else {
            cursor = this.size.cursorPos(header.size(), this.buffer.getDisplayedCursor());
        }
        this.display.update(newLines, cursor);
    }

    protected List<AttributedString> computeFooter() {
        ArrayList<AttributedString> footer = new ArrayList<AttributedString>();
        if (this.editMessage != null) {
            AttributedStringBuilder sb = new AttributedStringBuilder();
            sb.style(AttributedStyle.INVERSE);
            sb.append((CharSequence)this.editMessage);
            sb.append((CharSequence)this.editBuffer);
            for (int i = this.editMessage.length() + this.editBuffer.length(); i < this.size.getColumns(); ++i) {
                sb.append(' ');
            }
            sb.append('\n');
            footer.add(sb.toAttributedString());
        } else if (this.message != null || this.constantCursor) {
            int rwidth = this.size.getColumns();
            String text = "[ " + (this.message == null ? this.computeCurPos() : this.message) + " ]";
            int len = text.length();
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int i = 0; i < (rwidth - len) / 2; ++i) {
                sb.append(' ');
            }
            sb.style(AttributedStyle.INVERSE);
            sb.append((CharSequence)text);
            sb.append('\n');
            footer.add(sb.toAttributedString());
        } else {
            footer.add(new AttributedString((CharSequence)"\n"));
        }
        Iterator<Map.Entry<String, String>> sit = this.shortcuts.entrySet().iterator();
        int cols = (this.shortcuts.size() + 1) / 2;
        int cw = (this.size.getColumns() - 1) / cols;
        int rem = (this.size.getColumns() - 1) % cols;
        for (int l = 0; l < 2; ++l) {
            AttributedStringBuilder sb = new AttributedStringBuilder();
            for (int c = 0; c < cols; ++c) {
                Map.Entry<String, String> entry = sit.hasNext() ? sit.next() : null;
                String key = entry != null ? entry.getKey() : "";
                String val = entry != null ? entry.getValue() : "";
                sb.style(AttributedStyle.INVERSE);
                sb.append((CharSequence)key);
                sb.style(AttributedStyle.DEFAULT);
                sb.append((CharSequence)" ");
                int nb = cw - key.length() - 1 + (c < rem ? 1 : 0);
                if (val.length() > nb) {
                    sb.append((CharSequence)val.substring(0, nb));
                    continue;
                }
                sb.append((CharSequence)val);
                if (c >= cols - 1) continue;
                for (int i = 0; i < nb - val.length(); ++i) {
                    sb.append((CharSequence)" ");
                }
            }
            sb.append('\n');
            footer.add(sb.toAttributedString());
        }
        return footer;
    }

    protected void handle(Terminal.Signal signal) {
        if (this.buffer != null) {
            this.size.copy(this.terminal.getSize());
            this.buffer.computeAllOffsets();
            this.buffer.moveToChar(this.buffer.offsetInLine + this.buffer.column);
            this.resetDisplay();
            this.display();
        }
    }

    protected void bindKeys() {
        this.keys = new KeyMap();
        if (!this.view) {
            char i;
            this.keys.setUnicode((Object)Operation.INSERT);
            for (i = ' '; i < '\u0080'; i = (char)((char)(i + 1))) {
                this.keys.bind((Object)Operation.INSERT, (CharSequence)Character.toString(i));
            }
            this.keys.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.del());
            for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
                this.keys.bind((Object)Operation.DO_LOWER_CASE, (CharSequence)KeyMap.alt((char)i));
            }
            this.keys.bind((Object)Operation.WRITE, new CharSequence[]{KeyMap.ctrl((char)'O'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f3)});
            this.keys.bind((Object)Operation.JUSTIFY_PARAGRAPH, new CharSequence[]{KeyMap.ctrl((char)'J'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f4)});
            this.keys.bind((Object)Operation.CUT, new CharSequence[]{KeyMap.ctrl((char)'K'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f9)});
            this.keys.bind((Object)Operation.UNCUT, new CharSequence[]{KeyMap.ctrl((char)'U'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f10)});
            this.keys.bind((Object)Operation.REPLACE, new CharSequence[]{KeyMap.ctrl((char)'\\'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f14), KeyMap.alt((char)'r')});
            this.keys.bind((Object)Operation.MARK, new CharSequence[]{KeyMap.ctrl((char)'^'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f15), KeyMap.alt((char)'a')});
            this.keys.bind((Object)Operation.COPY, new CharSequence[]{KeyMap.alt((char)'^'), KeyMap.alt((char)'6')});
            this.keys.bind((Object)Operation.INDENT, (CharSequence)KeyMap.alt((char)'}'));
            this.keys.bind((Object)Operation.UNINDENT, (CharSequence)KeyMap.alt((char)'{'));
            this.keys.bind((Object)Operation.VERBATIM, (CharSequence)KeyMap.alt((char)'v'));
            this.keys.bind((Object)Operation.INSERT, new CharSequence[]{KeyMap.ctrl((char)'I'), KeyMap.ctrl((char)'M')});
            this.keys.bind((Object)Operation.DELETE, new CharSequence[]{KeyMap.ctrl((char)'D'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_dc)});
            this.keys.bind((Object)Operation.BACKSPACE, (CharSequence)KeyMap.ctrl((char)'H'));
            this.keys.bind((Object)Operation.CUT_TO_END, (CharSequence)KeyMap.alt((char)'t'));
            this.keys.bind((Object)Operation.JUSTIFY_FILE, (CharSequence)KeyMap.alt((char)'j'));
            this.keys.bind((Object)Operation.AUTO_INDENT, (CharSequence)KeyMap.alt((char)'i'));
            this.keys.bind((Object)Operation.CUT_TO_END_TOGGLE, (CharSequence)KeyMap.alt((char)'k'));
            this.keys.bind((Object)Operation.TABS_TO_SPACE, (CharSequence)KeyMap.alt((char)'q'));
        } else {
            this.keys.bind((Object)Operation.NEXT_PAGE, new CharSequence[]{" ", "f"});
            this.keys.bind((Object)Operation.PREV_PAGE, (CharSequence)"b");
        }
        this.keys.bind((Object)Operation.NEXT_PAGE, new CharSequence[]{KeyMap.ctrl((char)'V'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f8)});
        this.keys.bind((Object)Operation.PREV_PAGE, new CharSequence[]{KeyMap.ctrl((char)'Y'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f7)});
        this.keys.bind((Object)Operation.HELP, new CharSequence[]{KeyMap.ctrl((char)'G'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f1)});
        this.keys.bind((Object)Operation.QUIT, new CharSequence[]{KeyMap.ctrl((char)'X'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f2)});
        this.keys.bind((Object)Operation.READ, new CharSequence[]{KeyMap.ctrl((char)'R'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f5)});
        this.keys.bind((Object)Operation.SEARCH, new CharSequence[]{KeyMap.ctrl((char)'W'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f6)});
        this.keys.bind((Object)Operation.CUR_POS, new CharSequence[]{KeyMap.ctrl((char)'C'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f11)});
        this.keys.bind((Object)Operation.TO_SPELL, new CharSequence[]{KeyMap.ctrl((char)'T'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f11)});
        this.keys.bind((Object)Operation.GOTO, new CharSequence[]{KeyMap.ctrl((char)'_'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f13), KeyMap.alt((char)'g')});
        this.keys.bind((Object)Operation.NEXT_SEARCH, new CharSequence[]{KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_f16), KeyMap.alt((char)'w')});
        this.keys.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.ctrl((char)'F'));
        this.keys.bind((Object)Operation.LEFT, (CharSequence)KeyMap.ctrl((char)'B'));
        this.keys.bind((Object)Operation.NEXT_WORD, (CharSequence)KeyMap.ctrl((char)' '));
        this.keys.bind((Object)Operation.PREV_WORD, (CharSequence)KeyMap.alt((char)' '));
        this.keys.bind((Object)Operation.UP, (CharSequence)KeyMap.ctrl((char)'P'));
        this.keys.bind((Object)Operation.DOWN, (CharSequence)KeyMap.ctrl((char)'N'));
        this.keys.bind((Object)Operation.BEGINNING_OF_LINE, new CharSequence[]{KeyMap.ctrl((char)'A'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_home)});
        this.keys.bind((Object)Operation.END_OF_LINE, new CharSequence[]{KeyMap.ctrl((char)'E'), KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_end)});
        this.keys.bind((Object)Operation.BEGINNING_OF_PARAGRAPH, new CharSequence[]{KeyMap.alt((char)'('), KeyMap.alt((char)'9')});
        this.keys.bind((Object)Operation.END_OF_PARAGRAPH, new CharSequence[]{KeyMap.alt((char)')'), KeyMap.alt((char)'0')});
        this.keys.bind((Object)Operation.FIRST_LINE, new CharSequence[]{KeyMap.alt((char)'\\'), KeyMap.alt((char)'|')});
        this.keys.bind((Object)Operation.LAST_LINE, new CharSequence[]{KeyMap.alt((char)'/'), KeyMap.alt((char)'?')});
        this.keys.bind((Object)Operation.MATCHING, (CharSequence)KeyMap.alt((char)']'));
        this.keys.bind((Object)Operation.SCROLL_UP, new CharSequence[]{KeyMap.alt((char)'-'), KeyMap.alt((char)'_')});
        this.keys.bind((Object)Operation.SCROLL_DOWN, new CharSequence[]{KeyMap.alt((char)'+'), KeyMap.alt((char)'=')});
        this.keys.bind((Object)Operation.PREV_BUFFER, (CharSequence)KeyMap.alt((char)'<'));
        this.keys.bind((Object)Operation.NEXT_BUFFER, (CharSequence)KeyMap.alt((char)'>'));
        this.keys.bind((Object)Operation.PREV_BUFFER, (CharSequence)KeyMap.alt((char)','));
        this.keys.bind((Object)Operation.NEXT_BUFFER, (CharSequence)KeyMap.alt((char)'.'));
        this.keys.bind((Object)Operation.COUNT, (CharSequence)KeyMap.alt((char)'d'));
        this.keys.bind((Object)Operation.CLEAR_SCREEN, (CharSequence)KeyMap.ctrl((char)'L'));
        this.keys.bind((Object)Operation.HELP, (CharSequence)KeyMap.alt((char)'x'));
        this.keys.bind((Object)Operation.CONSTANT_CURSOR, (CharSequence)KeyMap.alt((char)'c'));
        this.keys.bind((Object)Operation.ONE_MORE_LINE, (CharSequence)KeyMap.alt((char)'o'));
        this.keys.bind((Object)Operation.SMOOTH_SCROLLING, (CharSequence)KeyMap.alt((char)'s'));
        this.keys.bind((Object)Operation.MOUSE_SUPPORT, (CharSequence)KeyMap.alt((char)'m'));
        this.keys.bind((Object)Operation.WHITESPACE, (CharSequence)KeyMap.alt((char)'p'));
        this.keys.bind((Object)Operation.HIGHLIGHT, (CharSequence)KeyMap.alt((char)'y'));
        this.keys.bind((Object)Operation.SMART_HOME_KEY, (CharSequence)KeyMap.alt((char)'h'));
        this.keys.bind((Object)Operation.WRAP, (CharSequence)KeyMap.alt((char)'l'));
        this.keys.bind((Object)Operation.BACKUP, (CharSequence)KeyMap.alt((char)'b'));
        this.keys.bind((Object)Operation.NUMBERS, (CharSequence)KeyMap.alt((char)'n'));
        this.keys.bind((Object)Operation.UP, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_up));
        this.keys.bind((Object)Operation.DOWN, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_down));
        this.keys.bind((Object)Operation.RIGHT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_right));
        this.keys.bind((Object)Operation.LEFT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_left));
        this.keys.bind((Object)Operation.MOUSE_EVENT, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_mouse));
        this.keys.bind((Object)Operation.TOGGLE_SUSPENSION, (CharSequence)KeyMap.alt((char)'z'));
        this.keys.bind((Object)Operation.NEXT_PAGE, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_npage));
        this.keys.bind((Object)Operation.PREV_PAGE, (CharSequence)KeyMap.key((Terminal)this.terminal, (InfoCmp.Capability)InfoCmp.Capability.key_ppage));
    }

    protected static enum Operation {
        DO_LOWER_CASE,
        QUIT,
        WRITE,
        READ,
        GOTO,
        FIND,
        WRAP,
        NUMBERS,
        SMOOTH_SCROLLING,
        MOUSE_SUPPORT,
        ONE_MORE_LINE,
        CLEAR_SCREEN,
        UP,
        DOWN,
        LEFT,
        RIGHT,
        INSERT,
        BACKSPACE,
        NEXT_BUFFER,
        PREV_BUFFER,
        HELP,
        NEXT_PAGE,
        PREV_PAGE,
        SCROLL_UP,
        SCROLL_DOWN,
        NEXT_WORD,
        PREV_WORD,
        BEGINNING_OF_LINE,
        END_OF_LINE,
        FIRST_LINE,
        LAST_LINE,
        CUR_POS,
        CASE_SENSITIVE,
        BACKWARDS,
        REGEXP,
        ACCEPT,
        CANCEL,
        SEARCH,
        TOGGLE_REPLACE,
        MAC_FORMAT,
        DOS_FORMAT,
        APPEND_MODE,
        PREPEND_MODE,
        BACKUP,
        TO_FILES,
        YES,
        NO,
        ALL,
        NEW_BUFFER,
        EXECUTE,
        NEXT_SEARCH,
        MATCHING,
        VERBATIM,
        DELETE,
        JUSTIFY_PARAGRAPH,
        TO_SPELL,
        CUT,
        REPLACE,
        MARK,
        COPY,
        INDENT,
        UNINDENT,
        BEGINNING_OF_PARAGRAPH,
        END_OF_PARAGRAPH,
        CUT_TO_END,
        JUSTIFY_FILE,
        COUNT,
        CONSTANT_CURSOR,
        WHITESPACE,
        HIGHLIGHT,
        SMART_HOME_KEY,
        AUTO_INDENT,
        CUT_TO_END_TOGGLE,
        TABS_TO_SPACE,
        UNCUT,
        MOUSE_EVENT,
        TOGGLE_SUSPENSION;

    }

    protected static class PatternHistory {
        private Path historyFile;
        private int size = 100;
        private List<String> patterns = new ArrayList<String>();
        private int patternId = -1;
        private boolean lastMoveUp = false;

        public PatternHistory(Path historyFile) {
            this.historyFile = historyFile;
            this.load();
        }

        public String up(String hint) {
            String out = hint;
            if (this.patterns.size() > 0 && this.patternId < this.patterns.size()) {
                if (!this.lastMoveUp && this.patternId > 0 && this.patternId < this.patterns.size() - 1) {
                    ++this.patternId;
                }
                if (this.patternId < 0) {
                    this.patternId = 0;
                }
                boolean found = false;
                for (int pid = this.patternId; pid < this.patterns.size(); ++pid) {
                    if (hint.length() != 0 && !this.patterns.get(pid).startsWith(hint)) continue;
                    this.patternId = pid + 1;
                    out = this.patterns.get(pid);
                    found = true;
                    break;
                }
                if (!found) {
                    this.patternId = this.patterns.size();
                }
            }
            this.lastMoveUp = true;
            return out;
        }

        public String down(String hint) {
            String out = hint;
            if (this.patterns.size() > 0) {
                if (this.lastMoveUp) {
                    --this.patternId;
                }
                if (this.patternId < 0) {
                    this.patternId = -1;
                } else {
                    boolean found = false;
                    for (int pid = this.patternId; pid >= 0; --pid) {
                        if (hint.length() != 0 && !this.patterns.get(pid).startsWith(hint)) continue;
                        this.patternId = pid - 1;
                        out = this.patterns.get(pid);
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.patternId = -1;
                    }
                }
            }
            this.lastMoveUp = false;
            return out;
        }

        public void add(String pattern) {
            if (pattern.trim().length() == 0) {
                return;
            }
            if (this.patterns.contains(pattern)) {
                this.patterns.remove(pattern);
            }
            if (this.patterns.size() > this.size) {
                this.patterns.remove(this.patterns.size() - 1);
            }
            this.patterns.add(0, pattern);
            this.patternId = -1;
        }

        public void persist() {
            if (this.historyFile == null) {
                return;
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.historyFile.toAbsolutePath(), StandardOpenOption.WRITE, StandardOpenOption.CREATE);){
                for (String s : this.patterns) {
                    if (s.trim().length() <= 0) continue;
                    writer.append(s);
                    writer.newLine();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void load() {
            block9: {
                if (this.historyFile == null) {
                    return;
                }
                try {
                    if (!Files.exists(this.historyFile, new LinkOption[0])) break block9;
                    this.patterns = new ArrayList<String>();
                    try (BufferedReader reader = Files.newBufferedReader(this.historyFile);){
                        reader.lines().forEach(line -> this.patterns.add((String)line));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    protected static class Parser {
        protected Parser() {
        }

        protected static List<String> split(String s) {
            ArrayList<String> out = new ArrayList<String>();
            if (s.length() == 0) {
                return out;
            }
            boolean depth = false;
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\"') {
                    depth = !depth;
                } else if (c == ' ' && !depth && sb.length() > 0) {
                    out.add(Parser.stripQuotes(sb.toString()));
                    sb = new StringBuilder();
                    continue;
                }
                if (sb.length() <= 0 && (c == ' ' || c == '\t')) continue;
                sb.append(c);
            }
            if (sb.length() > 0) {
                out.add(Parser.stripQuotes(sb.toString()));
            }
            return out;
        }

        private static String stripQuotes(String s) {
            String out = s.trim();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                out = s.substring(1, s.length() - 1);
            }
            return out;
        }
    }

    private static class NanorcParser {
        private static final String DEFAULT_SYNTAX = "default";
        private File file;
        private String name;
        private String target;
        private boolean matches = false;
        private List<HighlightRule> highlightRules = new ArrayList<HighlightRule>();
        private String syntaxName;

        public NanorcParser(Path file, String name) {
            this(file, name, null);
        }

        public NanorcParser(Path file, String name, String target) {
            this.file = file.toFile();
            this.name = name;
            this.target = target;
        }

        public void parse() throws IOException {
            BufferedReader reader = new BufferedReader(new FileReader(this.file));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && !line.startsWith("#")) {
                    List<String> parts = Parser.split(line = line.replaceAll("\\\\<", "\\\\b").replaceAll("\\\\>", "\\\\b").replaceAll("\\[\\[:space:\\]\\]", "\\\\s"));
                    if (parts.get(0).equals("syntax")) {
                        this.syntaxName = parts.get(1);
                        ArrayList<Pattern> filePatterns = new ArrayList<Pattern>();
                        if (this.name != null) {
                            if (!this.name.equals(this.syntaxName)) break;
                            this.matches = true;
                        } else if (this.target != null) {
                            for (int i = 2; i < parts.size(); ++i) {
                                filePatterns.add(Pattern.compile(parts.get(i)));
                            }
                            for (Pattern p : filePatterns) {
                                if (!p.matcher(this.target).find()) continue;
                                this.matches = true;
                                break;
                            }
                            if (!this.matches && !this.syntaxName.equals(DEFAULT_SYNTAX)) {
                                break;
                            }
                        } else {
                            this.matches = true;
                        }
                    } else if (parts.get(0).equals("color")) {
                        this.addHighlightRule(parts, false);
                    } else if (parts.get(0).equals("icolor")) {
                        this.addHighlightRule(parts, true);
                    }
                }
                line = reader.readLine();
            }
            reader.close();
        }

        public boolean matches() {
            return this.matches;
        }

        public List<HighlightRule> getHighlightRules() {
            return this.highlightRules;
        }

        public boolean isDefault() {
            return this.syntaxName.equals(DEFAULT_SYNTAX);
        }

        private Integer toColor(String styleString) {
            Integer out = null;
            if (styleString.length() > 0) {
                out = 0;
                if (styleString.startsWith("bright")) {
                    out = 8;
                    styleString = styleString.substring(6);
                }
                if (styleString.equals("white")) {
                    out = out + 7;
                } else if (styleString.equals("black")) {
                    out = out + 0;
                } else if (styleString.equals("red")) {
                    out = out + 1;
                } else if (styleString.equals("blue")) {
                    out = out + 4;
                } else if (styleString.equals("green")) {
                    out = out + 2;
                } else if (styleString.equals("yellow")) {
                    out = out + 3;
                } else if (styleString.equals("magenta")) {
                    out = out + 5;
                } else if (styleString.equals("cyan")) {
                    out = out + 6;
                }
            }
            return out;
        }

        private void addHighlightRule(List<String> parts, boolean caseInsensitive) {
            Integer bcolor;
            AttributedStyle style = AttributedStyle.DEFAULT.foreground(8);
            String[] styleStrings = parts.get(1).split(",");
            Integer fcolor = this.toColor(styleStrings[0]);
            Integer n = bcolor = styleStrings.length > 1 ? this.toColor(styleStrings[1]) : null;
            if (fcolor != null) {
                style = style.foreground(fcolor.intValue());
            }
            if (bcolor != null) {
                style = style.background(bcolor.intValue());
            }
            if (styleStrings.length > 2) {
                if (styleStrings[2].equals("blink")) {
                    style = style.blink();
                } else if (styleStrings[2].equals("bold")) {
                    style = style.bold();
                } else if (styleStrings[2].equals("conceal")) {
                    style = style.conceal();
                } else if (styleStrings[2].equals("faint")) {
                    style = style.faint();
                } else if (styleStrings[2].equals("hidden")) {
                    style = style.hidden();
                } else if (styleStrings[2].equals("inverse")) {
                    style = style.inverse();
                } else if (styleStrings[2].equals("italic")) {
                    style = style.italic();
                } else if (styleStrings[2].equals("underline")) {
                    style = style.underline();
                }
            }
            if (HighlightRule.evalRuleType(parts) == HighlightRule.RuleType.PATTERN) {
                for (int i = 2; i < parts.size(); ++i) {
                    this.highlightRules.add(new HighlightRule(style, this.doPattern(parts.get(i), caseInsensitive)));
                }
            } else if (HighlightRule.evalRuleType(parts) == HighlightRule.RuleType.START_END) {
                String s = parts.get(2);
                String e = parts.get(3);
                this.highlightRules.add(new HighlightRule(style, this.doPattern(s.substring(7, s.length() - 1), caseInsensitive), this.doPattern(e.substring(5, e.length() - 1), caseInsensitive)));
            }
        }

        private Pattern doPattern(String regex, boolean caseInsensitive) {
            return caseInsensitive ? Pattern.compile(regex, 2) : Pattern.compile(regex);
        }
    }

    private static class HighlightRule {
        private RuleType type;
        private Pattern pattern;
        private AttributedStyle style;
        private Pattern start;
        private Pattern end;

        public HighlightRule(AttributedStyle style, Pattern pattern) {
            this.type = RuleType.PATTERN;
            this.pattern = pattern;
            this.style = style;
        }

        public HighlightRule(AttributedStyle style, Pattern start, Pattern end) {
            this.type = RuleType.START_END;
            this.style = style;
            this.start = start;
            this.end = end;
        }

        public RuleType getType() {
            return this.type;
        }

        public AttributedStyle getStyle() {
            return this.style;
        }

        public Pattern getPattern() {
            if (this.type == RuleType.START_END) {
                throw new IllegalAccessError();
            }
            return this.pattern;
        }

        public Pattern getStart() {
            if (this.type == RuleType.PATTERN) {
                throw new IllegalAccessError();
            }
            return this.start;
        }

        public Pattern getEnd() {
            if (this.type == RuleType.PATTERN) {
                throw new IllegalAccessError();
            }
            return this.end;
        }

        public static RuleType evalRuleType(List<String> colorCfg) {
            RuleType out = null;
            if (colorCfg.get(0).equals("color") || colorCfg.get(0).equals("icolor")) {
                out = RuleType.PATTERN;
                if (colorCfg.size() == 4 && colorCfg.get(2).startsWith("start=") && colorCfg.get(3).startsWith("end=")) {
                    out = RuleType.START_END;
                }
            }
            return out;
        }

        public static enum RuleType {
            PATTERN,
            START_END;

        }
    }

    public static class SyntaxHighlighter {
        private List<HighlightRule> rules = new ArrayList<HighlightRule>();
        private int ruleStartId = 0;

        private SyntaxHighlighter() {
        }

        protected static SyntaxHighlighter build(List<Path> syntaxFiles, String file, String syntaxName) {
            SyntaxHighlighter out = new SyntaxHighlighter();
            ArrayList<HighlightRule> defaultRules = new ArrayList<HighlightRule>();
            if (syntaxName == null || syntaxName != null && !syntaxName.equals("none")) {
                for (Path p : syntaxFiles) {
                    NanorcParser parser = new NanorcParser(p, syntaxName, file);
                    try {
                        parser.parse();
                        if (parser.matches()) {
                            out.addRules(parser.getHighlightRules());
                            return out;
                        }
                        if (!parser.isDefault()) continue;
                        defaultRules.addAll(parser.getHighlightRules());
                    }
                    catch (IOException iOException) {}
                }
                out.addRules(defaultRules);
            }
            return out;
        }

        public static SyntaxHighlighter build(Path nanorc, String syntaxName) {
            SyntaxHighlighter out = new SyntaxHighlighter();
            ArrayList<Path> syntaxFiles = new ArrayList<Path>();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(nanorc.toFile()));
                String line = reader.readLine();
                while (line != null) {
                    List<String> parts;
                    if ((line = line.trim()).length() > 0 && !line.startsWith("#") && (parts = Parser.split(line)).get(0).equals("include")) {
                        if (parts.get(1).contains("*") || parts.get(1).contains("?")) {
                            PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + parts.get(1));
                            Files.find(Paths.get(new File(parts.get(1)).getParent(), new String[0]), Integer.MAX_VALUE, (path, f) -> pathMatcher.matches((Path)path), new FileVisitOption[0]).forEach(p -> syntaxFiles.add((Path)p));
                        } else {
                            syntaxFiles.add(Paths.get(parts.get(1), new String[0]));
                        }
                    }
                    line = reader.readLine();
                }
                reader.close();
                out = SyntaxHighlighter.build(syntaxFiles, null, syntaxName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return out;
        }

        private void addRules(List<HighlightRule> rules) {
            this.rules.addAll(rules);
        }

        public void reset() {
            this.ruleStartId = 0;
        }

        public AttributedString highlight(String string) {
            return this.highlight(new AttributedString((CharSequence)string));
        }

        public AttributedString highlight(AttributedStringBuilder asb) {
            return this.highlight(asb.toAttributedString());
        }

        public AttributedString highlight(AttributedString line) {
            if (this.rules.isEmpty()) {
                return line;
            }
            AttributedStringBuilder asb = new AttributedStringBuilder();
            asb.append(line);
            block4: for (int i = this.ruleStartId; i < this.rules.size(); ++i) {
                HighlightRule rule = this.rules.get(i);
                switch (rule.getType()) {
                    case PATTERN: {
                        asb.styleMatches(rule.getPattern(), rule.getStyle());
                        continue block4;
                    }
                    case START_END: {
                        boolean done = false;
                        Matcher start = rule.getStart().matcher((CharSequence)asb.toAttributedString());
                        Matcher end = rule.getEnd().matcher((CharSequence)asb.toAttributedString());
                        while (!done) {
                            AttributedStringBuilder a = new AttributedStringBuilder();
                            if (this.ruleStartId == i) {
                                if (end.find()) {
                                    a.append((CharSequence)asb.columnSubSequence(0, end.end()), rule.getStyle());
                                    a.append(asb.columnSubSequence(end.end(), asb.length()));
                                    this.ruleStartId = 0;
                                } else {
                                    a.append((CharSequence)asb, rule.getStyle());
                                    done = true;
                                }
                                asb = a;
                                continue;
                            }
                            if (start.find()) {
                                a.append(asb.columnSubSequence(0, start.start()));
                                if (end.find()) {
                                    a.append((CharSequence)asb.columnSubSequence(start.start(), end.end()), rule.getStyle());
                                    a.append(asb.columnSubSequence(end.end(), asb.length()));
                                } else {
                                    this.ruleStartId = i;
                                    a.append((CharSequence)asb.columnSubSequence(start.start(), asb.length()), rule.getStyle());
                                    done = true;
                                }
                                asb = a;
                                continue;
                            }
                            done = true;
                        }
                        continue block4;
                    }
                }
            }
            return asb.toAttributedString();
        }
    }

    protected class Buffer {
        String file;
        Charset charset;
        WriteFormat format = WriteFormat.UNIX;
        List<String> lines;
        int firstLineToDisplay;
        int firstColumnToDisplay = 0;
        int offsetInLineToDisplay;
        int line;
        List<LinkedList<Integer>> offsets = new ArrayList<LinkedList<Integer>>();
        int offsetInLine;
        int column;
        int wantedColumn;
        boolean uncut = false;
        int[] markPos = new int[]{-1, -1};
        SyntaxHighlighter syntaxHighlighter;
        boolean dirty;

        protected Buffer(String file) {
            this.file = file;
            this.syntaxHighlighter = SyntaxHighlighter.build(Nano.this.syntaxFiles, file, Nano.this.syntaxName);
        }

        void open() throws IOException {
            if (this.lines != null) {
                return;
            }
            this.lines = new ArrayList<String>();
            this.lines.add("");
            this.charset = Charset.defaultCharset();
            this.computeAllOffsets();
            if (this.file == null) {
                return;
            }
            Path path = Nano.this.root.resolve(this.file);
            if (Files.isDirectory(path, new LinkOption[0])) {
                Nano.this.setMessage("\"" + this.file + "\" is a directory");
                return;
            }
            try (InputStream fis = Files.newInputStream(path, new OpenOption[0]);){
                this.read(fis);
            }
            catch (IOException e) {
                Nano.this.setMessage("Error reading " + this.file + ": " + e.getMessage());
            }
        }

        void open(InputStream is) throws IOException {
            if (this.lines != null) {
                return;
            }
            this.lines = new ArrayList<String>();
            this.lines.add("");
            this.charset = Charset.defaultCharset();
            this.computeAllOffsets();
            this.read(is);
        }

        void read(InputStream fis) throws IOException {
            int remaining;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((remaining = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, remaining);
            }
            byte[] bytes = bos.toByteArray();
            try {
                UniversalDetector detector = new UniversalDetector(null);
                detector.handleData(bytes, 0, bytes.length);
                detector.dataEnd();
                if (detector.getDetectedCharset() != null) {
                    this.charset = Charset.forName(detector.getDetectedCharset());
                }
            }
            catch (Throwable detector) {
                // empty catch block
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bytes), this.charset));){
                String line;
                this.lines.clear();
                while ((line = reader.readLine()) != null) {
                    this.lines.add(line);
                }
            }
            if (this.lines.isEmpty()) {
                this.lines.add("");
            }
            this.computeAllOffsets();
            this.moveToChar(0);
        }

        private int charPosition(int displayPosition) {
            return this.charPosition(this.line, displayPosition, CursorMovement.STILL);
        }

        private int charPosition(int displayPosition, CursorMovement move) {
            return this.charPosition(this.line, displayPosition, move);
        }

        private int charPosition(int line, int displayPosition) {
            return this.charPosition(line, displayPosition, CursorMovement.STILL);
        }

        private int charPosition(int line, int displayPosition, CursorMovement move) {
            int out = this.lines.get(line).length();
            if (!this.lines.get(line).contains("\t") || displayPosition == 0) {
                out = displayPosition;
            } else if (displayPosition < this.length(this.lines.get(line))) {
                int rdiff = 0;
                int ldiff = 0;
                for (int i = 0; i < this.lines.get(line).length(); ++i) {
                    int dp = this.length(this.lines.get(line).substring(0, i));
                    if (move == CursorMovement.LEFT) {
                        if (dp > displayPosition) break;
                        out = i;
                        continue;
                    }
                    if (move == CursorMovement.RIGHT) {
                        if (dp < displayPosition) continue;
                        out = i;
                        break;
                    }
                    if (move != CursorMovement.STILL) continue;
                    if (dp <= displayPosition) {
                        ldiff = displayPosition - dp;
                        out = i;
                        continue;
                    }
                    if (dp < displayPosition) continue;
                    rdiff = dp - displayPosition;
                    if (rdiff >= ldiff) break;
                    out = i;
                    break;
                }
            }
            return out;
        }

        String blanks(int nb) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nb; ++i) {
                sb.append(' ');
            }
            return sb.toString();
        }

        void insert(String insert) {
            String mod;
            String text = this.lines.get(this.line);
            int pos = this.charPosition(this.offsetInLine + this.column);
            insert = insert.replaceAll("\r\n", "\n");
            insert = insert.replaceAll("\r", "\n");
            if (Nano.this.tabsToSpaces && insert.length() == 1 && insert.charAt(0) == '\t') {
                int len = pos == text.length() ? this.length(text + insert) : this.length(text.substring(0, pos) + insert);
                insert = this.blanks(len - this.offsetInLine - this.column);
            }
            if (Nano.this.autoIndent && insert.length() == 1 && insert.charAt(0) == '\n') {
                for (char c : this.lines.get(this.line).toCharArray()) {
                    if (c == ' ') {
                        insert = insert + c;
                        continue;
                    }
                    if (c != '\t') break;
                    insert = insert + c;
                }
            }
            String tail = "";
            if (pos == text.length()) {
                mod = text + insert;
            } else {
                mod = text.substring(0, pos) + insert;
                tail = text.substring(pos);
            }
            ArrayList<String> ins = new ArrayList<String>();
            int last = 0;
            int idx = mod.indexOf(10, last);
            while (idx >= 0) {
                ins.add(mod.substring(last, idx));
                last = idx + 1;
                idx = mod.indexOf(10, last);
            }
            ins.add(mod.substring(last) + tail);
            int curPos = this.length(mod.substring(last));
            this.lines.set(this.line, (String)ins.get(0));
            this.offsets.set(this.line, this.computeOffsets((String)ins.get(0)));
            for (int i = 1; i < ins.size(); ++i) {
                ++this.line;
                this.lines.add(this.line, (String)ins.get(i));
                this.offsets.add(this.line, this.computeOffsets((String)ins.get(i)));
            }
            this.moveToChar(curPos);
            this.ensureCursorVisible();
            this.dirty = true;
        }

        void computeAllOffsets() {
            this.offsets.clear();
            for (String text : this.lines) {
                this.offsets.add(this.computeOffsets(text));
            }
        }

        LinkedList<Integer> computeOffsets(String line) {
            String text = new AttributedStringBuilder().tabs(Nano.this.tabs).append((CharSequence)line).toString();
            int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            LinkedList<Integer> offsets = new LinkedList<Integer>();
            offsets.add(0);
            if (Nano.this.wrapping) {
                int last = 0;
                int prevword = 0;
                boolean inspace = false;
                for (int i = 0; i < text.length(); ++i) {
                    if (this.isBreakable(text.charAt(i))) {
                        inspace = true;
                    } else if (inspace) {
                        prevword = i;
                        inspace = false;
                    }
                    if (i != last + width - 1) continue;
                    if (prevword == last) {
                        prevword = i;
                    }
                    offsets.add(prevword);
                    last = prevword;
                }
            }
            return offsets;
        }

        boolean isBreakable(char ch) {
            return Nano.this.atBlanks ? ch == ' ' : true;
        }

        void moveToChar(int pos) {
            this.moveToChar(pos, CursorMovement.STILL);
        }

        void moveToChar(int pos, CursorMovement move) {
            if (!Nano.this.wrapping) {
                if (pos > this.column && pos - this.firstColumnToDisplay + 1 > this.width()) {
                    this.firstColumnToDisplay = this.offsetInLine + this.column - 6;
                } else if (pos < this.column && this.firstColumnToDisplay + 5 > pos) {
                    this.firstColumnToDisplay = Math.max(0, this.firstColumnToDisplay - this.width() + 5);
                }
            }
            if (this.lines.get(this.line).contains("\t")) {
                int cpos = this.charPosition(pos, move);
                pos = cpos < this.lines.get(this.line).length() ? this.length(this.lines.get(this.line).substring(0, cpos)) : this.length(this.lines.get(this.line));
            }
            this.offsetInLine = this.prevLineOffset(this.line, pos + 1).get();
            this.column = pos - this.offsetInLine;
        }

        void delete(int count) {
            while (--count >= 0 && this.moveRight(1) && this.backspace(1)) {
            }
        }

        boolean backspace(int count) {
            while (count > 0) {
                String text = this.lines.get(this.line);
                int pos = this.charPosition(this.offsetInLine + this.column);
                if (pos == 0) {
                    if (this.line == 0) {
                        this.bof();
                        return false;
                    }
                    String prev = this.lines.get(--this.line);
                    this.lines.set(this.line, prev + text);
                    this.offsets.set(this.line, this.computeOffsets(prev + text));
                    this.moveToChar(this.length(prev));
                    this.lines.remove(this.line + 1);
                    this.offsets.remove(this.line + 1);
                    --count;
                    this.dirty = true;
                    continue;
                }
                int nb = Math.min(pos, count);
                int curPos = this.length(text.substring(0, pos - nb));
                text = text.substring(0, pos - nb) + text.substring(pos);
                this.lines.set(this.line, text);
                this.offsets.set(this.line, this.computeOffsets(text));
                this.moveToChar(curPos);
                count -= nb;
                this.dirty = true;
            }
            this.ensureCursorVisible();
            return true;
        }

        boolean moveLeft(int chars) {
            boolean ret = true;
            while (--chars >= 0) {
                if (this.offsetInLine + this.column > 0) {
                    this.moveToChar(this.offsetInLine + this.column - 1, CursorMovement.LEFT);
                    continue;
                }
                if (this.line > 0) {
                    --this.line;
                    this.moveToChar(this.length(this.getLine(this.line)));
                    continue;
                }
                this.bof();
                ret = false;
                break;
            }
            this.wantedColumn = this.column;
            this.ensureCursorVisible();
            return ret;
        }

        boolean moveRight(int chars) {
            return this.moveRight(chars, false);
        }

        int width() {
            return Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0) - (Nano.this.wrapping ? 0 : 1) - (this.firstColumnToDisplay > 0 ? 1 : 0);
        }

        boolean moveRight(int chars, boolean fromBeginning) {
            if (fromBeginning) {
                this.firstColumnToDisplay = 0;
                this.offsetInLine = 0;
                this.column = 0;
                chars = chars <= this.length(this.getLine(this.line)) ? chars : this.length(this.getLine(this.line));
            }
            boolean ret = true;
            while (--chars >= 0) {
                int len = this.length(this.getLine(this.line));
                if (this.offsetInLine + this.column + 1 <= len) {
                    this.moveToChar(this.offsetInLine + this.column + 1, CursorMovement.RIGHT);
                    continue;
                }
                if (this.getLine(this.line + 1) != null) {
                    ++this.line;
                    this.firstColumnToDisplay = 0;
                    this.offsetInLine = 0;
                    this.column = 0;
                    continue;
                }
                this.eof();
                ret = false;
                break;
            }
            this.wantedColumn = this.column;
            this.ensureCursorVisible();
            return ret;
        }

        void moveDown(int lines) {
            this.cursorDown(lines);
            this.ensureCursorVisible();
        }

        void moveUp(int lines) {
            this.cursorUp(lines);
            this.ensureCursorVisible();
        }

        private Optional<Integer> prevLineOffset(int line, int offsetInLine) {
            if (line >= this.offsets.size()) {
                return Optional.empty();
            }
            Iterator<Integer> it = this.offsets.get(line).descendingIterator();
            while (it.hasNext()) {
                int off = it.next();
                if (off >= offsetInLine) continue;
                return Optional.of(off);
            }
            return Optional.empty();
        }

        private Optional<Integer> nextLineOffset(int line, int offsetInLine) {
            if (line >= this.offsets.size()) {
                return Optional.empty();
            }
            return this.offsets.get(line).stream().filter(o -> o > offsetInLine).findFirst();
        }

        void moveDisplayDown(int lines) {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            while (--lines >= 0) {
                int lastLineToDisplay = this.firstLineToDisplay;
                if (!Nano.this.wrapping) {
                    lastLineToDisplay += height - 1;
                } else {
                    int off = this.offsetInLineToDisplay;
                    for (int l = 0; l < height - 1; ++l) {
                        Optional<Integer> next = this.nextLineOffset(lastLineToDisplay, off);
                        if (next.isPresent()) {
                            off = next.get();
                            continue;
                        }
                        off = 0;
                        ++lastLineToDisplay;
                    }
                }
                if (this.getLine(lastLineToDisplay) == null) {
                    this.eof();
                    return;
                }
                Optional<Integer> next = this.nextLineOffset(this.firstLineToDisplay, this.offsetInLineToDisplay);
                if (next.isPresent()) {
                    this.offsetInLineToDisplay = next.get();
                    continue;
                }
                this.offsetInLineToDisplay = 0;
                ++this.firstLineToDisplay;
            }
        }

        void moveDisplayUp(int lines) {
            int width = Nano.this.size.getColumns() - (Nano.this.printLineNumbers ? 8 : 0);
            while (--lines >= 0) {
                if (this.offsetInLineToDisplay > 0) {
                    this.offsetInLineToDisplay = Math.max(0, this.offsetInLineToDisplay - (width - 1));
                    continue;
                }
                if (this.firstLineToDisplay > 0) {
                    --this.firstLineToDisplay;
                    this.offsetInLineToDisplay = this.prevLineOffset(this.firstLineToDisplay, Integer.MAX_VALUE).get();
                    continue;
                }
                this.bof();
                return;
            }
        }

        private void cursorDown(int lines) {
            this.firstColumnToDisplay = 0;
            while (--lines >= 0) {
                if (!Nano.this.wrapping) {
                    if (this.getLine(this.line + 1) != null) {
                        ++this.line;
                        this.offsetInLine = 0;
                        this.column = Math.min(this.length(this.getLine(this.line)), this.wantedColumn);
                        continue;
                    }
                    this.bof();
                    break;
                }
                String txt = this.getLine(this.line);
                Optional<Integer> off = this.nextLineOffset(this.line, this.offsetInLine);
                if (off.isPresent()) {
                    this.offsetInLine = off.get();
                } else {
                    if (this.getLine(this.line + 1) == null) {
                        this.eof();
                        break;
                    }
                    ++this.line;
                    this.offsetInLine = 0;
                    txt = this.getLine(this.line);
                }
                int next = this.nextLineOffset(this.line, this.offsetInLine).orElse(this.length(txt));
                this.column = Math.min(this.wantedColumn, next - this.offsetInLine);
            }
            this.moveToChar(this.offsetInLine + this.column);
        }

        private void cursorUp(int lines) {
            this.firstColumnToDisplay = 0;
            while (--lines >= 0) {
                if (!Nano.this.wrapping) {
                    if (this.line > 0) {
                        --this.line;
                        this.column = Math.min(this.length(this.getLine(this.line)) - this.offsetInLine, this.wantedColumn);
                        continue;
                    }
                    this.bof();
                    break;
                }
                Optional<Integer> prev = this.prevLineOffset(this.line, this.offsetInLine);
                if (prev.isPresent()) {
                    this.offsetInLine = prev.get();
                    continue;
                }
                if (this.line > 0) {
                    --this.line;
                    this.offsetInLine = this.prevLineOffset(this.line, Integer.MAX_VALUE).get();
                    int next = this.nextLineOffset(this.line, this.offsetInLine).orElse(this.length(this.getLine(this.line)));
                    this.column = Math.min(this.wantedColumn, next - this.offsetInLine);
                    continue;
                }
                this.bof();
                break;
            }
            this.moveToChar(this.offsetInLine + this.column);
        }

        void ensureCursorVisible() {
            int cursor;
            List<AttributedString> header = this.computeHeader();
            int rwidth = Nano.this.size.getColumns();
            int height = Nano.this.size.getRows() - header.size() - Nano.this.computeFooter().size();
            while (this.line < this.firstLineToDisplay || this.line == this.firstLineToDisplay && this.offsetInLine < this.offsetInLineToDisplay) {
                this.moveDisplayUp(Nano.this.smoothScrolling ? 1 : height / 2);
            }
            while ((cursor = this.computeCursorPosition(header.size() * Nano.this.size.getColumns() + (Nano.this.printLineNumbers ? 8 : 0), rwidth)) >= (height + header.size()) * rwidth) {
                this.moveDisplayDown(Nano.this.smoothScrolling ? 1 : height / 2);
            }
        }

        void eof() {
        }

        void bof() {
        }

        void resetDisplay() {
            this.column = this.offsetInLine + this.column;
            this.moveRight(this.column, true);
        }

        String getLine(int line) {
            return line < this.lines.size() ? this.lines.get(line) : null;
        }

        String getTitle() {
            return this.file != null ? "File: " + this.file : "New Buffer";
        }

        List<AttributedString> computeHeader() {
            String left = Nano.this.getTitle();
            String middle = null;
            String right = this.dirty ? "Modified" : "        ";
            int width = Nano.this.size.getColumns();
            int mstart = 2 + left.length() + 1;
            int mend = width - 2 - 8;
            if (this.file == null) {
                middle = "New Buffer";
            } else {
                int max = mend - mstart;
                String src = this.file;
                if ("File: ".length() + src.length() > max) {
                    int lastSep = src.lastIndexOf(47);
                    if (lastSep > 0) {
                        String p1 = src.substring(lastSep);
                        String p0 = src.substring(0, lastSep);
                        while (p0.startsWith(".")) {
                            p0 = p0.substring(1);
                        }
                        int nb = max - p1.length() - "File: ...".length();
                        int cut = Math.max(0, Math.min(p0.length(), p0.length() - nb));
                        middle = "File: ..." + p0.substring(cut, p0.length()) + p1;
                    }
                    if (middle == null || middle.length() > max) {
                        left = null;
                        max = mend - 2;
                        int nb = max - "File: ...".length();
                        int cut = Math.max(0, Math.min(src.length(), src.length() - nb));
                        middle = "File: ..." + src.substring(cut, src.length());
                        if (middle.length() > max) {
                            middle = middle.substring(0, max);
                        }
                    }
                } else {
                    middle = "File: " + src;
                }
            }
            int pos = 0;
            AttributedStringBuilder sb = new AttributedStringBuilder();
            sb.style(AttributedStyle.INVERSE);
            sb.append((CharSequence)"  ");
            pos += 2;
            if (left != null) {
                sb.append((CharSequence)left);
                pos += left.length();
                sb.append((CharSequence)" ");
                ++pos;
                for (int i = 1; i < (Nano.this.size.getColumns() - middle.length()) / 2 - left.length() - 1 - 2; ++i) {
                    sb.append((CharSequence)" ");
                    ++pos;
                }
            }
            sb.append((CharSequence)middle);
            pos += middle.length();
            while (pos < width - 8 - 2) {
                sb.append((CharSequence)" ");
                ++pos;
            }
            sb.append((CharSequence)right);
            sb.append((CharSequence)"  \n");
            if (Nano.this.oneMoreLine) {
                return Collections.singletonList(sb.toAttributedString());
            }
            return Arrays.asList(sb.toAttributedString(), new AttributedString((CharSequence)"\n"));
        }

        void highlightDisplayedLine(int curLine, int curOffset, int nextOffset, AttributedStringBuilder line) {
            AttributedString disp = Nano.this.highlight ? this.syntaxHighlighter.highlight(new AttributedStringBuilder().tabs(Nano.this.tabs).append((CharSequence)this.getLine(curLine))) : new AttributedStringBuilder().tabs(Nano.this.tabs).append((CharSequence)this.getLine(curLine)).toAttributedString();
            int[] hls = this.highlightStart();
            int[] hle = this.highlightEnd();
            if (hls[0] == -1 || hle[0] == -1) {
                line.append(disp.columnSubSequence(curOffset, nextOffset));
            } else if (hls[0] == hle[0]) {
                if (curLine == hls[0]) {
                    if (hls[1] > nextOffset) {
                        line.append(disp.columnSubSequence(curOffset, nextOffset));
                    } else if (hls[1] < curOffset) {
                        if (hle[1] > nextOffset) {
                            line.append((CharSequence)disp.columnSubSequence(curOffset, nextOffset), AttributedStyle.INVERSE);
                        } else if (hle[1] > curOffset) {
                            line.append((CharSequence)disp.columnSubSequence(curOffset, hle[1]), AttributedStyle.INVERSE);
                            line.append(disp.columnSubSequence(hle[1], nextOffset));
                        } else {
                            line.append(disp.columnSubSequence(curOffset, nextOffset));
                        }
                    } else {
                        line.append(disp.columnSubSequence(curOffset, hls[1]));
                        if (hle[1] > nextOffset) {
                            line.append((CharSequence)disp.columnSubSequence(hls[1], nextOffset), AttributedStyle.INVERSE);
                        } else {
                            line.append((CharSequence)disp.columnSubSequence(hls[1], hle[1]), AttributedStyle.INVERSE);
                            line.append(disp.columnSubSequence(hle[1], nextOffset));
                        }
                    }
                } else {
                    line.append(disp.columnSubSequence(curOffset, nextOffset));
                }
            } else if (curLine > hls[0] && curLine < hle[0]) {
                line.append((CharSequence)disp.columnSubSequence(curOffset, nextOffset), AttributedStyle.INVERSE);
            } else if (curLine == hls[0]) {
                if (hls[1] > nextOffset) {
                    line.append(disp.columnSubSequence(curOffset, nextOffset));
                } else if (hls[1] < curOffset) {
                    line.append((CharSequence)disp.columnSubSequence(curOffset, nextOffset), AttributedStyle.INVERSE);
                } else {
                    line.append(disp.columnSubSequence(curOffset, hls[1]));
                    line.append((CharSequence)disp.columnSubSequence(hls[1], nextOffset), AttributedStyle.INVERSE);
                }
            } else if (curLine == hle[0]) {
                if (hle[1] < curOffset) {
                    line.append(disp.columnSubSequence(curOffset, nextOffset));
                } else if (hle[1] > nextOffset) {
                    line.append((CharSequence)disp.columnSubSequence(curOffset, nextOffset), AttributedStyle.INVERSE);
                } else {
                    line.append((CharSequence)disp.columnSubSequence(curOffset, hle[1]), AttributedStyle.INVERSE);
                    line.append(disp.columnSubSequence(hle[1], nextOffset));
                }
            } else {
                line.append(disp.columnSubSequence(curOffset, nextOffset));
            }
        }

        List<AttributedString> getDisplayedLines(int nbLines) {
            AttributedStyle s = AttributedStyle.DEFAULT.foreground(8);
            AttributedString cut = new AttributedString((CharSequence)"\u2026", s);
            AttributedString ret = new AttributedString((CharSequence)"\u21a9", s);
            ArrayList<AttributedString> newLines = new ArrayList<AttributedString>();
            int rwidth = Nano.this.size.getColumns();
            int width = rwidth - (Nano.this.printLineNumbers ? 8 : 0);
            int curLine = this.firstLineToDisplay;
            int curOffset = this.offsetInLineToDisplay;
            int prevLine = -1;
            this.syntaxHighlighter.reset();
            for (int terminalLine = 0; terminalLine < nbLines; ++terminalLine) {
                AttributedStringBuilder line = new AttributedStringBuilder().tabs(Nano.this.tabs);
                if (Nano.this.printLineNumbers && curLine < this.lines.size()) {
                    line.style(s);
                    if (curLine != prevLine) {
                        line.append((CharSequence)String.format("%7d ", curLine + 1));
                    } else {
                        line.append((CharSequence)"      \u2027 ");
                    }
                    line.style(AttributedStyle.DEFAULT);
                    prevLine = curLine;
                }
                if (curLine < this.lines.size()) {
                    if (!Nano.this.wrapping) {
                        AttributedString disp = new AttributedStringBuilder().tabs(Nano.this.tabs).append((CharSequence)this.getLine(curLine)).toAttributedString();
                        if (this.line == curLine) {
                            int cutCount = 1;
                            if (this.firstColumnToDisplay > 0) {
                                line.append(cut);
                                cutCount = 2;
                            }
                            if (disp.columnLength() - this.firstColumnToDisplay >= width - (cutCount - 1) * cut.columnLength()) {
                                this.highlightDisplayedLine(curLine, this.firstColumnToDisplay, this.firstColumnToDisplay + width - cutCount * cut.columnLength(), line);
                                line.append(cut);
                            } else {
                                this.highlightDisplayedLine(curLine, this.firstColumnToDisplay, disp.columnLength(), line);
                            }
                        } else if (disp.columnLength() >= width) {
                            this.highlightDisplayedLine(curLine, 0, width - cut.columnLength(), line);
                            line.append(cut);
                        } else {
                            this.highlightDisplayedLine(curLine, 0, disp.columnLength(), line);
                        }
                        ++curLine;
                    } else {
                        Optional<Integer> nextOffset = this.nextLineOffset(curLine, curOffset);
                        if (nextOffset.isPresent()) {
                            this.highlightDisplayedLine(curLine, curOffset, nextOffset.get(), line);
                            line.append(ret);
                            curOffset = nextOffset.get();
                        } else {
                            this.highlightDisplayedLine(curLine, curOffset, Integer.MAX_VALUE, line);
                            ++curLine;
                            curOffset = 0;
                        }
                    }
                }
                line.append('\n');
                newLines.add(line.toAttributedString());
            }
            return newLines;
        }

        public void moveTo(int x, int y) {
            if (Nano.this.printLineNumbers) {
                x = Math.max(x - 8, 0);
            }
            this.line = this.firstLineToDisplay;
            this.offsetInLine = this.offsetInLineToDisplay;
            this.wantedColumn = x;
            this.cursorDown(y);
        }

        public void gotoLine(int x, int y) {
            this.line = y < this.lines.size() ? y : this.lines.size() - 1;
            x = x <= this.length(this.lines.get(this.line)) ? x : this.length(this.lines.get(this.line));
            this.firstLineToDisplay = this.line > 0 ? this.line - 1 : this.line;
            this.offsetInLine = 0;
            this.offsetInLineToDisplay = 0;
            this.column = 0;
            this.moveRight(x);
        }

        public int getDisplayedCursor() {
            return this.computeCursorPosition(Nano.this.printLineNumbers ? 8 : 0, Nano.this.size.getColumns() + 1);
        }

        private int computeCursorPosition(int cursor, int rwidth) {
            int cur = this.firstLineToDisplay;
            int off = this.offsetInLineToDisplay;
            while (cur < this.line || off < this.offsetInLine) {
                if (!Nano.this.wrapping) {
                    cursor += rwidth;
                    ++cur;
                    continue;
                }
                cursor += rwidth;
                Optional<Integer> next = this.nextLineOffset(cur, off);
                if (next.isPresent()) {
                    off = next.get();
                    continue;
                }
                ++cur;
                off = 0;
            }
            if (cur == this.line) {
                if (!Nano.this.wrapping && this.column > this.firstColumnToDisplay + this.width()) {
                    while (this.column > this.firstColumnToDisplay + this.width()) {
                        this.firstColumnToDisplay += this.width();
                    }
                }
            } else {
                throw new IllegalStateException();
            }
            return cursor += this.column - this.firstColumnToDisplay + (this.firstColumnToDisplay > 0 ? 1 : 0);
        }

        char getCurrentChar() {
            String str = this.lines.get(this.line);
            if (this.column + this.offsetInLine < str.length()) {
                return str.charAt(this.column + this.offsetInLine);
            }
            if (this.line < this.lines.size() - 1) {
                return '\n';
            }
            return '\u0000';
        }

        public void prevWord() {
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            while (!Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveLeft(1)) {
            }
            this.moveRight(1);
        }

        public void nextWord() {
            while (Character.isAlphabetic(this.getCurrentChar()) && this.moveRight(1)) {
            }
            while (!Character.isAlphabetic(this.getCurrentChar()) && this.moveRight(1)) {
            }
        }

        public void beginningOfLine() {
            this.offsetInLine = 0;
            this.column = 0;
            this.wantedColumn = 0;
            this.ensureCursorVisible();
        }

        public void endOfLine() {
            int x = this.length(this.lines.get(this.line));
            this.moveRight(x, true);
        }

        public void prevPage() {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            this.scrollUp(height - 2);
            this.column = 0;
            this.firstLineToDisplay = this.line;
            this.offsetInLineToDisplay = this.offsetInLine;
        }

        public void nextPage() {
            int height = Nano.this.size.getRows() - this.computeHeader().size() - Nano.this.computeFooter().size();
            this.scrollDown(height - 2);
            this.column = 0;
            this.firstLineToDisplay = this.line;
            this.offsetInLineToDisplay = this.offsetInLine;
        }

        public void scrollUp(int lines) {
            this.cursorUp(lines);
            this.moveDisplayUp(lines);
        }

        public void scrollDown(int lines) {
            this.cursorDown(lines);
            this.moveDisplayDown(lines);
        }

        public void firstLine() {
            this.line = 0;
            this.column = 0;
            this.offsetInLine = 0;
            this.ensureCursorVisible();
        }

        public void lastLine() {
            this.line = this.lines.size() - 1;
            this.column = 0;
            this.offsetInLine = 0;
            this.ensureCursorVisible();
        }

        boolean nextSearch() {
            boolean out = false;
            if (Nano.this.searchTerm == null) {
                Nano.this.setMessage("No current search pattern");
                return false;
            }
            Nano.this.setMessage(null);
            int cur = this.line;
            int dir = Nano.this.searchBackwards ? -1 : 1;
            int newPos = -1;
            int newLine = -1;
            List<Integer> curRes = this.doSearch(this.lines.get(this.line));
            if (Nano.this.searchBackwards) {
                Collections.reverse(curRes);
            }
            for (int r : curRes) {
                if (!(Nano.this.searchBackwards ? r < this.offsetInLine + this.column : r > this.offsetInLine + this.column)) continue;
                newPos = r;
                newLine = this.line;
                break;
            }
            if (newPos < 0) {
                while ((cur = (cur + dir + this.lines.size()) % this.lines.size()) != this.line) {
                    List<Integer> res = this.doSearch(this.lines.get(cur));
                    if (res.isEmpty()) continue;
                    newPos = Nano.this.searchBackwards ? res.get(res.size() - 1) : res.get(0);
                    newLine = cur;
                    break;
                }
            }
            if (newPos < 0 && !curRes.isEmpty()) {
                newPos = curRes.get(0);
                newLine = this.line;
            }
            if (newPos >= 0) {
                if (newLine == this.line && newPos == this.offsetInLine + this.column) {
                    Nano.this.setMessage("This is the only occurence");
                    return false;
                }
                if (Nano.this.searchBackwards && (newLine > this.line || newLine == this.line && newPos > this.offsetInLine + this.column) || !Nano.this.searchBackwards && (newLine < this.line || newLine == this.line && newPos < this.offsetInLine + this.column)) {
                    Nano.this.setMessage("Search Wrapped");
                }
                this.line = newLine;
                this.moveRight(newPos, true);
                out = true;
            } else {
                Nano.this.setMessage("\"" + Nano.this.searchTerm + "\" not found");
            }
            return out;
        }

        private List<Integer> doSearch(String text) {
            Pattern pat = Pattern.compile(Nano.this.searchTerm, (Nano.this.searchCaseSensitive ? 0 : 66) | (Nano.this.searchRegexp ? 0 : 16));
            Matcher m = pat.matcher(text);
            ArrayList<Integer> res = new ArrayList<Integer>();
            while (m.find()) {
                res.add(m.start());
                Nano.this.matchedLength = m.group(0).length();
            }
            return res;
        }

        protected int[] highlightStart() {
            int[] out = new int[]{-1, -1};
            if (Nano.this.mark) {
                out = this.getMarkStart();
            } else if (Nano.this.searchToReplace) {
                out[0] = this.line;
                out[1] = this.offsetInLine + this.column;
            }
            return out;
        }

        protected int[] highlightEnd() {
            int[] out = new int[]{-1, -1};
            if (Nano.this.mark) {
                out = this.getMarkEnd();
            } else if (Nano.this.searchToReplace && Nano.this.matchedLength > 0) {
                out[0] = this.line;
                int col = this.charPosition(this.offsetInLine + this.column) + Nano.this.matchedLength;
                out[1] = col < this.lines.get(this.line).length() ? this.length(this.lines.get(this.line).substring(0, col)) : this.length(this.lines.get(this.line));
            }
            return out;
        }

        public void matching() {
            char opening = this.getCurrentChar();
            int idx = Nano.this.matchBrackets.indexOf(opening);
            if (idx >= 0) {
                int dir = idx >= Nano.this.matchBrackets.length() / 2 ? -1 : 1;
                char closing = Nano.this.matchBrackets.charAt((idx + Nano.this.matchBrackets.length() / 2) % Nano.this.matchBrackets.length());
                int lvl = 1;
                int cur = this.line;
                int pos = this.offsetInLine + this.column;
                while (true) {
                    if (pos + dir >= 0 && pos + dir < this.getLine(cur).length()) {
                        pos += dir;
                    } else if (cur + dir >= 0 && cur + dir < this.lines.size()) {
                        pos = dir > 0 ? 0 : this.lines.get(cur += dir).length() - 1;
                        if (pos < 0 || pos >= this.lines.get(cur).length()) {
                            continue;
                        }
                    } else {
                        Nano.this.setMessage("No matching bracket");
                        return;
                    }
                    char c = this.lines.get(cur).charAt(pos);
                    if (c == opening) {
                        ++lvl;
                        continue;
                    }
                    if (c == closing && --lvl == 0) break;
                }
                this.line = cur;
                this.moveToChar(pos);
                this.ensureCursorVisible();
                return;
            }
            Nano.this.setMessage("Not a bracket");
        }

        private int length(String line) {
            return new AttributedStringBuilder().tabs(Nano.this.tabs).append((CharSequence)line).columnLength();
        }

        void copy() {
            if (this.uncut || Nano.this.cut2end || Nano.this.mark) {
                Nano.this.cutbuffer = new ArrayList<String>();
            }
            if (Nano.this.mark) {
                int[] e;
                int[] s = this.getMarkStart();
                if (s[0] == (e = this.getMarkEnd())[0]) {
                    Nano.this.cutbuffer.add(this.lines.get(s[0]).substring(this.charPosition(s[0], s[1]), this.charPosition(e[0], e[1])));
                } else {
                    if (s[1] != 0) {
                        Nano.this.cutbuffer.add(this.lines.get(s[0]).substring(this.charPosition(s[0], s[1])));
                        s[0] = s[0] + 1;
                    }
                    for (int i = s[0]; i < e[0]; ++i) {
                        Nano.this.cutbuffer.add(this.lines.get(i));
                    }
                    if (e[1] != 0) {
                        Nano.this.cutbuffer.add(this.lines.get(e[0]).substring(0, this.charPosition(e[0], e[1])));
                    }
                }
                Nano.this.mark = false;
                this.mark();
            } else if (Nano.this.cut2end) {
                String l = this.lines.get(this.line);
                int col = this.charPosition(this.offsetInLine + this.column);
                Nano.this.cutbuffer.add(l.substring(col));
                this.moveRight(l.substring(col).length());
            } else {
                Nano.this.cutbuffer.add(this.lines.get(this.line));
                this.cursorDown(1);
            }
            this.uncut = false;
        }

        void cut() {
            this.cut(false);
        }

        void cut(boolean toEnd) {
            if (this.lines.size() > 1) {
                if (this.uncut || Nano.this.cut2end || toEnd || Nano.this.mark) {
                    Nano.this.cutbuffer = new ArrayList<String>();
                }
                if (Nano.this.mark) {
                    int[] e;
                    int[] s = this.getMarkStart();
                    if (s[0] == (e = this.getMarkEnd())[0]) {
                        String l = this.lines.get(s[0]);
                        int cols = this.charPosition(s[0], s[1]);
                        int cole = this.charPosition(e[0], e[1]);
                        Nano.this.cutbuffer.add(l.substring(cols, cole));
                        this.lines.set(s[0], l.substring(0, cols) + l.substring(cole));
                        this.computeAllOffsets();
                        this.moveRight(cols, true);
                    } else {
                        int ls = s[0];
                        int cs = this.charPosition(s[0], s[1]);
                        if (s[1] != 0) {
                            String l = this.lines.get(s[0]);
                            Nano.this.cutbuffer.add(l.substring(cs));
                            this.lines.set(s[0], l.substring(0, cs));
                            s[0] = s[0] + 1;
                        }
                        for (int i = s[0]; i < e[0]; ++i) {
                            Nano.this.cutbuffer.add(this.lines.get(s[0]));
                            this.lines.remove(s[0]);
                        }
                        if (e[1] != 0) {
                            String l = this.lines.get(s[0]);
                            int col = this.charPosition(e[0], e[1]);
                            Nano.this.cutbuffer.add(l.substring(0, col));
                            this.lines.set(s[0], l.substring(col));
                        }
                        this.computeAllOffsets();
                        this.gotoLine(cs, ls);
                    }
                    Nano.this.mark = false;
                    this.mark();
                } else if (Nano.this.cut2end || toEnd) {
                    String l = this.lines.get(this.line);
                    int col = this.charPosition(this.offsetInLine + this.column);
                    Nano.this.cutbuffer.add(l.substring(col));
                    this.lines.set(this.line, l.substring(0, col));
                    if (toEnd) {
                        ++this.line;
                        do {
                            Nano.this.cutbuffer.add(this.lines.get(this.line));
                            this.lines.remove(this.line);
                        } while (this.line <= this.lines.size() - 1);
                        --this.line;
                    }
                } else {
                    Nano.this.cutbuffer.add(this.lines.get(this.line));
                    this.lines.remove(this.line);
                    this.offsetInLine = 0;
                    if (this.line > this.lines.size() - 1) {
                        --this.line;
                    }
                }
                Nano.this.display.clear();
                this.computeAllOffsets();
                this.dirty = true;
                this.uncut = false;
            }
        }

        void uncut() {
            if (Nano.this.cutbuffer.isEmpty()) {
                return;
            }
            String l = this.lines.get(this.line);
            int col = this.charPosition(this.offsetInLine + this.column);
            if (Nano.this.cut2end) {
                this.lines.set(this.line, l.substring(0, col) + Nano.this.cutbuffer.get(0) + l.substring(col));
                this.computeAllOffsets();
                this.moveRight(col + Nano.this.cutbuffer.get(0).length(), true);
            } else if (col == 0) {
                this.lines.addAll(this.line, Nano.this.cutbuffer);
                this.computeAllOffsets();
                if (Nano.this.cutbuffer.size() > 1) {
                    this.gotoLine(Nano.this.cutbuffer.get(Nano.this.cutbuffer.size() - 1).length(), this.line + Nano.this.cutbuffer.size());
                } else {
                    this.moveRight(Nano.this.cutbuffer.get(0).length(), true);
                }
            } else {
                int gotol = this.line;
                if (Nano.this.cutbuffer.size() == 1) {
                    this.lines.set(this.line, l.substring(0, col) + Nano.this.cutbuffer.get(0) + l.substring(col));
                } else {
                    this.lines.set(this.line++, l.substring(0, col) + Nano.this.cutbuffer.get(0));
                    gotol = this.line;
                    this.lines.add(this.line, Nano.this.cutbuffer.get(Nano.this.cutbuffer.size() - 1) + l.substring(col));
                    for (int i = Nano.this.cutbuffer.size() - 2; i > 0; --i) {
                        ++gotol;
                        this.lines.add(this.line, Nano.this.cutbuffer.get(i));
                    }
                }
                this.computeAllOffsets();
                if (Nano.this.cutbuffer.size() > 1) {
                    this.gotoLine(Nano.this.cutbuffer.get(Nano.this.cutbuffer.size() - 1).length(), gotol);
                } else {
                    this.moveRight(col + Nano.this.cutbuffer.get(0).length(), true);
                }
            }
            Nano.this.display.clear();
            this.dirty = true;
            this.uncut = true;
        }

        void mark() {
            if (Nano.this.mark) {
                this.markPos[0] = this.line;
                this.markPos[1] = this.offsetInLine + this.column;
            } else {
                this.markPos[0] = -1;
                this.markPos[1] = -1;
            }
        }

        int[] getMarkStart() {
            int[] out = new int[]{-1, -1};
            if (!Nano.this.mark) {
                return out;
            }
            if (this.markPos[0] > this.line || this.markPos[0] == this.line && this.markPos[1] > this.offsetInLine + this.column) {
                out[0] = this.line;
                out[1] = this.offsetInLine + this.column;
            } else {
                out = this.markPos;
            }
            return out;
        }

        int[] getMarkEnd() {
            int[] out = new int[]{-1, -1};
            if (!Nano.this.mark) {
                return out;
            }
            if (this.markPos[0] > this.line || this.markPos[0] == this.line && this.markPos[1] > this.offsetInLine + this.column) {
                out = this.markPos;
            } else {
                out[0] = this.line;
                out[1] = this.offsetInLine + this.column;
            }
            return out;
        }

        void replaceFromCursor(int chars, String string) {
            int pos = this.charPosition(this.offsetInLine + this.column);
            String text = this.lines.get(this.line);
            String mod = text.substring(0, pos) + string;
            if (chars + pos < text.length()) {
                mod = mod + text.substring(chars + pos);
            }
            this.lines.set(this.line, mod);
            this.dirty = true;
        }
    }

    protected static enum CursorMovement {
        RIGHT,
        LEFT,
        STILL;

    }

    protected static enum WriteFormat {
        UNIX,
        DOS,
        MAC;

    }

    protected static enum WriteMode {
        WRITE,
        APPEND,
        PREPEND;

    }
}

