/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.percolator.stats;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.HashedBytesRef;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.metrics.MeanMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.percolator.stats.PercolateStats;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;

public class ShardPercolateService
extends AbstractIndexShardComponent {
    private final MeanMetric percolateMetric = new MeanMetric();
    private final CounterMetric currentMetric = new CounterMetric();
    private final CounterMetric numberOfQueries = new CounterMetric();
    private final CounterMetric memorySizeInBytes = new CounterMetric();

    @Inject
    public ShardPercolateService(ShardId shardId, @IndexSettings Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public void prePercolate() {
        this.currentMetric.inc();
    }

    public void postPercolate(long tookInNanos) {
        this.currentMetric.dec();
        this.percolateMetric.inc(tookInNanos);
    }

    public void addedQuery(HashedBytesRef id, Query previousQuery, Query newQuery) {
        if (previousQuery != null) {
            this.memorySizeInBytes.dec(ShardPercolateService.computeSizeInMemory(id, previousQuery));
        } else {
            this.numberOfQueries.inc();
        }
        this.memorySizeInBytes.inc(ShardPercolateService.computeSizeInMemory(id, newQuery));
    }

    public void removedQuery(HashedBytesRef id, Query query) {
        this.numberOfQueries.dec();
        this.memorySizeInBytes.dec(ShardPercolateService.computeSizeInMemory(id, query));
    }

    public PercolateStats stats() {
        return new PercolateStats(this.percolateMetric.count(), TimeUnit.NANOSECONDS.toMillis(this.percolateMetric.sum()), this.currentMetric.count(), this.memorySizeInBytes.count(), this.numberOfQueries.count());
    }

    private static long computeSizeInMemory(HashedBytesRef id, Query query) {
        long size = 12 + RamUsageEstimator.NUM_BYTES_OBJECT_REF + RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + id.bytes.bytes.length;
        return size += RamEstimator.sizeOf(query);
    }

    private static final class RamEstimator {
        private RamEstimator() {
        }

        static long sizeOf(Query query) {
            return RamUsageEstimator.sizeOf((Object)query);
        }
    }
}

