/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public abstract class BucketsAggregator
extends Aggregator {
    private LongArray docCounts;
    private final Aggregator[] collectableSugAggregators;

    public BucketsAggregator(String name, Aggregator.BucketAggregationMode bucketAggregationMode, AggregatorFactories factories, long estimatedBucketsCount, AggregationContext context, Aggregator parent) {
        super(name, bucketAggregationMode, factories, estimatedBucketsCount, context, parent);
        this.docCounts = BigArrays.newLongArray(estimatedBucketsCount, context.pageCacheRecycler(), true);
        ArrayList<Aggregator> collectables = new ArrayList<Aggregator>(this.subAggregators.length);
        for (int i = 0; i < this.subAggregators.length; ++i) {
            if (!this.subAggregators[i].shouldCollect()) continue;
            collectables.add(this.subAggregators[i]);
        }
        this.collectableSugAggregators = collectables.toArray(new Aggregator[collectables.size()]);
    }

    protected final void collectBucket(int doc, long bucketOrd) throws IOException {
        this.docCounts = BigArrays.grow(this.docCounts, bucketOrd + 1L);
        this.docCounts.increment(bucketOrd, 1L);
        for (int i = 0; i < this.collectableSugAggregators.length; ++i) {
            this.collectableSugAggregators[i].collect(doc, bucketOrd);
        }
    }

    protected final void collectBucketNoCounts(int doc, long bucketOrd) throws IOException {
        for (int i = 0; i < this.collectableSugAggregators.length; ++i) {
            this.collectableSugAggregators[i].collect(doc, bucketOrd);
        }
    }

    protected final void incrementBucketDocCount(int inc, long bucketOrd) throws IOException {
        this.docCounts = BigArrays.grow(this.docCounts, bucketOrd + 1L);
        this.docCounts.increment(bucketOrd, inc);
    }

    protected final long bucketDocCount(long bucketOrd) {
        if (bucketOrd >= this.docCounts.size()) {
            return 0L;
        }
        return this.docCounts.get(bucketOrd);
    }

    protected final InternalAggregations bucketAggregations(long bucketOrd) {
        InternalAggregation[] aggregations = new InternalAggregation[this.subAggregators.length];
        long bucketDocCount = this.bucketDocCount(bucketOrd);
        for (int i = 0; i < this.subAggregators.length; ++i) {
            aggregations[i] = bucketDocCount == 0L ? this.subAggregators[i].buildEmptyAggregation() : this.subAggregators[i].buildAggregation(bucketOrd);
        }
        return new InternalAggregations(Arrays.asList(aggregations));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean release() {
        boolean success = false;
        try {
            super.release();
            success = true;
        }
        catch (Throwable throwable) {
            Releasables.release(success, this.docCounts);
            throw throwable;
        }
        Releasables.release(success, this.docCounts);
        return true;
    }
}

