/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.suggest;

import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.multibindings.Multibinder;
import org.elasticsearch.search.suggest.SuggestParseElement;
import org.elasticsearch.search.suggest.SuggestPhase;
import org.elasticsearch.search.suggest.Suggester;
import org.elasticsearch.search.suggest.Suggesters;
import org.elasticsearch.search.suggest.completion.CompletionSuggester;
import org.elasticsearch.search.suggest.phrase.PhraseSuggester;
import org.elasticsearch.search.suggest.term.TermSuggester;

public class SuggestModule
extends AbstractModule {
    private List<Class<? extends Suggester>> suggesters = Lists.newArrayList();

    public SuggestModule() {
        this.registerSuggester(PhraseSuggester.class);
        this.registerSuggester(TermSuggester.class);
        this.registerSuggester(CompletionSuggester.class);
    }

    public void registerSuggester(Class<? extends Suggester> suggester) {
        this.suggesters.add(suggester);
    }

    @Override
    protected void configure() {
        Multibinder<Suggester> suggesterMultibinder = Multibinder.newSetBinder(this.binder(), Suggester.class);
        for (Class<? extends Suggester> clazz : this.suggesters) {
            suggesterMultibinder.addBinding().to(clazz);
        }
        this.bind(SuggestParseElement.class).asEagerSingleton();
        this.bind(SuggestPhase.class).asEagerSingleton();
        this.bind(Suggesters.class).asEagerSingleton();
    }
}

