/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.NativeServices;

public class ThreadPool {
    public static final String CONCURRENCY_PROP_NAME = "jj2000.j2k.util.ThreadPool.concurrency";
    private ThreadPoolThread[] idle;
    private int nidle;
    private String poolName;
    private int poolPriority;
    private volatile Error targetE;
    private volatile RuntimeException targetRE;

    public ThreadPool(int size, int priority, String name) {
        if (size <= 0) {
            throw new IllegalArgumentException("Pool must be of positive size");
        }
        this.poolPriority = priority < 1 ? Thread.currentThread().getPriority() : (priority < 10 ? priority : 10);
        this.poolName = name == null ? "Anonymous ThreadPool" : name;
        String prop = System.getProperty(CONCURRENCY_PROP_NAME);
        if (prop != null) {
            int clevel;
            try {
                clevel = Integer.parseInt(prop);
                if (clevel < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid concurrency level in property jj2000.j2k.util.ThreadPool.concurrency");
            }
            if (NativeServices.loadLibrary()) {
                FacilityManager.getMsgLogger().printmsg(1, "Changing thread concurrency level from " + NativeServices.getThreadConcurrency() + " to " + clevel + ".");
                NativeServices.setThreadConcurrency(clevel);
            } else {
                FacilityManager.getMsgLogger().printmsg(2, "Native library to set thread concurrency level as specified by the jj2000.j2k.util.ThreadPool.concurrency property not found. Thread concurrency unchanged.");
            }
        }
        this.idle = new ThreadPoolThread[size];
        this.nidle = 0;
        for (int i = 0; i < size; ++i) {
            ThreadPoolThread t = new ThreadPoolThread(i, this.poolName + "-" + i);
            t.start();
        }
    }

    public int getSize() {
        return this.idle.length;
    }

    public boolean runTarget(Runnable t, Object l) {
        return this.runTarget(t, l, false, false);
    }

    public boolean runTarget(Runnable t, Object l, boolean async) {
        return this.runTarget(t, l, async, false);
    }

    public boolean runTarget(Runnable t, Object l, boolean async, boolean notifyAll) {
        ThreadPoolThread runner = this.getIdle(async);
        if (runner == null) {
            return false;
        }
        runner.setTarget(t, l, notifyAll);
        return true;
    }

    public void checkTargetErrors() {
        if (this.targetE != null) {
            throw this.targetE;
        }
        if (this.targetRE != null) {
            throw this.targetRE;
        }
    }

    public void clearTargetErrors() {
        this.targetE = null;
        this.targetRE = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInIdleList(ThreadPoolThread t) {
        ThreadPoolThread[] threadPoolThreadArray = this.idle;
        synchronized (this.idle) {
            this.idle[this.nidle] = t;
            ++this.nidle;
            if (this.nidle == 1) {
                this.idle.notify();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolThread getIdle(boolean async) {
        ThreadPoolThread[] threadPoolThreadArray = this.idle;
        synchronized (this.idle) {
            if (async) {
                if (this.nidle == 0) {
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
            } else {
                while (this.nidle == 0) {
                    try {
                        this.idle.wait();
                    }
                    catch (InterruptedException e) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                }
            }
            --this.nidle;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.idle[this.nidle];
        }
    }

    class ThreadPoolThread
    extends Thread {
        private Runnable target;
        private Object lock;
        private boolean doNotifyAll;

        public ThreadPoolThread(int idx, String name) {
            super(name);
            this.setDaemon(true);
            this.setPriority(ThreadPool.this.poolPriority);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ThreadPool.this.putInIdleList(this);
            ThreadPoolThread threadPoolThread = this;
            synchronized (threadPoolThread) {
                while (true) {
                    if (this.target == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {}
                        continue;
                    }
                    try {
                        this.target.run();
                    }
                    catch (ThreadDeath td) {
                        FacilityManager.getMsgLogger().printmsg(2, "Thread.stop() called on a ThreadPool thread or ThreadDeath thrown. This is deprecated. Lock-up might occur.");
                        throw td;
                    }
                    catch (Error e) {
                        ThreadPool.this.targetE = e;
                    }
                    catch (RuntimeException re) {
                        ThreadPool.this.targetRE = re;
                    }
                    catch (Throwable ue) {
                        ThreadPool.this.targetRE = new RuntimeException("Unchecked exception thrown by target's run() method in pool " + ThreadPool.this.poolName + ".");
                    }
                    ThreadPool.this.putInIdleList(this);
                    this.target = null;
                    if (this.lock == null) continue;
                    Object object = this.lock;
                    synchronized (object) {
                        if (this.doNotifyAll) {
                            this.lock.notifyAll();
                        } else {
                            this.lock.notify();
                        }
                    }
                }
            }
        }

        synchronized void setTarget(Runnable target, Object lock, boolean notifyAll) {
            this.target = target;
            this.lock = lock;
            this.doNotifyAll = notifyAll;
            this.notify();
        }
    }
}

