/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pcl;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.pcl.PCLGenerator;

class HardcodedFonts {
    private static Log log = LogFactory.getLog((Class)HardcodedFonts.class);

    HardcodedFonts() {
    }

    public static boolean setFont(PCLGenerator gen, String name, int size, String text) throws IOException {
        byte[] encoded = text.getBytes("ISO-8859-1");
        int c = encoded.length;
        for (int i = 0; i < c; ++i) {
            if (encoded[i] != 63 || text.charAt(i) == '?') continue;
            return false;
        }
        return HardcodedFonts.selectFont(gen, name, size);
    }

    private static boolean selectFont(PCLGenerator gen, String name, int size) throws IOException {
        int fontcode = 0;
        if (name.length() > 1 && name.charAt(0) == 'F') {
            try {
                fontcode = Integer.parseInt(name.substring(1));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        String formattedSize = gen.formatDouble2((double)size / 1000.0);
        switch (fontcode) {
            case 1: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s1p" + formattedSize + "v0s0b16602T");
                break;
            }
            case 2: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s1p" + formattedSize + "v1s0b16602T");
                break;
            }
            case 3: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s1p" + formattedSize + "v0s3b16602T");
                break;
            }
            case 4: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s1p" + formattedSize + "v1s3b16602T");
                break;
            }
            case 5: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s1p" + formattedSize + "v0s0b16901T");
                break;
            }
            case 6: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s1p" + formattedSize + "v1s0b16901T");
                break;
            }
            case 7: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s1p" + formattedSize + "v0s3b16901T");
                break;
            }
            case 8: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s1p" + formattedSize + "v1s3b16901T");
                break;
            }
            case 9: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s0p" + gen.formatDouble2(120.01f / ((float)size / 1000.0f)) + "h0s0b4099T");
                break;
            }
            case 10: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s0p" + gen.formatDouble2(120.01f / ((float)size / 1000.0f)) + "h1s0b4099T");
                break;
            }
            case 11: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s0p" + gen.formatDouble2(120.01f / ((float)size / 1000.0f)) + "h0s3b4099T");
                break;
            }
            case 12: {
                gen.writeCommand("(0N");
                gen.writeCommand("(s0p" + gen.formatDouble2(120.01f / ((float)size / 1000.0f)) + "h1s3b4099T");
                break;
            }
            case 13: {
                return false;
            }
            case 14: {
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }
}

