/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml;

import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import org.opensaml.MalformedException;
import org.opensaml.SAMLConfig;
import org.opensaml.SAMLException;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLSignedObject;
import org.opensaml.XML;
import org.opensaml.artifact.Artifact;
import org.opensaml.artifact.ArtifactParseException;
import org.opensaml.artifact.ArtifactParserException;
import org.opensaml.artifact.SAMLArtifact;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SAMLRequest
extends SAMLSignedObject
implements Cloneable {
    protected int minor;
    protected String requestId;
    protected Date issueInstant;
    protected ArrayList respondWiths;
    protected SAMLQuery query;
    protected ArrayList assertionIdRefs;
    protected ArrayList artifacts;

    protected void insertSignature() throws SAMLException {
        Element element = XML.getFirstChildElement(this.root);
        while (element != null && XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith")) {
            element = XML.getNextSiblingElement(element);
        }
        this.root.insertBefore(this.getSignatureElement(), element);
    }

    public SAMLRequest() {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
    }

    public SAMLRequest(SAMLQuery sAMLQuery) throws SAMLException {
        this(sAMLQuery, SAMLConfig.instance().getDefaultIDProvider().getIdentifier(), new Date());
    }

    public SAMLRequest(SAMLQuery sAMLQuery, String string, Date date) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.requestId = XML.assign(string);
        this.issueInstant = date;
        if (sAMLQuery != null) {
            this.query = (SAMLQuery)sAMLQuery.setParent(this);
        }
    }

    public SAMLRequest(Collection collection) throws SAMLException {
        this(collection, SAMLConfig.instance().getDefaultIDProvider().getIdentifier(), new Date());
    }

    public SAMLRequest(Collection collection, String string, Date date) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.requestId = XML.assign(string);
        this.issueInstant = date;
        if (collection != null && !collection.isEmpty()) {
            Iterator iterator = collection.iterator();
            Object e = iterator.next();
            if (e instanceof Artifact) {
                this.artifacts.add(e);
                while (iterator.hasNext()) {
                    this.artifacts.add((Artifact)iterator.next());
                }
            } else if (e instanceof String) {
                this.assertionIdRefs.add(e);
                while (iterator.hasNext()) {
                    this.assertionIdRefs.add((String)iterator.next());
                }
            } else {
                throw new MalformedException("SAMLRequest() collection parameter must contain Artifacts or Strings");
            }
        }
    }

    public SAMLRequest(Element element) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.fromDOM(element);
    }

    public SAMLRequest(InputStream inputStream) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.fromDOM(SAMLRequest.fromStream(inputStream));
    }

    public SAMLRequest(InputStream inputStream, int n) throws SAMLException {
        this.minor = this.config.getBooleanProperty("org.opensaml.compatibility-mode") ? 0 : 1;
        this.requestId = null;
        this.issueInstant = new Date();
        this.respondWiths = new ArrayList();
        this.query = null;
        this.assertionIdRefs = new ArrayList();
        this.artifacts = new ArrayList();
        this.fromDOM(SAMLRequest.fromStream(inputStream, n));
    }

    public void fromDOM(Element element) throws SAMLException {
        Object object;
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed(element, "urn:oasis:names:tc:SAML:1.0:protocol", "Request")) {
            throw new MalformedException(SAMLException.RESPONDER, "SAMLRequest.fromDOM() requires samlp:Request at root");
        }
        if (Integer.parseInt(element.getAttributeNS(null, "MajorVersion")) != 1) {
            throw new MalformedException(SAMLException.VERSION, "SAMLRequest.fromDOM() detected incompatible request major version of " + element.getAttributeNS(null, "MajorVersion"));
        }
        this.minor = Integer.parseInt(element.getAttributeNS(null, "MinorVersion"));
        this.requestId = XML.assign(element.getAttributeNS(null, "RequestID"));
        if (this.minor > 0) {
            element.setIdAttributeNode(element.getAttributeNodeNS(null, "RequestID"), true);
        }
        try {
            object = null;
            String string = XML.assign(element.getAttributeNS(null, "IssueInstant"));
            int n = string.indexOf(46);
            object = n > 0 ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'") : new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("UTC"));
            this.issueInstant = ((DateFormat)object).parse(string);
        }
        catch (ParseException parseException) {
            throw new MalformedException(SAMLException.REQUESTER, "SAMLRequest.fromDOM() detected an invalid datetime while parsing request", (Exception)parseException);
        }
        object = XML.getFirstChildElement(element);
        while (object != null && XML.isElementNamed((Element)object, "urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith")) {
            this.respondWiths.add(XML.getQNameTextNode((Text)object.getFirstChild()));
            object = XML.getNextSiblingElement((Node)object);
        }
        if (XML.isElementNamed((Element)object, "http://www.w3.org/2000/09/xmldsig#", "Signature")) {
            object = XML.getNextSiblingElement((Node)object);
        }
        if (XML.isElementNamed((Element)object, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference")) {
            while (object != null && object.hasChildNodes()) {
                this.assertionIdRefs.add(object.getFirstChild().getNodeValue());
                object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference");
            }
        } else if (XML.isElementNamed((Element)object, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact")) {
            while (object != null && object.hasChildNodes()) {
                try {
                    this.artifacts.add(SAMLArtifact.getTypeCode(object.getFirstChild().getNodeValue()).getParser().parse(object.getFirstChild().getNodeValue()));
                }
                catch (ArtifactParseException artifactParseException) {
                    throw new MalformedException(SAMLException.REQUESTER, "SAMLRequest.fromDOM() unable to parse artifact", (Exception)artifactParseException);
                }
                catch (ArtifactParserException artifactParserException) {
                    throw new MalformedException(SAMLException.REQUESTER, "SAMLRequest.fromDOM() unable to parse artifact", (Exception)artifactParserException);
                }
                object = XML.getNextSiblingElement((Node)object, "urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact");
            }
        } else {
            this.query = (SAMLQuery)SAMLQuery.getInstance((Element)object).setParent(this);
        }
        this.checkValidity();
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public void setMinorVersion(int n) {
        this.minor = n;
        this.setDirty(true);
    }

    public String getId() {
        return this.requestId;
    }

    public void setId(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.requestId = XML.assign(string);
        this.setDirty(true);
    }

    public Date getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("issueInstant cannot be null");
        }
        this.issueInstant = date;
        this.setDirty(true);
    }

    public Iterator getRespondWiths() {
        return this.respondWiths.iterator();
    }

    public void setRespondWiths(Collection collection) {
        this.respondWiths.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addRespondWith((QName)iterator.next());
            }
        }
        this.setDirty(true);
    }

    public void addRespondWith(QName qName) {
        if (qName == null) {
            throw new IllegalArgumentException("respondWith cannot be null");
        }
        this.respondWiths.add(qName);
        this.setDirty(true);
    }

    public void removeRespondWith(int n) throws IndexOutOfBoundsException {
        this.respondWiths.remove(n);
        this.setDirty(true);
    }

    public SAMLQuery getQuery() {
        return this.query;
    }

    public void setQuery(SAMLQuery sAMLQuery) throws SAMLException {
        if (sAMLQuery != null) {
            sAMLQuery.setParent(this);
            this.setAssertionIdRefs(null);
            this.setArtifacts(null);
        }
        this.query = sAMLQuery;
        this.setDirty(true);
    }

    public Iterator getAssertionIdRefs() {
        return this.assertionIdRefs.iterator();
    }

    public void addAssertionIdRef(String string) {
        if (XML.isEmpty(string)) {
            throw new IllegalArgumentException("ref cannot be null or empty");
        }
        try {
            this.setQuery(null);
        }
        catch (SAMLException sAMLException) {
            // empty catch block
        }
        this.setArtifacts(null);
        this.assertionIdRefs.add(string);
    }

    public void setAssertionIdRefs(Collection collection) {
        this.assertionIdRefs.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addAssertionIdRef((String)iterator.next());
            }
        }
    }

    public void removeAssertionIdRef(int n) throws IndexOutOfBoundsException {
        this.assertionIdRefs.remove(n);
        this.setDirty(true);
    }

    public Iterator getArtifacts() {
        return this.artifacts.iterator();
    }

    public void setArtifacts(Collection collection) {
        this.artifacts.clear();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.addArtifact((Artifact)iterator.next());
            }
        }
    }

    public void addArtifact(Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("artifact cannot be null or empty");
        }
        try {
            this.setQuery(null);
        }
        catch (SAMLException sAMLException) {
            // empty catch block
        }
        this.setAssertionIdRefs(null);
        this.artifacts.add(artifact);
    }

    public void removeArtifact(int n) throws IndexOutOfBoundsException {
        this.artifacts.remove(n);
        this.setDirty(true);
    }

    protected Element buildRoot(Document document, boolean bl) {
        Element element = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "Request");
        if (bl) {
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return element;
    }

    public Node toDOM(Document document, boolean bl) throws SAMLException {
        super.toDOM(document, bl);
        Element element = (Element)this.root;
        if (this.dirty) {
            if (this.requestId == null) {
                this.requestId = this.config.getDefaultIDProvider().getIdentifier();
            }
            if (this.issueInstant == null) {
                this.issueInstant = new Date();
            }
            element.setAttributeNS(null, "MajorVersion", "1");
            element.setAttributeNS(null, "MinorVersion", String.valueOf(this.minor));
            element.setAttributeNS(null, "RequestID", this.requestId);
            if (this.minor > 0) {
                element.setIdAttributeNS(null, "RequestID", true);
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            element.setAttributeNS(null, "IssueInstant", simpleDateFormat.format(this.issueInstant));
            Iterator iterator = this.respondWiths.iterator();
            while (iterator.hasNext()) {
                QName qName = (QName)iterator.next();
                Element element2 = document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "RespondWith");
                String string = qName.getNamespaceURI();
                if (string == null) {
                    string = "";
                }
                if (!"urn:oasis:names:tc:SAML:1.0:assertion".equals(string)) {
                    element2.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rw", string);
                    string = "rw:";
                } else {
                    string = "saml:";
                }
                element2.appendChild(document.createTextNode(string + qName.getLocalPart()));
                element.appendChild(element2);
            }
            if (this.query != null) {
                element.appendChild(this.query.toDOM(document, false));
            } else if (this.assertionIdRefs.size() > 0) {
                iterator = this.assertionIdRefs.iterator();
                while (iterator.hasNext()) {
                    element.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:assertion", "saml:AssertionIDReference")).appendChild(document.createTextNode((String)iterator.next()));
                }
            } else {
                iterator = this.artifacts.iterator();
                while (iterator.hasNext()) {
                    element.appendChild(document.createElementNS("urn:oasis:names:tc:SAML:1.0:protocol", "AssertionArtifact")).appendChild(document.createTextNode(((Artifact)iterator.next()).encode()));
                }
            }
            this.setDirty(false);
        } else if (bl) {
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:1.0:protocol");
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:saml", "urn:oasis:names:tc:SAML:1.0:assertion");
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:samlp", "urn:oasis:names:tc:SAML:1.0:protocol");
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            ((Element)this.root).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        }
        return this.root;
    }

    public void checkValidity() throws SAMLException {
        if (this.requestId == null || this.query == null && this.assertionIdRefs.size() == 0 && this.artifacts.size() == 0) {
            throw new MalformedException("Request is invalid, must have an ID and query, assertion references, or artifacts");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object clone() throws CloneNotSupportedException {
        SAMLRequest sAMLRequest = (SAMLRequest)super.clone();
        try {
            sAMLRequest.respondWiths = (ArrayList)this.respondWiths.clone();
            sAMLRequest.query = (SAMLQuery)((SAMLQuery)this.query.clone()).setParent(sAMLRequest);
            sAMLRequest.assertionIdRefs = (ArrayList)this.assertionIdRefs.clone();
            sAMLRequest.artifacts = new ArrayList();
            Iterator iterator = this.artifacts.iterator();
            while (iterator.hasNext()) {
                String string = ((Artifact)iterator.next()).encode();
                try {
                    sAMLRequest.artifacts.add(SAMLArtifact.getTypeCode(string).getParser().parse(string));
                }
                catch (ArtifactParseException artifactParseException) {
                    throw new RuntimeException("Unable to clone artifact");
                }
                catch (ArtifactParserException artifactParserException) {
                    throw new RuntimeException("Unable to clone artifact");
                    return sAMLRequest;
                }
            }
        }
        catch (SAMLException sAMLException) {
            throw new CloneNotSupportedException(sAMLException.getMessage());
        }
    }
}

