/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.impl.XMLConverter;
import org.apache.chemistry.opencmis.commons.impl.XMLUtils;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomDocumentBase;

public class ServiceDocument
extends AtomDocumentBase {
    public void startServiceDocument() throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("app", "service", "http://www.w3.org/2007/app");
        xsw.writeNamespace("atom", "http://www.w3.org/2005/Atom");
        xsw.writeNamespace("cmis", "http://docs.oasis-open.org/ns/cmis/core/200908/");
        xsw.writeNamespace("cmisra", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        xsw.writeNamespace("app", "http://www.w3.org/2007/app");
        this.writeAllCustomNamespace();
    }

    public void endServiceDocument() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void startWorkspace(String title) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("app", "workspace", "http://www.w3.org/2007/app");
        XMLUtils.write((XMLStreamWriter)xsw, (String)"atom", (String)"http://www.w3.org/2005/Atom", (String)"title", (String)title);
    }

    public void endWorkspace() throws XMLStreamException {
        this.getWriter().writeEndElement();
    }

    public void writeRepositoryInfo(RepositoryInfo repInfo, CmisVersion cmisVersion) throws XMLStreamException {
        XMLConverter.writeRepositoryInfo((XMLStreamWriter)this.getWriter(), (CmisVersion)cmisVersion, (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (RepositoryInfo)repInfo);
    }

    public void writeUriTemplate(String template, String type, String mediatype) throws XMLStreamException {
        XMLStreamWriter xsw = this.getWriter();
        xsw.writeStartElement("cmisra", "uritemplate", "http://docs.oasis-open.org/ns/cmis/restatom/200908/");
        XMLUtils.write((XMLStreamWriter)xsw, (String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (String)"template", (String)template);
        XMLUtils.write((XMLStreamWriter)xsw, (String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (String)"type", (String)type);
        XMLUtils.write((XMLStreamWriter)xsw, (String)"cmisra", (String)"http://docs.oasis-open.org/ns/cmis/restatom/200908/", (String)"mediatype", (String)mediatype);
        xsw.writeEndElement();
    }
}

