/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.manifoldcf.agents.interfaces.IPipelineSpecificationBasic;
import org.apache.manifoldcf.agents.interfaces.IncrementalIngesterFactory;
import org.apache.manifoldcf.agents.interfaces.IngestStatuses;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;
import org.apache.manifoldcf.crawler.interfaces.BlockingDocuments;
import org.apache.manifoldcf.crawler.interfaces.DepthStatistics;
import org.apache.manifoldcf.crawler.interfaces.IJobDescription;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.JobManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.QueueTracker;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectorPoolFactory;
import org.apache.manifoldcf.crawler.interfaces.ReprioritizationTrackerFactory;
import org.apache.manifoldcf.crawler.system.DocumentQueue;
import org.apache.manifoldcf.crawler.system.Logging;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.PipelineSpecificationBasic;
import org.apache.manifoldcf.crawler.system.QueuedDocument;
import org.apache.manifoldcf.crawler.system.QueuedDocumentSet;
import org.apache.manifoldcf.crawler.system.WorkerResetManager;

public class StufferThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: StufferThread.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final String stufferThreadLockName = "_STUFFERTHREAD_LOCK";
    protected static final String stufferThreadLastTimeDatumName = "_STUFFERTHREAD_LASTTIME";
    protected final DocumentQueue documentQueue;
    protected final WorkerResetManager resetManager;
    protected final int lowestStuffAmt;
    protected int stuffAmt;
    protected final int lowWaterMark;
    protected final QueueTracker queueTracker;
    protected final BlockingDocuments blockingDocuments;
    protected final String processID;

    public StufferThread(DocumentQueue documentQueue, int n, WorkerResetManager resetManager, QueueTracker qt, BlockingDocuments blockingDocuments, float lowWaterFactor, float stuffSizeFactor, String processID) throws ManifoldCFException {
        this.documentQueue = documentQueue;
        this.lowWaterMark = (int)(lowWaterFactor * (float)n);
        this.stuffAmt = this.lowestStuffAmt = (int)(stuffSizeFactor * (float)n);
        this.resetManager = resetManager;
        this.queueTracker = qt;
        this.blockingDocuments = blockingDocuments;
        this.processID = processID;
        this.setName("Stuffer thread");
        this.setDaemon(true);
        this.setPriority(this.getPriority() + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.resetManager.registerMe();
        try {
            threadContext = ThreadContextFactory.make();
            mgr = RepositoryConnectionManagerFactory.make(threadContext);
            ingester = IncrementalIngesterFactory.make((IThreadContext)threadContext);
            jobManager = JobManagerFactory.make(threadContext);
            lockManager = LockManagerFactory.make((IThreadContext)threadContext);
            rt = ReprioritizationTrackerFactory.make(threadContext);
            repositoryConnectorPool = RepositoryConnectorPoolFactory.make(threadContext);
            Logging.threads.debug((Object)("Stuffer thread: Low water mark is " + Integer.toString(this.lowWaterMark) + "; amount per stuffing is " + Integer.toString(this.stuffAmt)));
            documentSets = new HashMap<Long, ArrayList<QueuedDocument>>();
            jobDescriptionMap = new HashMap<Long, IJobDescription>();
            connectionMap = new HashMap<String, IRepositoryConnection>();
            lastQueueStart = -1L;
            lastQueueEnd = -1L;
            lastQueueFullResults = false;
            while (true) {
                try {
                    block20: while (true) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        this.resetManager.waitForReset(threadContext);
                        isEmpty = this.documentQueue.checkIfEmpty(this.lowWaterMark);
                        if (!isEmpty) {
                            ManifoldCF.sleep((long)1000L);
                            continue;
                        }
                        queueNeededTime = System.currentTimeMillis();
                        Logging.threads.debug((Object)"Document stuffer thread woke up");
                        if (lastQueueFullResults) {
                            if (lastQueueEnd - lastQueueStart >= queueNeededTime - lastQueueEnd) {
                                this.stuffAmt *= 2;
                            } else if (lastQueueEnd - lastQueueStart < 4L * (queueNeededTime - lastQueueEnd)) {
                                this.stuffAmt /= 2;
                                if (this.stuffAmt < this.lowestStuffAmt) {
                                    this.stuffAmt = this.lowestStuffAmt;
                                }
                            }
                        }
                        lockManager.enterWriteLock("_STUFFERTHREAD_LOCK");
                        try {
                            stuffingStartTime = StufferThread.readLastTime(lockManager);
                            stuffingEndTime = System.currentTimeMillis();
                            StufferThread.writeLastTime(lockManager, stuffingEndTime);
                        }
                        finally {
                            lockManager.leaveWriteLock("_STUFFERTHREAD_LOCK");
                        }
                        lastQueueStart = System.currentTimeMillis();
                        depthStatistics = new DepthStatistics();
                        descs = jobManager.getNextDocuments(this.processID, this.stuffAmt, stuffingEndTime, stuffingEndTime - stuffingStartTime, this.blockingDocuments, this.queueTracker.getCurrentStatistics(), depthStatistics);
                        lastQueueEnd = System.currentTimeMillis();
                        lastQueueFullResults = descs.length == this.stuffAmt;
                        rt.assessMinimumDepth(depthStatistics.getBins());
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        if (Logging.threads.isDebugEnabled()) {
                            Logging.threads.debug((Object)("Stuffer thread: Found " + Integer.toString(descs.length) + " documents to queue"));
                        }
                        if (descs.length == 0) {
                            ManifoldCF.sleep((long)2000L);
                            continue;
                        }
                        jobDescriptionMap.clear();
                        connectionMap.clear();
                        jobs = new IJobDescription[descs.length];
                        connections = new IRepositoryConnection[descs.length];
                        versions = new HashMap[descs.length];
                        pipelineSpecifications = new IPipelineSpecificationBasic[descs.length];
                        documentClasses = new String[descs.length];
                        documentIDHashes = new String[descs.length];
                        connectionNames = new HashSet<String>();
                        for (i = 0; i < descs.length; ++i) {
                            dd = descs[i];
                            job = (IJobDescription)jobDescriptionMap.get(dd.getJobID());
                            if (job == null) {
                                job = jobManager.load(dd.getJobID(), true);
                                jobDescriptionMap.put(dd.getJobID(), job);
                            }
                            jobs[i] = job;
                            connectionName = job.getConnectionName();
                            connectionNames.add(connectionName);
                            documentClasses[i] = connectionName;
                            pipelineSpecifications[i] = new PipelineSpecificationBasic(job);
                            connection = (IRepositoryConnection)connectionMap.get(connectionName);
                            if (connection == null) {
                                connection = mgr.load(connectionName);
                                connectionMap.put(connectionName, connection);
                            }
                            connections[i] = connection;
                            documentIDHashes[i] = dd.getDocumentIdentifierHash();
                        }
                        statuses = new IngestStatuses();
                        ingester.getPipelineDocumentIngestDataMultiple(statuses, pipelineSpecifications, documentClasses, documentIDHashes);
                        for (i = 0; i < descs.length; ++i) {
                            versions[i] = new HashMap<K, V>();
                            for (j = 0; j < pipelineSpecifications[i].getOutputCount(); ++j) {
                                outputName = pipelineSpecifications[i].getStageConnectionName(pipelineSpecifications[i].getOutputStage(j));
                                statusSet = statuses.getStatus(documentClasses[i], documentIDHashes[i], outputName);
                                if (statusSet == null) continue;
                                versions[i].put(outputName, statusSet);
                            }
                        }
                        documentSets.clear();
                        orderingKeys = new String[connectionNames.size()];
                        grabConnections = new IRepositoryConnection[connectionNames.size()];
                        z = 0;
                        statusSet = connectionNames.iterator();
                        while (statusSet.hasNext()) {
                            orderingKeys[z] = connectionName = (String)statusSet.next();
                            grabConnections[z] = connection = (IRepositoryConnection)connectionMap.get(connectionName);
                            ++z;
                        }
                        descBinNames = new String[descs.length][];
                        descMaxDocuments = new int[descs.length];
                        try {
                            connectors = repositoryConnectorPool.grabMultiple(orderingKeys, grabConnections);
                            try {
                                connectorMap = new HashMap<String, IRepositoryConnector>();
                                for (z = 0; z < orderingKeys.length; ++z) {
                                    connectorMap.put(orderingKeys[z], connectors[z]);
                                }
                                for (i = 0; i < descs.length; ++i) {
                                    connection = connections[i];
                                    connector = (IRepositoryConnector)connectorMap.get(connection.getName());
                                    if (connector == null) {
                                        maxDocuments = 1;
                                        binNames = new String[]{""};
                                    } else {
                                        maxDocuments = connector.getMaxDocumentRequest();
                                        binNames = connector.getBinNames(descs[i].getDocumentIdentifier());
                                    }
                                    descBinNames[i] = binNames;
                                    descMaxDocuments[i] = maxDocuments;
                                }
                            }
                            finally {
                                repositoryConnectorPool.releaseMultiple(grabConnections, connectors);
                            }
                        }
                        catch (ManifoldCFException e) {
                            if (e.getErrorCode() == 2) {
                                throw e;
                            }
                            Logging.threads.error((Object)("Stuffer thread ManifoldCF Exception thrown: " + e.getMessage() + " - continuing"), (Throwable)e);
                        }
                        catch (OutOfMemoryError e) {
                            System.err.println("agents process ran out of memory - shutting down");
                            e.printStackTrace(System.err);
                            ManifoldCF.systemExit((int)-200);
                        }
                        catch (Throwable e) {
                            Logging.threads.fatal((Object)("Stuffer thread Throwable thrown: " + e.getMessage() + " - continuing"), e);
                        }
                        for (i = 0; i < descs.length; ++i) {
                            jobID = jobs[i].getID();
                            binNames = descBinNames[i];
                            if (binNames == null) {
                                binNames = new String[]{""};
                            }
                            if ((maxDocuments = descMaxDocuments[i]) == 0) {
                                maxDocuments = 1;
                            }
                            qd = new QueuedDocument(descs[i], versions[i], binNames);
                            set = (ArrayList<QueuedDocument>)documentSets.get(jobID);
                            if (set == null) {
                                set = new ArrayList<QueuedDocument>();
                                documentSets.put(jobID, set);
                            }
                            set.add(qd);
                            if (Logging.scheduling.isDebugEnabled()) {
                                sb = new StringBuilder();
                                j = 0;
                                while (j < binNames.length) {
                                    sb.append(binNames[j++]).append(" ");
                                }
                                Logging.scheduling.debug((Object)("Putting document '" + descs[i].getDocumentIdentifier() + "' with bins [" + sb.toString() + "] onto active queue"));
                            }
                            this.queueTracker.addRecord(binNames);
                            if (set.size() < maxDocuments) continue;
                            qds = new QueuedDocumentSet(set, jobs[i], connections[i]);
                            this.documentQueue.addDocument(qds);
                            set.clear();
                        }
                        i = 0;
                        while (true) {
                            if (i < descs.length) ** break;
                            continue block20;
                            jobID = jobs[i].getID();
                            x = (List)documentSets.get(jobID);
                            if (x != null && x.size() > 0) {
                                set = new QueuedDocumentSet(x, jobs[i], connections[i]);
                                this.documentQueue.addDocument(set);
                                documentSets.remove(jobID);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        this.resetManager.noteEvent();
                        Logging.threads.error((Object)("Stuffer thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.threads.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    ManifoldCF.systemExit((int)1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    ManifoldCF.systemExit((int)-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.threads.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.threads.fatal((Object)("StufferThread initialization error tossed: " + e.getMessage()), e);
            ManifoldCF.systemExit((int)-300);
        }
    }

    protected static long readLastTime(ILockManager lockManager) throws ManifoldCFException {
        byte[] data = lockManager.readData(stufferThreadLastTimeDatumName);
        if (data == null || data.length != 8) {
            return System.currentTimeMillis();
        }
        long value = ((long)data[0] & 0xFFL) + ((long)data[1] << 8 & 0xFF00L) + ((long)data[2] << 16 & 0xFF0000L) + ((long)data[3] << 24 & 0xFF000000L) + ((long)data[4] << 32 & 0xFF00000000L) + ((long)data[5] << 40 & 0xFF0000000000L) + ((long)data[6] << 48 & 0xFF000000000000L) + ((long)data[7] << 56 & 0xFF00000000000000L);
        return value;
    }

    protected static void writeLastTime(ILockManager lockManager, long lastTime) throws ManifoldCFException {
        byte[] data = new byte[]{(byte)(lastTime & 0xFFL), (byte)(lastTime >> 8 & 0xFFL), (byte)(lastTime >> 16 & 0xFFL), (byte)(lastTime >> 24 & 0xFFL), (byte)(lastTime >> 32 & 0xFFL), (byte)(lastTime >> 40 & 0xFFL), (byte)(lastTime >> 48 & 0xFFL), (byte)(lastTime >> 56 & 0xFFL)};
        lockManager.writeData(stufferThreadLastTimeDatumName, data);
    }
}

