/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

public enum Permission {
    NONE("none"),
    READ("read"),
    WRITE("write"),
    ALL("all");

    private final String value;

    private Permission(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static Permission fromValue(String v) {
        for (Permission c : Permission.values()) {
            if (!c.value.equals(v)) continue;
            return c;
        }
        throw new IllegalArgumentException(v);
    }

    public static Permission fromCmisString(String strPerm) {
        Permission permission;
        if (strPerm.equals(EnumBasicPermissions.CMIS_READ.value())) {
            permission = READ;
        } else if (strPerm.equals(EnumBasicPermissions.CMIS_WRITE.value())) {
            permission = WRITE;
        } else if (strPerm.equals(EnumBasicPermissions.CMIS_ALL.value())) {
            permission = ALL;
        } else {
            throw new IllegalArgumentException("InMemory only supports CMIS basic permissions read, write, all.");
        }
        return permission;
    }

    public String toCmisString() {
        if (this.equals((Object)READ)) {
            return EnumBasicPermissions.CMIS_READ.value();
        }
        if (this.equals((Object)WRITE)) {
            return EnumBasicPermissions.CMIS_WRITE.value();
        }
        if (this.equals((Object)ALL)) {
            return EnumBasicPermissions.CMIS_ALL.value();
        }
        return "";
    }

    private static enum EnumBasicPermissions {
        CMIS_READ("cmis:read"),
        CMIS_WRITE("cmis:write"),
        CMIS_ALL("cmis:all");

        private final String value;

        private EnumBasicPermissions(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static EnumBasicPermissions fromValue(String v) {
            for (EnumBasicPermissions c : EnumBasicPermissions.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

