/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.navmenu;

import java.util.Iterator;
import java.util.StringTokenizer;
import javax.faces.component.ActionSource;
import javax.faces.component.UIComponent;
import javax.faces.component.UISelectItem;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.ActionListener;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlCommandNavigationItem;
import org.apache.myfaces.custom.navmenu.htmlnavmenu.HtmlPanelNavigationMenu;

public abstract class AbstractUINavigationMenuItem
extends UISelectItem
implements UserRoleAware,
ActionSource {
    private static final boolean DEFAULT_IMMEDIATE = true;
    public static final String COMPONENT_TYPE = "org.apache.myfaces.NavigationMenuItem";
    public static final String COMPONENT_FAMILY = "javax.faces.SelectItem";
    private static final boolean DEFAULT_RENDERED = true;
    private Boolean _rendered = null;

    public String getFamily() {
        return COMPONENT_FAMILY;
    }

    public abstract String getIcon();

    public abstract boolean isSplit();

    public abstract boolean isOpen();

    public abstract void setOpen(boolean var1);

    public abstract void setActive(boolean var1);

    public abstract boolean isActive();

    public abstract boolean isImmediate();

    public abstract String getExternalLink();

    public abstract void setAction(MethodBinding var1);

    public abstract MethodBinding getAction();

    public abstract void setActionListener(MethodBinding var1);

    public abstract MethodBinding getActionListener();

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getFacesListeners(ActionListener.class);
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public abstract String getTarget();

    public abstract boolean isDisabled();

    public abstract String getDisabledStyle();

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof ActionEvent) {
            ActionListener defaultActionListener;
            FacesContext context = this.getFacesContext();
            MethodBinding actionListenerBinding = this.getActionListener();
            if (actionListenerBinding != null) {
                try {
                    actionListenerBinding.invoke(context, new Object[]{event});
                }
                catch (EvaluationException e) {
                    Throwable cause = e.getCause();
                    if (cause != null && cause instanceof AbortProcessingException) {
                        throw (AbortProcessingException)cause;
                    }
                    throw e;
                }
            }
            if ((defaultActionListener = context.getApplication().getActionListener()) != null) {
                defaultActionListener.processAction((ActionEvent)event);
            }
        }
    }

    public abstract String getDisabledStyleClass();

    public abstract String getActiveOnViewIds();

    protected abstract String getLocalActiveOnViewIds();

    public String getActiveOnViewIdsDirectly() {
        return this.getLocalActiveOnViewIds();
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole((UIComponent)this)) {
            return false;
        }
        if (this._rendered != null) {
            return this._rendered;
        }
        ValueBinding vb = this.getValueBinding("rendered");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : true;
    }

    public void setRendered(boolean rendered) {
        this._rendered = rendered;
    }

    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{super.saveState(facesContext), this._rendered};
        return values;
    }

    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(facesContext, values[0]);
        this._rendered = (Boolean)values[1];
    }

    public void toggleActive(FacesContext context) {
        StringTokenizer tokenizer = new StringTokenizer(this.getActiveOnViewIdsDirectly(), ";");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.trim().equals(context.getViewRoot().getViewId())) {
                this.deactivateAll();
                this.setActive(true);
                this.openParents();
                continue;
            }
            this.setActive(false);
        }
    }

    private void openParents() {
        AbstractUINavigationMenuItem comp = this;
        while ((comp = comp.getParent()) instanceof AbstractUINavigationMenuItem) {
            AbstractUINavigationMenuItem parent = comp;
            if (!parent.isOpen()) {
                parent.setOpen(true);
                continue;
            }
            return;
        }
    }

    public void deactivateAll() {
        UIComponent parent;
        for (parent = this.getParent(); !(parent instanceof HtmlPanelNavigationMenu) && parent != null; parent = parent.getParent()) {
        }
        if (parent == null) {
            throw new IllegalStateException("no PanelNavigationMenu!");
        }
        HtmlPanelNavigationMenu root = (HtmlPanelNavigationMenu)parent;
        Iterator it = root.getChildren().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof AbstractUINavigationMenuItem) {
                AbstractUINavigationMenuItem navItem = (AbstractUINavigationMenuItem)o;
                navItem.setActive(false);
                if (navItem.getChildCount() > 0) {
                    navItem.deactivateChildren();
                }
            }
            if (!(o instanceof HtmlCommandNavigationItem)) continue;
            HtmlCommandNavigationItem current = (HtmlCommandNavigationItem)o;
            current.setActive(false);
            if (current.getChildCount() <= 0) continue;
            current.deactivateChildren();
        }
    }

    public void deactivateChildren() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof AbstractUINavigationMenuItem)) continue;
            AbstractUINavigationMenuItem current = (AbstractUINavigationMenuItem)o;
            current.setActive(false);
            if (current.getChildCount() <= 0) continue;
            current.deactivateChildren();
        }
    }

    public Boolean getActiveDirectly() {
        return this.isActive();
    }
}

